/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.manager.oracle;

import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.sqoop.lib.SqoopRecord;
import org.apache.sqoop.manager.oracle.OraOopLog;
import org.apache.sqoop.manager.oracle.OraOopLogFactory;
import org.apache.sqoop.manager.oracle.OraOopOracleQueries;
import org.apache.sqoop.manager.oracle.OraOopOutputFormatBase;
import org.apache.sqoop.manager.oracle.OraOopUtilities;
import org.apache.sqoop.manager.oracle.OracleTable;
import org.apache.sqoop.manager.oracle.OracleUtils;

public class OraOopOutputFormatUpdate<K extends SqoopRecord, V>
extends OraOopOutputFormatBase<K, V> {
    private static final OraOopLog LOG = OraOopLogFactory.getLog(OraOopOutputFormatUpdate.class);

    @Override
    public RecordWriter<K, V> getRecordWriter(TaskAttemptContext context) throws IOException {
        OraOopUtilities.checkJavaSecurityEgd();
        Configuration conf = context.getConfiguration();
        int mapperId = this.getMapperId(context);
        this.applyMapperJdbcUrl(context, mapperId);
        UpdateMode updateMode = OraOopUtilities.getExportUpdateMode(conf);
        boolean useAppendValuesOracleHint = false;
        if (updateMode == UpdateMode.Merge || updateMode == UpdateMode.Update) {
            useAppendValuesOracleHint = this.canUseOracleAppendValuesHint(context);
        }
        if (useAppendValuesOracleHint = this.allowUserToOverrideUseOfTheOracleAppendValuesHint(context, useAppendValuesOracleHint)) {
            this.updateBatchSizeInConfigurationToAllowOracleAppendValuesHint(context);
        }
        OraOopDBRecordWriterUpdate result = null;
        try {
            result = new OraOopDBRecordWriterUpdate(context, mapperId, updateMode, useAppendValuesOracleHint);
        }
        catch (NoClassDefFoundError ex) {
            throw new IOException(String.format("Unable to create an instance of OraOopDBRecordWriterUpdate.\nThe classpath is:\n%s", OraOopUtilities.getJavaClassPath()), ex);
        }
        catch (Exception ex) {
            throw new IOException(ex);
        }
        try {
            result.getExportTableAndColumns(context);
        }
        catch (SQLException ex) {
            throw new IOException(ex);
        }
        return result;
    }

    public class OraOopDBRecordWriterUpdate
    extends OraOopOutputFormatBase.OraOopDBRecordWriterBase {
        private String sqlStatement;
        private String[] updateColumnNames;
        private UpdateMode updateMode;
        private boolean useAppendValuesOracleHint;
        private boolean tableHasOraOopPartitions;
        private long numberOfRowsSkipped;

        public OraOopDBRecordWriterUpdate(TaskAttemptContext context, int mapperId, UpdateMode updateMode, boolean useAppendValuesOracleHint) throws ClassNotFoundException, SQLException {
            super(context, mapperId);
            Configuration conf = context.getConfiguration();
            this.updateColumnNames = OraOopUtilities.getExportUpdateKeyColumnNames(conf);
            this.useAppendValuesOracleHint = useAppendValuesOracleHint;
            this.updateMode = updateMode;
            this.tableHasOraOopPartitions = conf.getBoolean("oraoop.export.table.has.oraoop.partitions", false);
        }

        @Override
        protected void getExportTableAndColumns(TaskAttemptContext context) throws SQLException {
            Configuration conf = context.getConfiguration();
            this.oracleTable = this.createUniqueMapperTable(context);
            this.setOracleTableColumns(OraOopOracleQueries.getTableColumns(this.getConnection(), this.oracleTable, OraOopUtilities.omitLobAndLongColumnsDuringImport(conf), OraOopUtilities.recallSqoopJobType(conf), true, false, OracleUtils.isOracleEscapingDisabled(conf)));
        }

        @Override
        public void closeConnection(TaskAttemptContext context) throws SQLException {
            try {
                if (this.numberOfRowsSkipped > 0L) {
                    LOG.warn(String.format("%d records were skipped due to a NULL value within one of the update-key column(s).\nHaving a NULL value prevents a record from being able to be matched to a row in the Oracle table.", this.numberOfRowsSkipped));
                }
                this.updateMainExportTableFromUniqueMapperTable(context, this.updateColumnNames);
                LOG.debug(String.format("Dropping temporary mapper table %s", this.oracleTable.toString()));
                OraOopOracleQueries.dropTable(this.getConnection(), this.oracleTable);
            }
            finally {
                super.closeConnection(context);
            }
        }

        private ExportTableUpdateTechnique getExportTableUpdateTechnique() {
            ExportTableUpdateTechnique result;
            block9: {
                block8: {
                    if (!this.tableHasOraOopPartitions) break block8;
                    switch (this.updateMode) {
                        case Update: {
                            result = ExportTableUpdateTechnique.ReInsertUpdatedRows;
                            break block9;
                        }
                        case Merge: {
                            result = ExportTableUpdateTechnique.ReInsertUpdatedRowsAndNewRows;
                            break block9;
                        }
                        default: {
                            throw new RuntimeException(String.format("Update %s to cater for the updateMode \"%s\".", OraOopUtilities.getCurrentMethodName(), this.updateMode.toString()));
                        }
                    }
                }
                switch (this.updateMode) {
                    case Update: {
                        result = ExportTableUpdateTechnique.UpdateSql;
                        break;
                    }
                    case Merge: {
                        result = ExportTableUpdateTechnique.MergeSql;
                        break;
                    }
                    default: {
                        throw new RuntimeException(String.format("Update %s to cater for the updateMode \"%s\".", OraOopUtilities.getCurrentMethodName(), this.updateMode.toString()));
                    }
                }
            }
            return result;
        }

        private void updateMainExportTableFromUniqueMapperTable(TaskAttemptContext context, String[] mergeColumnNames) throws SQLException {
            OraOopOracleQueries.CreateExportChangesTableOptions changesTableOptions;
            String schema = context.getConfiguration().get("oraoop.table.owner");
            String localTableName = context.getConfiguration().get("oraoop.table.name");
            OracleTable targetTable = new OracleTable(schema, localTableName);
            Object sysDateTime = this.getJobSysDate(context);
            OracleTable changesTable = OraOopUtilities.generateExportTableMapperTableName(Integer.toString(this.mapperId) + "_CHG", sysDateTime, null);
            boolean parallelizationEnabled = OraOopUtilities.enableOracleParallelProcessingDuringExport(context.getConfiguration());
            ExportTableUpdateTechnique exportTableUpdateTechnique = this.getExportTableUpdateTechnique();
            switch (exportTableUpdateTechnique) {
                case ReInsertUpdatedRows: 
                case UpdateSql: {
                    changesTableOptions = OraOopOracleQueries.CreateExportChangesTableOptions.OnlyRowsThatDiffer;
                    break;
                }
                case ReInsertUpdatedRowsAndNewRows: 
                case MergeSql: {
                    changesTableOptions = OraOopOracleQueries.CreateExportChangesTableOptions.RowsThatDifferPlusNewRows;
                    break;
                }
                default: {
                    throw new RuntimeException(String.format("Update %s to cater for the ExportTableUpdateTechnique \"%s\".", OraOopUtilities.getCurrentMethodName(), exportTableUpdateTechnique.toString()));
                }
            }
            String temporaryTableStorageClause = OraOopUtilities.getTemporaryTableStorageClause(context.getConfiguration());
            try {
                int changeTableRowCount = OraOopOracleQueries.createExportChangesTable(this.getConnection(), changesTable, temporaryTableStorageClause, this.oracleTable, targetTable, this.updateColumnNames, changesTableOptions, parallelizationEnabled, OracleUtils.isOracleEscapingDisabled(context.getConfiguration()));
                if (changeTableRowCount == 0) {
                    LOG.debug(String.format("The changes-table does not contain any rows. %s is now exiting.", OraOopUtilities.getCurrentMethodName()));
                    return;
                }
                switch (exportTableUpdateTechnique) {
                    case ReInsertUpdatedRows: 
                    case ReInsertUpdatedRowsAndNewRows: {
                        OraOopOracleQueries.deleteRowsFromTable(this.getConnection(), targetTable, changesTable, this.updateColumnNames, parallelizationEnabled);
                        OraOopOracleQueries.insertRowsIntoExportTable(this.getConnection(), targetTable, changesTable, sysDateTime, this.mapperId, parallelizationEnabled, OracleUtils.isOracleEscapingDisabled(context.getConfiguration()));
                        break;
                    }
                    case UpdateSql: {
                        long start = System.nanoTime();
                        OraOopOracleQueries.updateTable(this.getConnection(), targetTable, changesTable, this.updateColumnNames, this.getOracleTableColumns(), sysDateTime, this.mapperId, parallelizationEnabled, context.getConfiguration().getBoolean("sqoop.oracle.escaping.disabled", false));
                        double timeInSec = (double)(System.nanoTime() - start) / Math.pow(10.0, 9.0);
                        LOG.info(String.format("Time spent performing an update: %f sec.", timeInSec));
                        break;
                    }
                    case MergeSql: {
                        long mergeStart = System.nanoTime();
                        OraOopOracleQueries.mergeTable(this.getConnection(), targetTable, changesTable, this.updateColumnNames, this.getOracleTableColumns(), sysDateTime, this.mapperId, parallelizationEnabled);
                        double mergeTimeInSec = (double)(System.nanoTime() - mergeStart) / Math.pow(10.0, 9.0);
                        LOG.info(String.format("Time spent performing a merge: %f sec.", mergeTimeInSec));
                        break;
                    }
                    default: {
                        throw new RuntimeException(String.format("Update %s to cater for the ExportTableUpdateTechnique \"%s\".", OraOopUtilities.getCurrentMethodName(), exportTableUpdateTechnique.toString()));
                    }
                }
                this.getConnection().commit();
            }
            catch (SQLException ex) {
                this.getConnection().rollback();
                throw ex;
            }
            finally {
                OraOopOracleQueries.dropTable(this.getConnection(), changesTable);
            }
        }

        @Override
        protected String getBatchSqlStatement() {
            if (this.sqlStatement == null) {
                this.sqlStatement = this.getBatchInsertSqlStatement(this.useAppendValuesOracleHint ? "/*+APPEND_VALUES*/" : "");
            }
            return this.sqlStatement;
        }

        @Override
        void configurePreparedStatement(PreparedStatement statement, List<SqoopRecord> userRecords) throws SQLException {
            try {
                for (SqoopRecord record : userRecords) {
                    Map<String, Object> fieldMap = record.getFieldMap();
                    boolean updateKeyValueIsNull = false;
                    for (int idx = 0; idx < this.updateColumnNames.length; ++idx) {
                        String updateColumnName = this.updateColumnNames[idx];
                        Object updateKeyValue = fieldMap.get(updateColumnName);
                        if (updateKeyValue != null) continue;
                        ++this.numberOfRowsSkipped;
                        updateKeyValueIsNull = true;
                        break;
                    }
                    if (updateKeyValueIsNull) continue;
                    this.configurePreparedStatementColumns(statement, fieldMap);
                }
            }
            catch (Exception ex) {
                if (ex instanceof SQLException) {
                    throw (SQLException)ex;
                }
                LOG.error(String.format("The following error occurred during %s", OraOopUtilities.getCurrentMethodName()), ex);
                throw new SQLException(ex);
            }
        }
    }

    private static enum ExportTableUpdateTechnique {
        ReInsertUpdatedRows,
        ReInsertUpdatedRowsAndNewRows,
        UpdateSql,
        MergeSql;

    }

    public static enum UpdateMode {
        Update,
        Merge;

    }
}

