/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.mapreduce;

import com.google.common.base.Preconditions;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionLocator;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.HFileOutputFormat2;
import org.apache.hadoop.hbase.mapreduce.LoadIncrementalHFiles;
import org.apache.hadoop.hbase.mapreduce.TableMapReduceUtil;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.sqoop.SqoopOptions;
import org.apache.sqoop.manager.ImportJobContext;
import org.apache.sqoop.mapreduce.HBaseBulkImportMapper;
import org.apache.sqoop.mapreduce.HBaseImportJob;
import org.apache.sqoop.util.ImportException;

public class HBaseBulkImportJob
extends HBaseImportJob {
    public static final Log LOG = LogFactory.getLog((String)HBaseBulkImportJob.class.getName());
    private Connection hbaseConnection;

    public HBaseBulkImportJob(SqoopOptions opts, ImportJobContext importContext) {
        super(opts, importContext);
    }

    @Override
    protected void configureMapper(Job job, String tableName, String tableClassName) throws IOException {
        job.setMapOutputKeyClass(ImmutableBytesWritable.class);
        job.setMapOutputValueClass(Put.class);
        job.setMapperClass(this.getMapperClass());
    }

    @Override
    protected Class<? extends Mapper> getMapperClass() {
        return HBaseBulkImportMapper.class;
    }

    @Override
    protected void jobSetup(Job job) throws IOException, ImportException {
        super.jobSetup(job);
        if (this.getContext().getDestination() == null) {
            throw new ImportException("Can't run HBaseBulkImportJob without a valid destination directory.");
        }
        TableMapReduceUtil.addDependencyJars((Configuration)job.getConfiguration(), (Class[])new Class[]{Preconditions.class});
        FileOutputFormat.setOutputPath((Job)job, (Path)this.getContext().getDestination());
        TableName hbaseTableName = TableName.valueOf((String)this.options.getHBaseTable());
        this.hbaseConnection = ConnectionFactory.createConnection((Configuration)job.getConfiguration());
        try (Table hbaseTable = this.hbaseConnection.getTable(hbaseTableName);){
            HFileOutputFormat2.configureIncrementalLoad((Job)job, (Table)hbaseTable, (RegionLocator)this.hbaseConnection.getRegionLocator(hbaseTableName));
        }
        catch (IOException | RuntimeException e) {
            try {
                this.hbaseConnection.close();
            }
            catch (IOException ioException) {
                LOG.error((Object)"Cannot close HBase connection.", (Throwable)ioException);
            }
            throw e;
        }
    }

    @Override
    protected void completeImport(Job job) throws IOException, ImportException {
        super.completeImport(job);
        Path bulkLoadDir = this.getContext().getDestination();
        FileSystem fileSystem = bulkLoadDir.getFileSystem(job.getConfiguration());
        this.setPermission(fileSystem, fileSystem.getFileStatus(bulkLoadDir), FsPermission.createImmutable((short)511));
        TableName hbaseTableName = TableName.valueOf((String)this.options.getHBaseTable());
        try (Table hbaseTable = this.hbaseConnection.getTable(hbaseTableName);
             Admin hbaseAdmin = this.hbaseConnection.getAdmin();){
            LoadIncrementalHFiles loader = new LoadIncrementalHFiles(job.getConfiguration());
            loader.doBulkLoad(bulkLoadDir, hbaseAdmin, hbaseTable, this.hbaseConnection.getRegionLocator(hbaseTableName));
        }
        catch (Exception e) {
            String errorMessage = String.format("Unrecoverable error while performing the bulk load of files in [%s]", bulkLoadDir.toString());
            throw new ImportException(errorMessage, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void jobTeardown(Job job) throws IOException, ImportException {
        try {
            super.jobTeardown(job);
            Path destination = this.getContext().getDestination();
            FileSystem fileSystem = destination.getFileSystem(job.getConfiguration());
            fileSystem.delete(destination, true);
        }
        finally {
            try {
                this.hbaseConnection.close();
            }
            catch (IOException e) {
                LOG.error((Object)"Cannot close HBase connection.", (Throwable)e);
            }
        }
    }

    private void setPermission(FileSystem fs, FileStatus fileStatus, FsPermission permission) throws IOException {
        if (fileStatus.isDir()) {
            for (FileStatus file : fs.listStatus(fileStatus.getPath())) {
                this.setPermission(fs, file, permission);
            }
        }
        fs.setPermission(fileStatus.getPath(), permission);
    }
}

