/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.mapreduce;

import java.io.IOException;
import java.lang.reflect.Method;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.mapreduce.TableMapReduceUtil;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.security.token.TokenUtil;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.sqoop.SqoopOptions;
import org.apache.sqoop.hbase.HBasePutProcessor;
import org.apache.sqoop.lib.FieldMapProcessor;
import org.apache.sqoop.lib.SqoopRecord;
import org.apache.sqoop.manager.ConnManager;
import org.apache.sqoop.manager.ImportJobContext;
import org.apache.sqoop.mapreduce.DataDrivenImportJob;
import org.apache.sqoop.mapreduce.DelegatingOutputFormat;
import org.apache.sqoop.mapreduce.HBaseImportMapper;
import org.apache.sqoop.util.ImportException;

public class HBaseImportJob
extends DataDrivenImportJob {
    public static final Log LOG = LogFactory.getLog((String)HBaseImportJob.class.getName());

    public HBaseImportJob(SqoopOptions opts, ImportJobContext importContext) {
        super(opts, importContext.getInputFormat(), importContext);
    }

    @Override
    protected void configureMapper(Job job, String tableName, String tableClassName) throws IOException {
        job.setOutputKeyClass(SqoopRecord.class);
        job.setOutputValueClass(NullWritable.class);
        job.setMapperClass(this.getMapperClass());
    }

    @Override
    protected Class<? extends Mapper> getMapperClass() {
        return HBaseImportMapper.class;
    }

    @Override
    protected Class<? extends OutputFormat> getOutputFormatClass() throws ClassNotFoundException {
        return DelegatingOutputFormat.class;
    }

    @Override
    protected void configureOutputFormat(Job job, String tableName, String tableClassName) throws ClassNotFoundException, IOException {
        job.setOutputFormatClass(this.getOutputFormatClass());
        Configuration conf = job.getConfiguration();
        conf.setClass("sqoop.output.delegate.field.map.processor.class", HBasePutProcessor.class, FieldMapProcessor.class);
        conf.set("sqoop.hbase.insert.table", this.options.getHBaseTable());
        conf.set("sqoop.hbase.insert.column.family", this.options.getHBaseColFamily());
        conf.set("hbase.null.incremental.mode", this.options.getHbaseNullIncrementalMode().toString());
        String rowKeyCol = this.options.getHBaseRowKeyColumn();
        if (null == rowKeyCol) {
            rowKeyCol = this.options.getSplitByCol();
        }
        if (null == rowKeyCol) {
            ConnManager manager = this.getContext().getConnManager();
            rowKeyCol = manager.getPrimaryKey(tableName);
        }
        if (null == rowKeyCol) {
            throw new IOException("Could not determine the row-key column. Use --hbase-row-key to specify the input column that names each row.");
        }
        conf.set("sqoop.hbase.insert.row.key.column", rowKeyCol);
    }

    protected boolean skipDelegationTokens(Configuration conf) {
        return conf.getBoolean("sqoop.hbase.security.token.skip", false);
    }

    @Override
    protected void jobSetup(Job job) throws IOException, ImportException {
        Configuration conf = job.getConfiguration();
        String tableName = conf.get("sqoop.hbase.insert.table");
        String familyName = conf.get("sqoop.hbase.insert.column.family");
        if (null == tableName) {
            throw new ImportException("Import to HBase error: Table name not specified");
        }
        if (null == familyName) {
            throw new ImportException("Import to HBase error: Column family not specified");
        }
        Method m = null;
        try {
            m = HBaseConfiguration.class.getMethod("merge", Configuration.class, Configuration.class);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        if (m != null) {
            Configuration newConf = HBaseConfiguration.create((Configuration)conf);
            try {
                m.invoke(null, conf, newConf);
            }
            catch (Exception e) {
                throw new ImportException(e);
            }
        } else {
            HBaseConfiguration.addHbaseResources((Configuration)conf);
        }
        Connection hbaseConnection = ConnectionFactory.createConnection((Configuration)conf);
        Admin admin = hbaseConnection.getAdmin();
        if (!this.skipDelegationTokens(conf)) {
            try {
                if (User.isHBaseSecurityEnabled((Configuration)conf)) {
                    TokenUtil.obtainTokenForJob((Connection)hbaseConnection, (User)User.getCurrent(), (Job)job);
                }
            }
            catch (InterruptedException ex) {
                throw new ImportException("Can't get authentication token", ex);
            }
        }
        HTableDescriptor tableDesc = null;
        byte[] familyBytes = Bytes.toBytes((String)familyName);
        HColumnDescriptor colDesc = new HColumnDescriptor(familyBytes);
        if (!admin.tableExists(TableName.valueOf((String)tableName))) {
            if (this.options.getCreateHBaseTable()) {
                LOG.info((Object)("Creating missing HBase table " + tableName));
                tableDesc = new HTableDescriptor(TableName.valueOf((String)tableName));
                tableDesc.addFamily(colDesc);
                admin.createTable((TableDescriptor)tableDesc);
            } else {
                LOG.warn((Object)("Could not find HBase table " + tableName));
                LOG.warn((Object)"This job may fail. Either explicitly create the table,");
                LOG.warn((Object)"or re-run with --hbase-create-table.");
            }
        } else {
            tableDesc = admin.getTableDescriptor(TableName.valueOf((String)tableName));
            if (!tableDesc.hasFamily(familyBytes)) {
                if (this.options.getCreateHBaseTable()) {
                    LOG.info((Object)("Creating missing column family " + familyName));
                    admin.disableTable(TableName.valueOf((String)tableName));
                    admin.addColumn(TableName.valueOf((String)tableName), (ColumnFamilyDescriptor)colDesc);
                    admin.enableTable(TableName.valueOf((String)tableName));
                } else {
                    LOG.warn((Object)("Could not find column family " + familyName + " in table " + tableName));
                    LOG.warn((Object)"This job may fail. Either create the column family,");
                    LOG.warn((Object)"or re-run with --hbase-create-table.");
                }
            }
        }
        admin.close();
        hbaseConnection.close();
        TableMapReduceUtil.addDependencyJars((Job)job);
        TableMapReduceUtil.addDependencyJars((Configuration)conf, (Class[])new Class[]{Table.class});
        super.jobSetup(job);
    }
}

