/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.mapreduce;

import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.mapred.AvroWrapper;
import org.apache.avro.mapred.Pair;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.sqoop.avro.AvroUtil;
import org.apache.sqoop.lib.SqoopRecord;
import org.apache.sqoop.mapreduce.MergeMapperBase;

public class MergeAvroMapper
extends MergeMapperBase<AvroWrapper<GenericRecord>, NullWritable> {
    private Map<String, Pair<String, String>> sqoopRecordFields = new HashMap<String, Pair<String, String>>();
    private SqoopRecord sqoopRecordImpl;

    @Override
    protected void setup(Mapper.Context context) throws InterruptedException, IOException {
        super.setup(context);
        Configuration conf = context.getConfiguration();
        String userClassName = conf.get("sqoop.merge.class");
        try {
            Class<?> clazz = Class.forName(userClassName, true, Thread.currentThread().getContextClassLoader());
            this.sqoopRecordImpl = (SqoopRecord)ReflectionUtils.newInstance(clazz, (Configuration)conf);
            for (Field field : clazz.getDeclaredFields()) {
                String fieldName = field.getName();
                String fieldTypeName = field.getType().getName();
                this.sqoopRecordFields.put(fieldName.toLowerCase(), (Pair<String, String>)new Pair((CharSequence)fieldName, (CharSequence)fieldTypeName));
            }
        }
        catch (ClassNotFoundException e) {
            throw new IOException("Cannot find the user record class with class name" + userClassName, e);
        }
    }

    public void map(AvroWrapper<GenericRecord> key, NullWritable val, Mapper.Context c) throws IOException, InterruptedException {
        this.processRecord(this.toSqoopRecord((GenericRecord)key.datum()), c);
    }

    private SqoopRecord toSqoopRecord(GenericRecord genericRecord) throws IOException {
        Schema avroSchema = genericRecord.getSchema();
        for (Schema.Field field : avroSchema.getFields()) {
            Pair<String, String> sqoopRecordField = this.sqoopRecordFields.get(field.name().toLowerCase());
            if (null == sqoopRecordField) {
                throw new IOException("Cannot find field '" + field.name() + "' in fields of user class" + this.sqoopRecordImpl.getClass().getName() + ". Fields are: " + Arrays.deepToString(this.sqoopRecordFields.values().toArray()));
            }
            Object avroObject = genericRecord.get(field.name());
            Object fieldVal = AvroUtil.fromAvro(avroObject, field.schema(), (String)sqoopRecordField.value());
            this.sqoopRecordImpl.setField((String)sqoopRecordField.key(), fieldVal);
        }
        return this.sqoopRecordImpl;
    }
}

