/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.mapreduce;

import java.io.IOException;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.MapWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.apache.sqoop.lib.SqoopRecord;
import org.apache.sqoop.mapreduce.AutoProgressMapper;
import org.apache.sqoop.mapreduce.MergeRecord;

public class MergeGenericRecordExportMapper<K, V>
extends AutoProgressMapper<K, V, Text, MergeRecord> {
    protected MapWritable columnTypes = new MapWritable();
    private String keyColName;
    private boolean isNewDatasetSplit;

    @Override
    protected void setup(Mapper.Context context) throws IOException, InterruptedException {
        Configuration conf = context.getConfiguration();
        this.keyColName = conf.get("sqoop.merge.key.col");
        InputSplit inputSplit = context.getInputSplit();
        FileSplit fileSplit = (FileSplit)inputSplit;
        Path splitPath = fileSplit.getPath();
        if (splitPath.toString().startsWith(conf.get("sqoop.merge.new.path"))) {
            this.isNewDatasetSplit = true;
        } else if (splitPath.toString().startsWith(conf.get("sqoop.merge.old.path"))) {
            this.isNewDatasetSplit = false;
        } else {
            throw new IOException("File " + splitPath + " is not under new path " + conf.get("sqoop.merge.new.path") + " or old path " + conf.get("sqoop.merge.old.path"));
        }
        super.setup(context);
    }

    protected void processRecord(SqoopRecord sqoopRecord, Mapper.Context context) throws IOException, InterruptedException {
        MergeRecord mergeRecord = new MergeRecord(sqoopRecord, this.isNewDatasetSplit);
        Map<String, Object> fieldMap = sqoopRecord.getFieldMap();
        if (null == fieldMap) {
            throw new IOException("No field map in record " + sqoopRecord);
        }
        Object keyObj = fieldMap.get(this.keyColName);
        if (null == keyObj) {
            throw new IOException("Cannot join values on null key. Did you specify a key column that exists?");
        }
        context.write((Object)new Text(keyObj.toString()), (Object)mergeRecord);
    }
}

