/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.mapreduce;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.mapred.Pair;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.sqoop.avro.AvroUtil;
import org.apache.sqoop.lib.SqoopRecord;
import org.apache.sqoop.mapreduce.MergeRecord;

public abstract class MergeParquetReducer<KEYOUT, VALUEOUT>
extends Reducer<Text, MergeRecord, KEYOUT, VALUEOUT> {
    private Schema schema = null;
    private boolean bigDecimalFormatString = true;
    private Map<String, Pair<String, String>> sqoopRecordFields = new HashMap<String, Pair<String, String>>();

    protected void setup(Reducer.Context context) throws IOException, InterruptedException {
        this.schema = new Schema.Parser().parse(context.getConfiguration().get("parquetjob.avro.schema"));
        this.bigDecimalFormatString = context.getConfiguration().getBoolean("sqoop.bigdecimal.format.string", true);
    }

    public void reduce(Text key, Iterable<MergeRecord> vals, Reducer.Context context) throws IOException, InterruptedException {
        SqoopRecord bestRecord = null;
        try {
            for (MergeRecord mergeRecord : vals) {
                if (null == bestRecord && !mergeRecord.isNewRecord()) {
                    bestRecord = (SqoopRecord)mergeRecord.getSqoopRecord().clone();
                    continue;
                }
                if (!mergeRecord.isNewRecord()) continue;
                bestRecord = (SqoopRecord)mergeRecord.getSqoopRecord().clone();
            }
        }
        catch (CloneNotSupportedException cnse) {
            throw new IOException(cnse);
        }
        if (null != bestRecord) {
            GenericRecord record = AvroUtil.toGenericRecord(bestRecord.getFieldMap(), this.schema, this.bigDecimalFormatString);
            this.write(context, record);
        }
    }

    protected abstract void write(Reducer.Context var1, GenericRecord var2) throws IOException, InterruptedException;
}

