/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.mapreduce;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.GzipCodec;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.sqoop.mapreduce.KeyRecordWriters;

public class RawKeyTextOutputFormat<K, V>
extends FileOutputFormat<K, V> {
    protected FSDataOutputStream getFSDataOutputStream(TaskAttemptContext context, String ext) throws IOException {
        Configuration conf = context.getConfiguration();
        Path file = this.getDefaultWorkFile(context, ext);
        FileSystem fs = file.getFileSystem(conf);
        FSDataOutputStream fileOut = fs.create(file, false);
        return fileOut;
    }

    protected DataOutputStream getOutputStream(TaskAttemptContext context) throws IOException {
        FSDataOutputStream fileOut;
        boolean isCompressed = RawKeyTextOutputFormat.getCompressOutput((JobContext)context);
        Configuration conf = context.getConfiguration();
        String ext = "";
        CompressionCodec codec = null;
        if (isCompressed) {
            Class codecClass = RawKeyTextOutputFormat.getOutputCompressorClass((JobContext)context, GzipCodec.class);
            codec = (CompressionCodec)ReflectionUtils.newInstance((Class)codecClass, (Configuration)conf);
            ext = codec.getDefaultExtension();
        }
        Object ostream = fileOut = this.getFSDataOutputStream(context, ext);
        if (isCompressed) {
            ostream = new DataOutputStream((OutputStream)codec.createOutputStream((OutputStream)fileOut));
        }
        return ostream;
    }

    public RecordWriter<K, V> getRecordWriter(TaskAttemptContext context) throws IOException {
        DataOutputStream ostream = this.getOutputStream(context);
        return new KeyRecordWriters.RawKeyRecordWriter(ostream);
    }
}

