/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.mapreduce.db;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.sqoop.config.ConfigurationHelper;
import org.apache.sqoop.mapreduce.db.DBSplitter;
import org.apache.sqoop.mapreduce.db.DataDrivenDBInputFormat;

public class IntegerSplitter
implements DBSplitter {
    public static final Log LOG = LogFactory.getLog((String)IntegerSplitter.class.getName());

    @Override
    public List<InputSplit> split(Configuration conf, ResultSet results, String colName) throws SQLException {
        long minVal = results.getLong(1);
        long maxVal = results.getLong(2);
        String lowClausePrefix = colName + " >= ";
        String highClausePrefix = colName + " < ";
        int numSplits = ConfigurationHelper.getConfNumMaps(conf);
        if (numSplits < 1) {
            numSplits = 1;
        }
        if (results.getString(1) == null && results.getString(2) == null) {
            ArrayList<InputSplit> splits = new ArrayList<InputSplit>();
            splits.add(new DataDrivenDBInputFormat.DataDrivenDBInputSplit(colName + " IS NULL", colName + " IS NULL"));
            return splits;
        }
        long splitLimit = ConfigurationHelper.getSplitLimit(conf);
        List<Long> splitPoints = this.split(numSplits, splitLimit, minVal, maxVal);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)String.format("Splits: [%,28d to %,28d] into %d parts", minVal, maxVal, numSplits));
            for (int i = 0; i < splitPoints.size(); ++i) {
                LOG.debug((Object)String.format("%,28d", splitPoints.get(i)));
            }
        }
        ArrayList<InputSplit> splits = new ArrayList<InputSplit>();
        long start = splitPoints.get(0);
        for (int i = 1; i < splitPoints.size(); ++i) {
            long end = splitPoints.get(i);
            if (i == splitPoints.size() - 1) {
                splits.add(new DataDrivenDBInputFormat.DataDrivenDBInputSplit(lowClausePrefix + Long.toString(start), colName + " <= " + Long.toString(end)));
            } else {
                splits.add(new DataDrivenDBInputFormat.DataDrivenDBInputSplit(lowClausePrefix + Long.toString(start), highClausePrefix + Long.toString(end)));
            }
            start = end;
        }
        if (results.getString(1) == null || results.getString(2) == null) {
            splits.add(new DataDrivenDBInputFormat.DataDrivenDBInputSplit(colName + " IS NULL", colName + " IS NULL"));
        }
        return splits;
    }

    public List<Long> split(long numSplits, long splitLimit, long minVal, long maxVal) throws SQLException {
        ArrayList<Long> splits = new ArrayList<Long>();
        long splitSize = (maxVal - minVal) / numSplits;
        double splitSizeDouble = ((double)maxVal - (double)minVal) / (double)numSplits;
        if (splitLimit > 0L && splitSizeDouble > (double)splitLimit) {
            LOG.debug((Object)("Adjusting split size " + splitSize + " because it's greater than limit " + splitLimit));
            long newSplits = (maxVal - minVal) / splitLimit;
            return this.split(newSplits != numSplits ? newSplits : newSplits + 1L, splitLimit, minVal, maxVal);
        }
        LOG.info((Object)("Split size: " + splitSize + "; Num splits: " + numSplits + " from: " + minVal + " to: " + maxVal));
        long remainder = (maxVal - minVal) % numSplits;
        long curVal = minVal;
        int i = 0;
        while ((long)i <= numSplits) {
            splits.add(curVal);
            if (curVal >= maxVal) break;
            curVal += splitSize;
            curVal += (long)i < remainder ? 1L : 0L;
            ++i;
        }
        if (splits.size() == 1) {
            splits.add(maxVal);
        } else if (maxVal - minVal <= numSplits) {
            splits.add(maxVal);
        }
        return splits;
    }
}

