/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.mapreduce.db;

import java.io.IOException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.sqoop.manager.oracle.OracleUtils;
import org.apache.sqoop.mapreduce.DBWritable;
import org.apache.sqoop.mapreduce.db.DBConfiguration;
import org.apache.sqoop.mapreduce.db.DBInputFormat;
import org.apache.sqoop.mapreduce.db.DBRecordReader;

public class OracleDBRecordReader<T extends DBWritable>
extends DBRecordReader<T> {
    public static final String SESSION_TIMEZONE_KEY = "oracle.sessionTimeZone";
    private static final Log LOG = LogFactory.getLog(OracleDBRecordReader.class);

    public OracleDBRecordReader(DBInputFormat.DBInputSplit split, Class<T> inputClass, Configuration conf, Connection conn, DBConfiguration dbConfig, String cond, String[] fields, String table) throws SQLException {
        super(split, inputClass, conf, conn, dbConfig, cond, fields, table);
        OracleDBRecordReader.setSessionTimeZone(conf, conn);
    }

    @Override
    protected String getSelectQuery() {
        StringBuilder query = new StringBuilder();
        DBConfiguration dbConf = this.getDBConf();
        String conditions = this.getConditions();
        String tableName = this.getTableName();
        String[] fieldNames = this.getFieldNames();
        if (dbConf.getInputQuery() == null) {
            String orderBy;
            query.append("SELECT ");
            boolean escapingDisabled = OracleUtils.isOracleEscapingDisabled(this.getConf());
            for (int i = 0; i < fieldNames.length; ++i) {
                query.append(OracleUtils.escapeIdentifier(fieldNames[i], escapingDisabled));
                if (i == fieldNames.length - 1) continue;
                query.append(", ");
            }
            query.append(" FROM ").append(tableName);
            if (conditions != null && conditions.length() > 0) {
                query.append(" WHERE ").append(conditions);
            }
            if ((orderBy = dbConf.getInputOrderBy()) != null && orderBy.length() > 0) {
                query.append(" ORDER BY ").append(orderBy);
            }
        } else {
            query.append(dbConf.getInputQuery());
        }
        try {
            DBInputFormat.DBInputSplit split = this.getSplit();
            if (split.getLength() > 0L && split.getStart() > 0L) {
                String querystring = query.toString();
                query = new StringBuilder();
                query.append("SELECT * FROM (SELECT a.*,ROWNUM dbif_rno FROM ( ");
                query.append(querystring);
                query.append(" ) a WHERE rownum <= ").append(split.getStart());
                query.append(" + ").append(split.getLength());
                query.append(" ) WHERE dbif_rno >= ").append(split.getStart());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return query.toString();
    }

    public static void setSessionTimeZone(Configuration conf, Connection conn) throws SQLException {
        Method method;
        try {
            method = conn.getClass().getMethod("setSessionTimeZone", String.class);
        }
        catch (Exception ex) {
            LOG.error((Object)("Could not find method setSessionTimeZone in " + conn.getClass().getName()), (Throwable)ex);
            throw new SQLException(ex);
        }
        String clientTimeZone = conf.get(SESSION_TIMEZONE_KEY, "GMT");
        try {
            method.setAccessible(true);
            method.invoke((Object)conn, clientTimeZone);
            LOG.info((Object)("Time zone has been set to " + clientTimeZone));
        }
        catch (Exception ex) {
            LOG.warn((Object)("Time zone " + clientTimeZone + " could not be set on Oracle database."));
            LOG.warn((Object)"Setting default time zone: GMT");
            try {
                method.invoke((Object)conn, "GMT");
            }
            catch (Exception ex2) {
                LOG.error((Object)"Could not set time zone for oracle connection", (Throwable)ex2);
                throw new SQLException(ex);
            }
        }
    }
}

