/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.mapreduce.mainframe;

import java.text.ParseException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.sqoop.mapreduce.mainframe.MainframeDatasetType;

public class MainframeDatasetPath {
    private static final Log LOG = LogFactory.getLog(MainframeDatasetPath.class);
    private String datasetName;
    private MainframeDatasetType datasetType;
    private String dsFolderName = null;
    private String dsFileName = null;

    public MainframeDatasetPath() {
    }

    public MainframeDatasetPath(String dsName, Configuration conf) throws Exception {
        String inputName = conf.get("mapreduce.mainframe.input.dataset.name");
        assert (inputName.equals(dsName));
        LOG.info((Object)("Datasets to transfer from: " + dsName));
        this.datasetName = dsName;
        String dsType = conf.get("mapreduce.mainframe.input.dataset.type");
        this.setMainframeDatasetType(dsType);
        this.initialisePaths();
    }

    public MainframeDatasetPath(String dsName, MainframeDatasetType dsType) {
        this.setMainframeDatasetName(dsName);
        this.setMainframeDatasetType(dsType);
        this.initialisePaths();
    }

    public MainframeDatasetPath(String dsName, String dsType) throws ParseException {
        this.setMainframeDatasetName(dsName);
        this.setMainframeDatasetType(dsType);
        this.initialisePaths();
    }

    public void initialisePaths() throws IllegalStateException {
        if (this.datasetName == null || this.datasetType == null) {
            throw new IllegalStateException("Please set data set name and type first.");
        }
        boolean isSequentialDs = this.datasetType.equals((Object)MainframeDatasetType.SEQUENTIAL);
        boolean isGDG = this.datasetType.equals((Object)MainframeDatasetType.GDG);
        LOG.info((Object)String.format("dsName: %s", this.datasetName));
        LOG.info((Object)String.format("isSequentialDs: %s isGDG: %s", isSequentialDs, isGDG));
        if (isSequentialDs) {
            int lastDotIndex = this.datasetName.lastIndexOf(".");
            if (lastDotIndex == -1) {
                this.datasetName = "";
            } else {
                this.dsFolderName = this.datasetName.substring(0, lastDotIndex);
                if (lastDotIndex + 1 < this.datasetName.length()) {
                    this.dsFileName = this.datasetName.substring(lastDotIndex + 1);
                }
            }
        } else {
            this.dsFolderName = this.datasetName;
            this.dsFileName = null;
        }
    }

    public MainframeDatasetType getMainframeDatasetType() {
        return this.datasetType;
    }

    public void setMainframeDatasetType(MainframeDatasetType dsType) {
        this.datasetType = dsType;
    }

    public void setMainframeDatasetType(String dsType) throws ParseException {
        if (dsType.equals("s")) {
            this.datasetType = MainframeDatasetType.SEQUENTIAL;
        } else if (dsType.equals("p")) {
            this.datasetType = MainframeDatasetType.PARTITIONED;
        } else if (dsType.equals("g")) {
            this.datasetType = MainframeDatasetType.GDG;
        } else {
            throw new ParseException(String.format("Invalid data set type specified: %s", dsType), 0);
        }
    }

    public String getMainframeDatasetName() {
        return this.datasetName;
    }

    public void setMainframeDatasetName(String dsName) {
        this.datasetName = dsName;
    }

    public String getMainframeDatasetFolder() {
        return this.dsFolderName;
    }

    public String getMainframeDatasetFileName() {
        return this.dsFileName;
    }
}

