/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.mapreduce.mainframe;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.net.ftp.FTPClientConfig;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.parser.ConfigurableFTPFileEntryParserImpl;

public class MainframeFTPFileGdgEntryParser
extends ConfigurableFTPFileEntryParserImpl {
    private static final String DEFAULT_DATE_FORMAT = "yyyy/MM/dd HH:mm";
    private static final String HEADER = "Volume Unit ";
    private static String GDG_REGEX = "^\\S+\\s+.*?\\s+(G\\d{4}V\\d{2})$";
    private static final Log LOG = LogFactory.getLog((String)MainframeFTPFileGdgEntryParser.class.getName());

    public MainframeFTPFileGdgEntryParser() {
        super(GDG_REGEX);
        LOG.info((Object)"MainframeFTPFileGdgEntryParser default constructor");
    }

    public FTPFile parseFTPEntry(String entry) {
        LOG.info((Object)("parseFTPEntry: " + entry));
        if (this.isFtpListingHeader(entry).booleanValue()) {
            return null;
        }
        if (this.matches(entry)) {
            String dsName = this.group(1);
            return this.createFtpFile(entry, dsName);
        }
        return null;
    }

    protected FTPFile createFtpFile(String entry, String dsName) {
        FTPFile file = new FTPFile();
        file.setRawListing(entry);
        file.setName(dsName);
        file.setType(0);
        return file;
    }

    protected Boolean isFtpListingHeader(String entry) {
        return entry.startsWith(HEADER);
    }

    protected FTPClientConfig getDefaultConfiguration() {
        return new FTPClientConfig("MVS", DEFAULT_DATE_FORMAT, null, null, null, null);
    }
}

