/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.mapreduce.mainframe;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.hadoop.mapreduce.lib.output.LazyOutputFormat;
import org.apache.sqoop.SqoopOptions;
import org.apache.sqoop.manager.ImportJobContext;
import org.apache.sqoop.mapreduce.ByteKeyOutputFormat;
import org.apache.sqoop.mapreduce.DBWritable;
import org.apache.sqoop.mapreduce.DataDrivenImportJob;
import org.apache.sqoop.mapreduce.RawKeyTextOutputFormat;
import org.apache.sqoop.mapreduce.mainframe.MainframeDatasetBinaryImportMapper;
import org.apache.sqoop.mapreduce.mainframe.MainframeDatasetBinaryRecord;
import org.apache.sqoop.mapreduce.mainframe.MainframeDatasetImportMapper;
import org.apache.sqoop.mapreduce.mainframe.MainframeDatasetInputFormat;
import org.apache.sqoop.mapreduce.parquet.ParquetImportJobConfigurator;

public class MainframeImportJob
extends DataDrivenImportJob {
    private static final Log LOG = LogFactory.getLog((String)MainframeImportJob.class.getName());

    public MainframeImportJob(SqoopOptions opts, ImportJobContext context, ParquetImportJobConfigurator parquetImportJobConfigurator) {
        super(opts, MainframeDatasetInputFormat.class, context, parquetImportJobConfigurator);
    }

    @Override
    protected Class<? extends Mapper> getMapperClass() {
        if (SqoopOptions.FileLayout.BinaryFile.equals((Object)this.options.getFileLayout())) {
            LOG.debug((Object)"Using MainframeDatasetBinaryImportMapper");
            return MainframeDatasetBinaryImportMapper.class;
        }
        if (this.options.getFileLayout() == SqoopOptions.FileLayout.TextFile) {
            return MainframeDatasetImportMapper.class;
        }
        return super.getMapperClass();
    }

    @Override
    protected void configureInputFormat(Job job, String tableName, String tableClassName, String splitByCol) throws IOException {
        super.configureInputFormat(job, tableName, tableClassName, splitByCol);
        job.getConfiguration().set("mapreduce.mainframe.input.dataset.name", this.options.getMainframeInputDatasetName());
        job.getConfiguration().set("mapreduce.mainframe.input.dataset.type", this.options.getMainframeInputDatasetType());
        job.getConfiguration().set("mainframe.input.dataset.tape", this.options.getMainframeInputDatasetTape().toString());
        if (SqoopOptions.FileLayout.BinaryFile == this.options.getFileLayout()) {
            job.getConfiguration().set("mainframe.ftp.transfermode", "binary");
            job.getConfiguration().setInt("mainframe.ftp.buffersize", this.options.getBufferSize().intValue());
        } else {
            job.getConfiguration().set("mainframe.ftp.transfermode", "ascii");
        }
    }

    @Override
    protected void configureOutputFormat(Job job, String tableName, String tableClassName) throws ClassNotFoundException, IOException {
        super.configureOutputFormat(job, tableName, tableClassName);
        job.getConfiguration().set("mainframe.ftp.transfermode", this.options.getMainframeFtpTransferMode());
        LazyOutputFormat.setOutputFormatClass((Job)job, this.getOutputFormatClass());
    }

    @Override
    protected void configureMapper(Job job, String tableName, String tableClassName) throws IOException {
        super.configureMapper(job, tableName, tableClassName);
        if (SqoopOptions.FileLayout.BinaryFile == this.options.getFileLayout()) {
            job.setOutputKeyClass(BytesWritable.class);
            job.setOutputValueClass(NullWritable.class);
            Configuration conf = job.getConfiguration();
            conf.setClass("mapreduce.jdbc.input.class", MainframeDatasetBinaryRecord.class, DBWritable.class);
        }
    }

    @Override
    protected Class<? extends OutputFormat> getOutputFormatClass() {
        if (this.options.getFileLayout() == SqoopOptions.FileLayout.TextFile) {
            return RawKeyTextOutputFormat.class;
        }
        if (this.options.getFileLayout() == SqoopOptions.FileLayout.BinaryFile) {
            return ByteKeyOutputFormat.class;
        }
        return null;
    }
}

