/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.mapreduce.netezza;

import java.io.IOException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.sqoop.config.ConfigurationHelper;
import org.apache.sqoop.mapreduce.DBWritable;
import org.apache.sqoop.mapreduce.db.DataDrivenDBInputFormat;
import org.apache.sqoop.mapreduce.db.netezza.NetezzaDBDataSliceSplitter;

public class NetezzaDataDrivenDBInputFormat<T extends DBWritable>
extends DataDrivenDBInputFormat<T>
implements Configurable {
    private static final Log LOG = LogFactory.getLog(NetezzaDataDrivenDBInputFormat.class);

    @Override
    public List<InputSplit> getSplits(JobContext job) throws IOException {
        int numMappers = ConfigurationHelper.getJobNumMaps(job);
        String boundaryQuery = this.getDBConf().getInputBoundingQuery();
        if (!this.getConf().getBoolean("netezza.dataslice.aligned.access", false) || this.getDBConf().getInputTableName() == null || numMappers == 1 || boundaryQuery != null && !boundaryQuery.isEmpty()) {
            return super.getSplits(job);
        }
        NetezzaDBDataSliceSplitter splitter = new NetezzaDBDataSliceSplitter();
        return splitter.split(this.getConf(), null, null);
    }
}

