/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.mapreduce.parquet.hadoop;

import java.io.IOException;
import org.apache.avro.Schema;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.parquet.avro.AvroParquetOutputFormat;
import org.apache.parquet.hadoop.ParquetOutputFormat;
import org.apache.parquet.hadoop.metadata.CompressionCodecName;
import org.apache.sqoop.SqoopOptions;
import org.apache.sqoop.mapreduce.parquet.ParquetImportJobConfigurator;
import org.apache.sqoop.mapreduce.parquet.hadoop.HadoopParquetImportMapper;

public class HadoopParquetImportJobConfigurator
implements ParquetImportJobConfigurator {
    private static final Log LOG = LogFactory.getLog((String)HadoopParquetImportJobConfigurator.class.getName());

    @Override
    public void configureMapper(Job job, Schema schema, SqoopOptions options, String tableName, Path destination) throws IOException {
        this.configureAvroSchema(job, schema);
        this.configureOutputCodec(job);
    }

    @Override
    public Class<? extends Mapper> getMapperClass() {
        return HadoopParquetImportMapper.class;
    }

    @Override
    public Class<? extends OutputFormat> getOutputFormatClass() {
        return AvroParquetOutputFormat.class;
    }

    @Override
    public boolean isHiveImportNeeded() {
        return true;
    }

    void configureOutputCodec(Job job) {
        String outputCodec = job.getConfiguration().get("parquetjob.output.codec");
        if (outputCodec != null) {
            LOG.info((Object)("Using output codec: " + outputCodec));
            ParquetOutputFormat.setCompression((Job)job, (CompressionCodecName)CompressionCodecName.fromConf((String)outputCodec));
        }
    }

    void configureAvroSchema(Job job, Schema schema) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Using Avro schema: " + schema));
        }
        AvroParquetOutputFormat.setSchema((Job)job, (Schema)schema);
    }
}

