/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.mapreduce.parquet.kite;

import java.io.IOException;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.sqoop.mapreduce.parquet.ParquetExportJobConfigurator;
import org.apache.sqoop.mapreduce.parquet.kite.KiteParquetExportMapper;
import org.apache.sqoop.util.FileSystemUtil;
import org.kitesdk.data.mapreduce.DatasetKeyInputFormat;

public class KiteParquetExportJobConfigurator
implements ParquetExportJobConfigurator {
    @Override
    public void configureInputFormat(Job job, Path inputPath) throws IOException {
        String uri = "dataset:" + FileSystemUtil.makeQualified(inputPath, job.getConfiguration());
        DatasetKeyInputFormat.configure((Job)job).readFrom(uri);
    }

    @Override
    public Class<? extends Mapper> getMapperClass() {
        return KiteParquetExportMapper.class;
    }

    @Override
    public Class<? extends InputFormat> getInputFormatClass() {
        return DatasetKeyInputFormat.class;
    }
}

