/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.metastore.hsqldb;

import java.io.File;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.StringUtils;
import org.apache.sqoop.SqoopOptions;
import org.apache.sqoop.manager.HsqldbManager;
import org.hsqldb.Server;

public class HsqldbMetaStore {
    public static final Log LOG = LogFactory.getLog((String)HsqldbMetaStore.class.getName());
    public static final String META_STORAGE_LOCATION_KEY = "sqoop.metastore.server.location";
    public static final String META_SERVER_PORT_KEY = "sqoop.metastore.server.port";
    public static final int DEFAULT_PORT = 16000;
    private int port;
    private String fileLocation;
    private Server server;
    private Configuration conf;

    public HsqldbMetaStore(Configuration config) {
        this.conf = config;
        this.init();
    }

    private String getHomeDirFilePath() {
        String homeDir = System.getProperty("user.home");
        File homeDirObj = new File(homeDir);
        File sqoopDataDirObj = new File(homeDirObj, ".sqoop");
        File databaseFileObj = new File(sqoopDataDirObj, "shared-metastore.db");
        return databaseFileObj.toString();
    }

    private void init() {
        if (null != this.server) {
            LOG.debug((Object)"init(): server already exists.");
            return;
        }
        this.fileLocation = this.conf.get(META_STORAGE_LOCATION_KEY, null);
        if (null == this.fileLocation) {
            this.fileLocation = this.getHomeDirFilePath();
            LOG.warn((Object)("The location for metastore data has not been explicitly set. Placing shared metastore files in " + this.fileLocation));
        }
        this.port = this.conf.getInt(META_SERVER_PORT_KEY, 16000);
    }

    public void start() {
        try {
            if (this.server != null) {
                this.server.checkRunning(false);
            }
        }
        catch (RuntimeException re) {
            LOG.info((Object)"Server is already started.");
            return;
        }
        this.server = new Server();
        this.server.setDatabasePath(0, "file:" + this.fileLocation);
        this.server.setDatabaseName(0, "sqoop");
        this.server.putPropertiesFromString("hsqldb.write_delay=false");
        this.server.setPort(this.port);
        this.server.setSilent(true);
        this.server.setNoSystemExit(true);
        this.server.start();
        LOG.info((Object)("Server started on port " + this.port + " with protocol " + this.server.getProtocol()));
    }

    public void waitForServer() {
        while (true) {
            int curState;
            if ((curState = this.server.getState()) == 16) break;
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException ie) {
                LOG.info((Object)("Interrupted while blocking for server:" + StringUtils.stringifyException((Throwable)ie)));
            }
        }
        LOG.info((Object)"Got shutdown notification");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        SqoopOptions options = new SqoopOptions(this.conf);
        options.setConnectString("jdbc:hsqldb:hsql://localhost:" + this.port + "/sqoop");
        options.setUsername("SA");
        options.setPassword("");
        HsqldbManager manager = new HsqldbManager(options);
        Statement s = null;
        try {
            Connection c = manager.getConnection();
            s = c.createStatement();
            s.execute("SHUTDOWN");
        }
        catch (SQLException sqlE) {
            LOG.warn((Object)("Exception shutting down database: " + StringUtils.stringifyException((Throwable)sqlE)));
        }
        finally {
            if (null != s) {
                try {
                    s.close();
                }
                catch (SQLException sqlE) {
                    LOG.warn((Object)("Error closing statement: " + sqlE));
                }
            }
            try {
                manager.close();
            }
            catch (SQLException sqlE) {
                LOG.warn((Object)("Error closing manager: " + sqlE));
            }
        }
    }
}

