/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.tool;

import java.io.IOException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.util.StringUtils;
import org.apache.sqoop.SqoopOptions;
import org.apache.sqoop.cli.RelatedOptions;
import org.apache.sqoop.cli.ToolOptions;
import org.apache.sqoop.hive.HiveClient;
import org.apache.sqoop.hive.HiveClientFactory;
import org.apache.sqoop.tool.BaseSqoopTool;

public class CreateHiveTableTool
extends BaseSqoopTool {
    public static final Log LOG = LogFactory.getLog((String)CreateHiveTableTool.class.getName());
    private final HiveClientFactory hiveClientFactory;

    public CreateHiveTableTool(HiveClientFactory hiveClientFactory) {
        super("create-hive-table");
        this.hiveClientFactory = hiveClientFactory;
    }

    public CreateHiveTableTool() {
        this(new HiveClientFactory());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int run(SqoopOptions options) {
        if (!this.init(options)) {
            return 1;
        }
        try {
            HiveClient hiveClient = this.hiveClientFactory.createHiveClient(options, this.manager);
            hiveClient.createTable();
        }
        catch (IOException ioe) {
            LOG.error((Object)("Encountered IOException running create table job: " + StringUtils.stringifyException((Throwable)ioe)));
            this.rethrowIfRequired(options, ioe);
            int n = 1;
            return n;
        }
        finally {
            this.destroy(options);
        }
        return 0;
    }

    @Override
    public void configureOptions(ToolOptions toolOptions) {
        toolOptions.addUniqueOptions(this.getCommonOptions());
        RelatedOptions hiveOpts = this.getHiveOptions(false);
        OptionBuilder.withArgName((String)"table-name");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"The db table to read the definition from");
        OptionBuilder.withLongOpt((String)"table");
        hiveOpts.addOption(OptionBuilder.create());
        toolOptions.addUniqueOptions(hiveOpts);
        toolOptions.addUniqueOptions(this.getOutputFormatOptions());
    }

    @Override
    public void printHelp(ToolOptions toolOptions) {
        super.printHelp(toolOptions);
        System.out.println("");
        System.out.println("At minimum, you must specify --connect and --table");
    }

    @Override
    public void applyOptions(CommandLine in, SqoopOptions out) throws SqoopOptions.InvalidOptionsException {
        if (in.hasOption("table")) {
            out.setTableName(in.getOptionValue("table"));
        }
        out.setHiveImport(true);
        this.applyCommonOptions(in, out);
        this.applyHiveOptions(in, out);
        this.applyOutputFormatOptions(in, out);
    }

    @Override
    public void validateOptions(SqoopOptions options) throws SqoopOptions.InvalidOptionsException {
        if (this.hasUnrecognizedArgs(this.extraArguments)) {
            throw new SqoopOptions.InvalidOptionsException("\nTry --help for usage instructions.");
        }
        this.validateCommonOptions(options);
        this.validateOutputFormatOptions(options);
        this.validateHiveOptions(options);
        if (options.getTableName() == null) {
            throw new SqoopOptions.InvalidOptionsException("--table is required for table definition importing.\nTry --help for usage instructions.");
        }
    }
}

