/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.tool;

import org.apache.commons.cli.CommandLine;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sqoop.SqoopOptions;
import org.apache.sqoop.cli.ToolOptions;
import org.apache.sqoop.tool.BaseSqoopTool;

public class ListTablesTool
extends BaseSqoopTool {
    public static final Log LOG = LogFactory.getLog((String)ListTablesTool.class.getName());

    public ListTablesTool() {
        super("list-tables");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int run(SqoopOptions options) {
        if (!this.init(options)) {
            return 1;
        }
        try {
            String[] tables = this.manager.listTables();
            if (null == tables) {
                System.err.println("Could not retrieve tables list from server");
                LOG.error((Object)"manager.listTables() returned null");
                int n = 1;
                return n;
            }
            for (String tbl : tables) {
                System.out.println(tbl);
            }
        }
        finally {
            this.destroy(options);
        }
        return 0;
    }

    @Override
    public void configureOptions(ToolOptions toolOptions) {
        toolOptions.addUniqueOptions(this.getCommonOptions());
    }

    @Override
    public void applyOptions(CommandLine in, SqoopOptions out) throws SqoopOptions.InvalidOptionsException {
        this.applyCommonOptions(in, out);
    }

    @Override
    public void validateOptions(SqoopOptions options) throws SqoopOptions.InvalidOptionsException {
        options.setExtraArgs(this.getSubcommandArgs(this.extraArguments));
        int dashPos = this.getDashPosition(this.extraArguments);
        if (this.hasUnrecognizedArgs(this.extraArguments, 0, dashPos)) {
            throw new SqoopOptions.InvalidOptionsException("\nTry --help for usage instructions.");
        }
        this.validateCommonOptions(options);
    }
}

