/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.tool;

import java.io.PrintStream;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.util.ToolRunner;
import org.apache.sqoop.SqoopOptions;
import org.apache.sqoop.cli.RelatedOptions;
import org.apache.sqoop.cli.ToolOptions;
import org.apache.sqoop.manager.MainframeManager;
import org.apache.sqoop.mapreduce.mainframe.MainframeConfiguration;
import org.apache.sqoop.tool.ImportTool;

public class MainframeImportTool
extends ImportTool {
    private static final Log LOG = LogFactory.getLog((String)MainframeImportTool.class.getName());
    public static final String DS_ARG = "dataset";
    public static final String DS_TYPE_ARG = "datasettype";
    public static final String DS_TAPE_ARG = "tape";
    public static final String BUFFERSIZE_ARG = "buffersize";

    public MainframeImportTool() {
        super("import-mainframe", false);
    }

    @Override
    protected RelatedOptions getImportOptions() {
        RelatedOptions importOpts = new RelatedOptions("Import mainframe control arguments");
        OptionBuilder.withArgName((String)"Dataset name");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Datasets to import");
        OptionBuilder.withLongOpt((String)DS_ARG);
        importOpts.addOption(OptionBuilder.create());
        OptionBuilder.withDescription((String)"Imports data in delete mode");
        OptionBuilder.withLongOpt((String)"delete-target-dir");
        importOpts.addOption(OptionBuilder.create());
        OptionBuilder.withArgName((String)"dir");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"HDFS plain file destination");
        OptionBuilder.withLongOpt((String)"target-dir");
        importOpts.addOption(OptionBuilder.create());
        OptionBuilder.withArgName((String)"Dataset type");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Dataset type (p=partitioned data set|s=sequential data set|g=GDG)");
        OptionBuilder.withLongOpt((String)DS_TYPE_ARG);
        importOpts.addOption(OptionBuilder.create());
        OptionBuilder.withArgName((String)"Dataset is on tape");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Dataset is on tape (true|false)");
        OptionBuilder.withLongOpt((String)DS_TAPE_ARG);
        importOpts.addOption(OptionBuilder.create());
        this.addValidationOpts(importOpts);
        OptionBuilder.withArgName((String)"dir");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"HDFS parent for file destination");
        OptionBuilder.withLongOpt((String)"warehouse-dir");
        importOpts.addOption(OptionBuilder.create());
        OptionBuilder.withDescription((String)"Imports data as plain text (default)");
        OptionBuilder.withLongOpt((String)"as-textfile");
        importOpts.addOption(OptionBuilder.create());
        OptionBuilder.withDescription((String)"Imports data as binary");
        OptionBuilder.withLongOpt((String)"as-binaryfile");
        importOpts.addOption(OptionBuilder.create());
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Sets buffer size for binary import in bytes (default=32kB)");
        OptionBuilder.withLongOpt((String)BUFFERSIZE_ARG);
        importOpts.addOption(OptionBuilder.create());
        OptionBuilder.withArgName((String)"n");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Use 'n' map tasks to import in parallel");
        OptionBuilder.withLongOpt((String)"num-mappers");
        importOpts.addOption(OptionBuilder.create((String)"m"));
        OptionBuilder.withArgName((String)"name");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Set name for generated mapreduce job");
        OptionBuilder.withLongOpt((String)"mapreduce-job-name");
        importOpts.addOption(OptionBuilder.create());
        OptionBuilder.withDescription((String)"Enable compression");
        OptionBuilder.withLongOpt((String)"compress");
        importOpts.addOption(OptionBuilder.create((String)"z"));
        OptionBuilder.withArgName((String)"codec");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Compression codec to use for import");
        OptionBuilder.withLongOpt((String)"compression-codec");
        importOpts.addOption(OptionBuilder.create());
        return importOpts;
    }

    @Override
    public void configureOptions(ToolOptions toolOptions) {
        toolOptions.addUniqueOptions(this.getCommonOptions());
        toolOptions.addUniqueOptions(this.getImportOptions());
        toolOptions.addUniqueOptions(this.getOutputFormatOptions());
        toolOptions.addUniqueOptions(this.getInputFormatOptions());
        toolOptions.addUniqueOptions(this.getHiveOptions(true));
        toolOptions.addUniqueOptions(this.getHBaseOptions());
        toolOptions.addUniqueOptions(this.getHCatalogOptions());
        toolOptions.addUniqueOptions(this.getHCatImportOnlyOptions());
        toolOptions.addUniqueOptions(this.getAccumuloOptions());
        RelatedOptions codeGenOpts = this.getCodeGenOpts(false);
        OptionBuilder.withArgName((String)"file");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Disable code generation; use specified jar");
        OptionBuilder.withLongOpt((String)"jar-file");
        codeGenOpts.addOption(OptionBuilder.create());
        toolOptions.addUniqueOptions(codeGenOpts);
    }

    @Override
    public void printHelp(ToolOptions toolOptions) {
        System.out.println("usage: sqoop " + this.getToolName() + " [GENERIC-ARGS] [TOOL-ARGS]\n");
        toolOptions.printHelp();
        System.out.println("\nGeneric Hadoop command-line arguments:");
        System.out.println("(must preceed any tool-specific arguments)");
        ToolRunner.printGenericCommandUsage((PrintStream)System.out);
        System.out.println("\nAt minimum, you must specify --connect and --dataset");
    }

    @Override
    public void applyOptions(CommandLine in, SqoopOptions out) throws SqoopOptions.InvalidOptionsException {
        super.applyOptions(in, out);
        if (!in.hasOption("connection-manager")) {
            out.setConnManagerClassName(MainframeManager.class.getName());
        }
        if (in.hasOption(DS_ARG)) {
            out.setMainframeInputDatasetName(in.getOptionValue(DS_ARG));
        }
        if (in.hasOption(DS_TYPE_ARG)) {
            out.setMainframeInputDatasetType(in.getOptionValue(DS_TYPE_ARG));
        } else {
            out.setMainframeInputDatasetType("p");
        }
        if (in.hasOption(DS_TAPE_ARG)) {
            out.setMainframeInputDatasetTape(in.getOptionValue(DS_TAPE_ARG));
        } else {
            out.setMainframeInputDatasetTape("false");
        }
        if (in.hasOption("as-binaryfile")) {
            out.setMainframeFtpTransferMode("binary");
            out.setFileLayout(SqoopOptions.FileLayout.BinaryFile);
        } else {
            out.setMainframeFtpTransferMode("ascii");
            out.setFileLayout(SqoopOptions.FileLayout.TextFile);
        }
        if (in.hasOption(BUFFERSIZE_ARG)) {
            int bufSize = Integer.valueOf(in.getOptionValue(BUFFERSIZE_ARG));
            if (bufSize > 0) {
                out.setBufferSize(bufSize);
            } else {
                out.setBufferSize(MainframeConfiguration.MAINFRAME_FTP_TRANSFER_BINARY_DEFAULT_BUFFER_SIZE);
            }
        } else {
            out.setBufferSize(MainframeConfiguration.MAINFRAME_FTP_TRANSFER_BINARY_DEFAULT_BUFFER_SIZE);
        }
    }

    @Override
    protected void validateImportOptions(SqoopOptions options) throws SqoopOptions.InvalidOptionsException {
        if (options.getMainframeInputDatasetName() == null) {
            throw new SqoopOptions.InvalidOptionsException("--dataset is required for mainframe import. \nTry --help for usage instructions.");
        }
        String dsType = options.getMainframeInputDatasetType();
        LOG.info((Object)("Dataset type: " + dsType));
        if (!(dsType.equals("p") || dsType.equals("s") || dsType.equals("g"))) {
            throw new SqoopOptions.InvalidOptionsException("--datasettype specified is invalid. \nTry --help for usage instructions.");
        }
        Boolean dsTape = options.getMainframeInputDatasetTape();
        if (dsTape == null && !dsTape.booleanValue() && dsTape.booleanValue()) {
            throw new SqoopOptions.InvalidOptionsException("--tape specified is invalid. \nTry --help for usage instructions.");
        }
        if (SqoopOptions.FileLayout.BinaryFile.equals((Object)options.getFileLayout()) && StringUtils.isEmpty((CharSequence)options.getMainframeInputDatasetName())) {
            throw new SqoopOptions.InvalidOptionsException("--as-binaryfile should only be used with import-mainframe module.");
        }
        if (!SqoopOptions.FileLayout.BinaryFile.equals((Object)options.getFileLayout()) && !MainframeConfiguration.MAINFRAME_FTP_TRANSFER_BINARY_DEFAULT_BUFFER_SIZE.equals(options.getBufferSize())) {
            throw new SqoopOptions.InvalidOptionsException("--buffersize should only be used with --as-binaryfile parameter.");
        }
        super.validateImportOptions(options);
    }
}

