/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.util;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.sqoop.SqoopOptions;
import org.apache.sqoop.util.password.FilePasswordLoader;
import org.apache.sqoop.util.password.PasswordLoader;

public final class CredentialsUtil {
    private static String PROPERTY_LOADER_CLASSS = "org.apache.sqoop.credentials.loader.class";
    private static String DEFAULT_PASSWORD_LOADER = FilePasswordLoader.class.getCanonicalName();
    public static final Log LOG = LogFactory.getLog((String)CredentialsUtil.class.getName());

    private CredentialsUtil() {
    }

    public static String fetchPassword(SqoopOptions options) throws IOException {
        String passwordFilePath = options.getPasswordFilePath();
        if (passwordFilePath == null) {
            return options.getPassword();
        }
        return CredentialsUtil.fetchPasswordFromLoader(options.getPasswordFilePath(), options.getConf());
    }

    public static String fetchPasswordFromLoader(String path, Configuration conf) throws IOException {
        PasswordLoader loader = CredentialsUtil.getLoader(conf);
        return loader.loadPassword(path, conf);
    }

    public static void cleanUpSensitiveProperties(Configuration configuration) throws IOException {
        PasswordLoader loader = CredentialsUtil.getLoader(configuration);
        loader.cleanUpConfiguration(configuration);
    }

    public static PasswordLoader getLoader(Configuration configuration) throws IOException {
        String loaderClass = configuration.get(PROPERTY_LOADER_CLASSS, DEFAULT_PASSWORD_LOADER);
        try {
            return (PasswordLoader)Class.forName(loaderClass).newInstance();
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }
}

