/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.repository2.unified;

import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.mimetype.IMimeType;
import org.pentaho.platform.api.mimetype.IPlatformMimeResolver;
import org.pentaho.platform.api.repository2.unified.IRepositoryVersionManager;
import org.pentaho.platform.engine.core.system.PentahoSessionHolder;
import org.pentaho.platform.engine.core.system.PentahoSystem;

public class DefaultRepositoryVersionManager
implements IRepositoryVersionManager {
    private boolean masterVersioning = true;
    private boolean masterVersionComments = true;
    private IPlatformMimeResolver platformMimeResolver = (IPlatformMimeResolver)PentahoSystem.get(IPlatformMimeResolver.class);

    public DefaultRepositoryVersionManager() {
        Boolean systemVersionCommentsEnabled;
        Boolean systemVersioningEnabled = (Boolean)PentahoSystem.get(Boolean.class, (String)"versioningEnabled", (IPentahoSession)PentahoSessionHolder.getSession());
        if (systemVersioningEnabled != null) {
            this.masterVersioning = systemVersioningEnabled;
        }
        if ((systemVersionCommentsEnabled = (Boolean)PentahoSystem.get(Boolean.class, (String)"versionCommentsEnabled", (IPentahoSession)PentahoSessionHolder.getSession())) != null) {
            this.masterVersionComments = systemVersionCommentsEnabled;
        }
    }

    public boolean isVersionCommentEnabled(String fullPath) {
        if (!this.isVersioningEnabled(fullPath) || !this.masterVersionComments) {
            return false;
        }
        IMimeType mimeType = this.platformMimeResolver.resolveMimeTypeForFileName(fullPath);
        if (mimeType == null) {
            return false;
        }
        return mimeType.isVersionCommentEnabled();
    }

    public boolean isVersioningEnabled(String fullPath) {
        if (!this.masterVersioning) {
            return false;
        }
        IMimeType mimeType = this.platformMimeResolver.resolveMimeTypeForFileName(fullPath);
        if (mimeType == null) {
            return false;
        }
        return mimeType.isVersionEnabled();
    }

    public void setPlatformMimeResolver(IPlatformMimeResolver platformMimeResolver) {
        this.platformMimeResolver = platformMimeResolver;
    }

    public void setMasterVersioning(boolean masterVersioningEnabled) {
        this.masterVersioning = masterVersioningEnabled;
    }

    public void setMasterVersionComments(boolean masterVersionCommentsEnabled) {
        this.masterVersionComments = masterVersionCommentsEnabled;
    }
}

