/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.repository2.unified.jcr;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.lock.Lock;
import javax.jcr.lock.LockManager;
import javax.jcr.security.AccessControlManager;
import javax.jcr.security.Privilege;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.api.mt.ITenantedPrincipleNameResolver;
import org.pentaho.platform.engine.core.system.PentahoSessionHolder;
import org.pentaho.platform.repository.RepositoryFilenameUtils;
import org.pentaho.platform.repository2.unified.ServerRepositoryPaths;
import org.pentaho.platform.repository2.unified.jcr.ILockHelper;
import org.pentaho.platform.repository2.unified.jcr.JcrTenantUtils;
import org.pentaho.platform.repository2.unified.jcr.PentahoJcrConstants;
import org.springframework.util.Assert;

public class DefaultLockHelper
implements ILockHelper {
    private static final String FOLDER_NAME_LOCK_TOKENS = ".lockTokens";
    private static final char LOCK_OWNER_INFO_SEPARATOR = ':';
    private static final String LOCK_OWNER_INFO_SEPARATOR_REGEX = "\\:";
    private static final List<Character> RESERVED_CHARS = Arrays.asList(Character.valueOf(':'));
    private static final Log logger = LogFactory.getLog(DefaultLockHelper.class);
    private static final int POSITION_LOCK_OWNER = 0;
    private static final int POSITION_LOCK_DATE = 1;
    private static final int POSITION_LOCK_MESSAGE = 2;
    ITenantedPrincipleNameResolver userNameUtils;

    public DefaultLockHelper(ITenantedPrincipleNameResolver userNameUtils) {
        this.userNameUtils = userNameUtils;
    }

    protected void addLockToken(Session session, PentahoJcrConstants pentahoJcrConstants, Lock lock) throws RepositoryException {
        Node lockTokensNode = this.getOrCreateLockTokensNode(session, pentahoJcrConstants, lock);
        Node newLockTokenNode = lockTokensNode.addNode(lock.getNode().getIdentifier(), pentahoJcrConstants.getPHO_NT_LOCKTOKENSTORAGE());
        newLockTokenNode.setProperty(pentahoJcrConstants.getPHO_LOCKEDNODEREF(), lock.getNode());
        newLockTokenNode.setProperty(pentahoJcrConstants.getPHO_LOCKTOKEN(), lock.getLockToken());
        session.save();
    }

    protected String getLockToken(Session session, PentahoJcrConstants pentahoJcrConstants, Lock lock) throws RepositoryException {
        Node lockTokensNode = this.getOrCreateLockTokensNode(session, pentahoJcrConstants, lock);
        NodeIterator nodes = lockTokensNode.getNodes(lock.getNode().getIdentifier());
        Assert.isTrue((boolean)nodes.hasNext());
        return nodes.nextNode().getProperty(pentahoJcrConstants.getPHO_LOCKTOKEN()).getString();
    }

    @Override
    public void removeLockToken(Session session, PentahoJcrConstants pentahoJcrConstants, Lock lock) throws RepositoryException {
        Node lockTokensNode = this.getOrCreateLockTokensNode(session, pentahoJcrConstants, lock);
        NodeIterator nodes = lockTokensNode.getNodes(lock.getNode().getIdentifier());
        if (nodes.hasNext()) {
            nodes.nextNode().remove();
        }
        session.save();
    }

    protected Node getOrCreateLockTokensNode(Session session, PentahoJcrConstants pentahoJcrConstants, Lock lock) throws RepositoryException {
        String absPath = ServerRepositoryPaths.getUserHomeFolderPath(this.userNameUtils.getTenant(this.getLockOwner(session, pentahoJcrConstants, lock)), this.userNameUtils.getPrincipleName(this.getLockOwner(session, pentahoJcrConstants, lock)));
        Node userHomeFolderNode = (Node)session.getItem(absPath);
        if (userHomeFolderNode.hasNode(FOLDER_NAME_LOCK_TOKENS)) {
            return userHomeFolderNode.getNode(FOLDER_NAME_LOCK_TOKENS);
        }
        Node lockTokensNode = userHomeFolderNode.addNode(FOLDER_NAME_LOCK_TOKENS, pentahoJcrConstants.getPHO_NT_INTERNALFOLDER());
        session.save();
        return lockTokensNode;
    }

    @Override
    public boolean canUnlock(Session session, PentahoJcrConstants pentahoJcrConstants, Lock lock) throws RepositoryException {
        String absPath = ServerRepositoryPaths.getUserHomeFolderPath(this.userNameUtils.getTenant(this.getLockOwner(session, pentahoJcrConstants, lock)), this.userNameUtils.getPrincipleName(this.getLockOwner(session, pentahoJcrConstants, lock)));
        AccessControlManager acMgr = session.getAccessControlManager();
        return acMgr.hasPrivileges(absPath, new Privilege[]{acMgr.privilegeFromName("jcr:read"), acMgr.privilegeFromName("jcr:write"), acMgr.privilegeFromName("jcr:lockManagement")});
    }

    @Override
    public void addLockTokenToSessionIfNecessary(Session session, PentahoJcrConstants pentahoJcrConstants, Serializable fileId) throws RepositoryException {
        Node fileNode = session.getNodeByIdentifier(fileId.toString());
        if (fileNode.isLocked()) {
            LockManager lockManager = session.getWorkspace().getLockManager();
            Lock lock = lockManager.getLock(fileNode.getPath());
            String lockToken = this.getLockToken(session, pentahoJcrConstants, lock);
            lockManager.addLockToken(lockToken);
        }
    }

    @Override
    public void removeLockTokenFromSessionIfNecessary(Session session, PentahoJcrConstants pentahoJcrConstants, Serializable fileId) throws RepositoryException {
        Node fileNode = session.getNodeByIdentifier(fileId.toString());
        if (fileNode.isLocked()) {
            LockManager lockManager = session.getWorkspace().getLockManager();
            Lock lock = lockManager.getLock(fileNode.getPath());
            String lockToken = this.getLockToken(session, pentahoJcrConstants, lock);
            lockManager.removeLockToken(lockToken);
        }
    }

    @Override
    public void unlockFile(Session session, PentahoJcrConstants pentahoJcrConstants, Serializable fileId) throws RepositoryException {
        Node fileNode = session.getNodeByIdentifier(fileId.toString());
        LockManager lockManager = session.getWorkspace().getLockManager();
        Lock lock = lockManager.getLock(fileNode.getPath());
        String lockToken = this.getLockToken(session, pentahoJcrConstants, lock);
        lockManager.addLockToken(lockToken);
        lock = lockManager.getLock(fileNode.getPath());
        this.removeLockToken(session, pentahoJcrConstants, lock);
        lockManager.unlock(fileNode.getPath());
    }

    @Override
    public void lockFile(Session session, PentahoJcrConstants pentahoJcrConstants, Serializable fileId, String message) throws RepositoryException {
        LockManager lockManager = session.getWorkspace().getLockManager();
        boolean isDeep = true;
        boolean isSessionScoped = false;
        long timeoutHint = Long.MAX_VALUE;
        String ownerInfo = this.makeOwnerInfo(JcrTenantUtils.getTenantedUser(PentahoSessionHolder.getSession().getName()), Calendar.getInstance().getTime(), message);
        Node fileNode = session.getNodeByIdentifier(fileId.toString());
        Assert.isTrue((boolean)fileNode.isNodeType(pentahoJcrConstants.getMIX_LOCKABLE()));
        Lock lock = lockManager.lock(fileNode.getPath(), true, false, Long.MAX_VALUE, ownerInfo);
        this.addLockToken(session, pentahoJcrConstants, lock);
    }

    private String makeOwnerInfo(String lockOwner, Date lockDate, String lockMessage) {
        return DefaultLockHelper.escape(lockOwner) + ':' + lockDate.getTime() + ':' + DefaultLockHelper.escape(lockMessage);
    }

    @Override
    public Date getLockDate(Session session, PentahoJcrConstants pentahoJcrConstants, Lock lock) throws RepositoryException {
        String[] tokens = this.tokenize(lock.getLockOwner());
        if (tokens != null) {
            try {
                long date = Long.parseLong(tokens[1]);
                return new Date(date);
            }
            catch (NumberFormatException e) {
                logger.debug((Object)"could not parse lock date; returning null", (Throwable)e);
            }
        }
        return null;
    }

    @Override
    public String getLockMessage(Session session, PentahoJcrConstants pentahoJcrConstants, Lock lock) throws RepositoryException {
        String[] tokens = this.tokenize(lock.getLockOwner());
        if (tokens != null) {
            return DefaultLockHelper.unescape(tokens[2]);
        }
        return null;
    }

    @Override
    public String getLockOwner(Session session, PentahoJcrConstants pentahoJcrConstants, Lock lock) throws RepositoryException {
        String[] tokens = this.tokenize(lock.getLockOwner());
        if (tokens != null) {
            return DefaultLockHelper.unescape(tokens[0]);
        }
        return lock.getLockOwner();
    }

    private String[] tokenize(String ownerInfo) {
        String[] tokens;
        if (ownerInfo != null && (tokens = ownerInfo.split(LOCK_OWNER_INFO_SEPARATOR_REGEX)).length == 3) {
            return tokens;
        }
        return null;
    }

    private static String escape(String in) {
        if (in == null || in.trim().equals("")) {
            return "";
        }
        return RepositoryFilenameUtils.escape(in, RESERVED_CHARS);
    }

    private static String unescape(String in) {
        if (in == null || in.trim().equals("")) {
            return "";
        }
        return RepositoryFilenameUtils.unescape(in);
    }
}

