/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.repository2.unified.jcr;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.jcr.ItemVisitor;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.PropertyType;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.ValueFormatException;
import javax.jcr.util.TraversingItemVisitor;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.engine.core.system.PentahoSessionHolder;
import org.pentaho.platform.engine.core.system.StandaloneSession;
import org.springframework.extensions.jcr.JcrCallback;
import org.springframework.extensions.jcr.JcrTemplate;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionTemplate;

public class JcrRepositoryDumpToFile {
    private static final Log logger = LogFactory.getLog(JcrRepositoryDumpToFile.class);
    public static final String PROP_DUMP_TO_FILE = "pentaho.repository.dumpToFile";
    public static final String PROP_DUMP_TO_FILE_SYSTEM_VIEW = "pentaho.repository.dumpToFile.systemView";
    public static final String PROP_DUMP_TO_FILE_DOCUMENT_VIEW = "pentaho.repository.dumpToFile.documentView";
    JcrTemplate jcrTemplate;
    TransactionTemplate txnTemplate;
    String repositoryAdminUsername;
    String filename;
    Mode mode;

    public JcrRepositoryDumpToFile(JcrTemplate jcrTemplate, TransactionTemplate txnTemplate, String repositoryAdminUsername, String filename, Mode mode) {
        this.jcrTemplate = jcrTemplate;
        this.txnTemplate = txnTemplate;
        this.repositoryAdminUsername = repositoryAdminUsername;
        this.filename = filename;
        this.mode = mode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() {
        if (this.filename != null) {
            String ZIP_EXTENSION = ".zip";
            if (!this.filename.endsWith(".zip")) {
                this.filename = this.filename + ".zip";
            }
            logger.debug((Object)String.format("dumping repository to file \"%s\"", this.filename));
            ZipOutputStream tmpOut = null;
            try {
                tmpOut = new ZipOutputStream(new BufferedOutputStream(FileUtils.openOutputStream((File)new File(this.filename))));
            }
            catch (IOException e) {
                IOUtils.closeQuietly(tmpOut);
                throw new RuntimeException(e);
            }
            final ZipOutputStream out = tmpOut;
            IPentahoSession origPentahoSession = PentahoSessionHolder.getSession();
            PentahoSessionHolder.setSession((IPentahoSession)this.createRepositoryAdminPentahoSession(this.repositoryAdminUsername));
            try {
                this.txnTemplate.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

                    public void doInTransactionWithoutResult(TransactionStatus status) {
                        JcrRepositoryDumpToFile.this.jcrTemplate.execute(new JcrCallback(){

                            public Object doInJcr(Session session) throws RepositoryException, IOException {
                                switch (JcrRepositoryDumpToFile.this.mode) {
                                    case SYS: {
                                        boolean SKIP_BINARY = false;
                                        boolean NO_RECURSE = false;
                                        out.putNextEntry(new ZipEntry("repository.xml"));
                                        session.exportSystemView("/", (OutputStream)out, false, false);
                                        return null;
                                    }
                                    case DOC: {
                                        boolean SKIP_BINARY = false;
                                        boolean NO_RECURSE = false;
                                        out.putNextEntry(new ZipEntry("repository.xml"));
                                        session.exportDocumentView("/", (OutputStream)out, false, false);
                                        return null;
                                    }
                                }
                                out.putNextEntry(new ZipEntry("repository.txt"));
                                session.getRootNode().accept((ItemVisitor)new DumpToFileTraversingItemVisitor(out));
                                return null;
                            }
                        });
                    }
                });
            }
            finally {
                PentahoSessionHolder.setSession((IPentahoSession)origPentahoSession);
                IOUtils.closeQuietly((OutputStream)out);
            }
            logger.debug((Object)String.format("dumped repository to file \"%s\"", this.filename));
        }
    }

    protected IPentahoSession createRepositoryAdminPentahoSession(String repositoryAdminUsername) {
        StandaloneSession pentahoSession = new StandaloneSession(repositoryAdminUsername);
        pentahoSession.setAuthenticated(repositoryAdminUsername);
        return pentahoSession;
    }

    public static class DumpToFileTraversingItemVisitor
    extends TraversingItemVisitor {
        private OutputStream out;
        private static final String INDENT = "  ";
        private static final String ENCODING = "UTF-8";
        private static final String NL = System.getProperty("line.separator");

        public DumpToFileTraversingItemVisitor(OutputStream out) {
            this.out = out;
        }

        protected void entering(Property property, int level) throws RepositoryException {
            StringBuilder buf = new StringBuilder();
            for (int i = 0; i < level; ++i) {
                buf.append(INDENT);
            }
            this.propertyToString(property, buf);
            try {
                IOUtils.write((CharSequence)buf, (OutputStream)this.out, (String)ENCODING);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        protected void propertyToString(Property property, StringBuilder buf) throws RepositoryException {
            buf.append("@");
            buf.append(property.getName());
            buf.append("=");
            try {
                Value value = property.getValue();
                this.valueToString(value, buf);
            }
            catch (ValueFormatException e) {
                Value[] values = property.getValues();
                buf.append("[");
                for (int i = 0; i < values.length; ++i) {
                    if (i > 0) {
                        buf.append(",");
                    }
                    this.valueToString(values[i], buf);
                }
                buf.append("]");
            }
            buf.append(NL);
        }

        protected void valueToString(Value value, StringBuilder buf) throws RepositoryException {
            buf.append(value.getString());
            buf.append(" (");
            buf.append(PropertyType.nameFromValue((int)value.getType()));
            buf.append(")");
        }

        protected void entering(Node node, int level) throws RepositoryException {
            StringBuilder buf = new StringBuilder();
            for (int i = 0; i < level; ++i) {
                buf.append(INDENT);
            }
            this.nodeToString(node, buf);
            try {
                IOUtils.write((CharSequence)buf, (OutputStream)this.out, (String)ENCODING);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        protected void nodeToString(Node node, StringBuilder buf) throws RepositoryException {
            buf.append(node.getName());
            buf.append("/");
            buf.append(NL);
        }

        protected void leaving(Property property, int level) throws RepositoryException {
        }

        protected void leaving(Node node, int level) throws RepositoryException {
        }
    }

    public static enum Mode {
        CUSTOM,
        SYS,
        DOC;

    }
}

