/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.sapinput;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.steps.sapinput.SapInputMeta;
import org.pentaho.di.trans.steps.sapinput.sap.SAPConnection;
import org.pentaho.di.trans.steps.sapinput.sap.SAPConnectionFactory;
import org.pentaho.di.trans.steps.sapinput.sap.SAPFunction;
import org.pentaho.di.ui.core.PropsUI;
import org.pentaho.di.ui.core.gui.GUIResource;
import org.pentaho.di.ui.core.gui.WindowProperty;
import org.pentaho.di.ui.core.widget.ColumnInfo;
import org.pentaho.di.ui.core.widget.TableView;
import org.pentaho.di.ui.trans.step.BaseStepDialog;

public class SapFunctionBrowser
extends Dialog {
    private static Class<?> PKG = SapInputMeta.class;
    private Label wlFunction;
    private Text wFunction;
    private Button wbFunction;
    private TableView wResult;
    private Button wOK;
    private Button wCancel;
    private Shell shell;
    private PropsUI props;
    private DatabaseMeta sapConnection;
    private String searchString;
    private VariableSpace space;
    private SAPFunction function;
    private List<SAPFunction> functionList;

    public SapFunctionBrowser(Shell parent, VariableSpace space, int style, DatabaseMeta sapConnection, String searchString) {
        super(parent, style);
        this.space = space;
        this.sapConnection = sapConnection;
        this.searchString = searchString;
        this.props = PropsUI.getInstance();
        this.functionList = new ArrayList<SAPFunction>();
    }

    public SAPFunction open() {
        Shell parent = this.getParent();
        Display display = parent.getDisplay();
        this.shell = new Shell(parent, 3184);
        this.props.setLook((Control)this.shell);
        this.shell.setImage(GUIResource.getInstance().getImageSpoon());
        int middle = 35;
        int margin = 4;
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"SapFunctionBrowser.Title", (String[])new String[0]));
        this.wlFunction = new Label((Composite)this.shell, 131072);
        this.wlFunction.setText(BaseMessages.getString(PKG, (String)"SapInputDialog.Function.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlFunction);
        FormData fdlFunction = new FormData();
        fdlFunction.left = new FormAttachment(0, 0);
        fdlFunction.right = new FormAttachment(middle, -margin);
        fdlFunction.top = new FormAttachment(0, 0);
        this.wlFunction.setLayoutData((Object)fdlFunction);
        this.wbFunction = new Button((Composite)this.shell, 8);
        this.props.setLook((Control)this.wbFunction);
        this.wbFunction.setText(BaseMessages.getString(PKG, (String)"SapInputDialog.FindFunctionButton.Label", (String[])new String[0]));
        FormData fdbFunction = new FormData();
        fdbFunction.right = new FormAttachment(100, 0);
        fdbFunction.top = new FormAttachment(0, 0);
        this.wbFunction.setLayoutData((Object)fdbFunction);
        this.wbFunction.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SapFunctionBrowser.this.searchString = SapFunctionBrowser.this.wFunction.getText();
                SapFunctionBrowser.this.getData();
            }
        });
        this.wFunction = new Text((Composite)this.shell, 18436);
        this.props.setLook((Control)this.wFunction);
        FormData fdFunction = new FormData();
        fdFunction.left = new FormAttachment(middle, 0);
        fdFunction.right = new FormAttachment((Control)this.wbFunction, -margin);
        fdFunction.top = new FormAttachment(0, margin);
        this.wFunction.setLayoutData((Object)fdFunction);
        Text lastControl = this.wFunction;
        this.wOK = new Button((Composite)this.shell, 8);
        this.wOK.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wOK.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                SapFunctionBrowser.this.ok();
            }
        });
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.wCancel.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                SapFunctionBrowser.this.cancel();
            }
        });
        BaseStepDialog.positionBottomButtons((Composite)this.shell, (Button[])new Button[]{this.wOK, this.wCancel}, (int)4, null);
        ColumnInfo[] columns = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"SapFunctionBrowser.ResultView.Name.Column", (String[])new String[0]), 1, false, true), new ColumnInfo(BaseMessages.getString(PKG, (String)"SapFunctionBrowser.ResultView.Groupname.Column", (String[])new String[0]), 1, false, true), new ColumnInfo(BaseMessages.getString(PKG, (String)"SapFunctionBrowser.ResultView.Application.Column", (String[])new String[0]), 1, false, true), new ColumnInfo(BaseMessages.getString(PKG, (String)"SapFunctionBrowser.ResultView.Description.Column", (String[])new String[0]), 1, false, true)};
        this.wResult = new TableView(this.space, (Composite)this.shell, 67586, columns, 0, null, this.props);
        this.wResult.setSortable(true);
        FormData fdResults = new FormData();
        fdResults.left = new FormAttachment(0, 0);
        fdResults.top = new FormAttachment((Control)lastControl, margin);
        fdResults.right = new FormAttachment(100, 0);
        fdResults.bottom = new FormAttachment((Control)this.wOK, -3 * margin);
        this.wResult.setLayoutData((Object)fdResults);
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                SapFunctionBrowser.this.cancel();
            }
        });
        this.getData();
        BaseStepDialog.setSize((Shell)this.shell);
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.function;
    }

    private void dispose() {
        WindowProperty winprop = new WindowProperty(this.shell);
        this.props.setScreen(winprop);
        this.shell.dispose();
    }

    protected void cancel() {
        this.function = null;
        this.dispose();
    }

    protected void ok() {
        this.function = null;
        int selectionIndex = this.wResult.getSelectionIndex();
        if (selectionIndex >= 0 && selectionIndex < this.functionList.size()) {
            this.function = this.functionList.get(selectionIndex);
        }
        this.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void find(String searchString) {
        this.searchString = searchString;
        try (SAPConnection sc = null;){
            sc = SAPConnectionFactory.create();
            sc.open(this.sapConnection);
            this.functionList = new ArrayList<SAPFunction>(sc.getFunctions(searchString));
        }
    }

    private void getData() {
        this.shell.getDisplay().asyncExec(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Cursor hourGlass = new Cursor((Device)SapFunctionBrowser.this.shell.getDisplay(), 1);
                try {
                    SapFunctionBrowser.this.shell.setCursor(hourGlass);
                    if (Utils.isEmpty((CharSequence)SapFunctionBrowser.this.searchString)) {
                        return;
                    }
                    SapFunctionBrowser.this.wFunction.setText(SapFunctionBrowser.this.searchString);
                    SapFunctionBrowser.this.find(SapFunctionBrowser.this.searchString);
                    SapFunctionBrowser.this.wResult.clearAll(false);
                    for (int i = 0; i < SapFunctionBrowser.this.functionList.size(); ++i) {
                        SAPFunction sapFunction = (SAPFunction)SapFunctionBrowser.this.functionList.get(i);
                        TableItem item = i == 0 ? ((SapFunctionBrowser)SapFunctionBrowser.this).wResult.table.getItem(0) : new TableItem(((SapFunctionBrowser)SapFunctionBrowser.this).wResult.table, 0);
                        int colnr = 1;
                        item.setText(colnr++, Const.NVL((String)sapFunction.getName(), (String)""));
                        item.setText(colnr++, Const.NVL((String)sapFunction.getGroup(), (String)""));
                        item.setText(colnr++, Const.NVL((String)sapFunction.getApplication(), (String)""));
                        item.setText(colnr++, Const.NVL((String)sapFunction.getDescription(), (String)""));
                    }
                    SapFunctionBrowser.this.wResult.setRowNums();
                    SapFunctionBrowser.this.wResult.optWidth(true);
                }
                finally {
                    SapFunctionBrowser.this.shell.setCursor(null);
                    hourGlass.dispose();
                }
            }
        });
    }
}

