/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.jsonoutput.analyzer;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.steps.jsonoutput.JsonOutputMeta;
import org.pentaho.metaverse.api.IMetaverseNode;
import org.pentaho.metaverse.api.MetaverseAnalyzerException;
import org.pentaho.metaverse.api.MetaverseException;
import org.pentaho.metaverse.api.StepField;
import org.pentaho.metaverse.api.analyzer.kettle.step.ExternalResourceStepAnalyzer;
import org.pentaho.metaverse.api.analyzer.kettle.step.IClonableStepAnalyzer;
import org.pentaho.metaverse.api.model.IExternalResourceInfo;

public class JsonOutputAnalyzer
extends ExternalResourceStepAnalyzer<JsonOutputMeta> {
    public Set<Class<? extends BaseStepMeta>> getSupportedSteps() {
        HashSet<Class<? extends BaseStepMeta>> supportedSteps = new HashSet<Class<? extends BaseStepMeta>>();
        supportedSteps.add(JsonOutputMeta.class);
        return supportedSteps;
    }

    public String getResourceInputNodeType() {
        return null;
    }

    public String getResourceOutputNodeType() {
        return "File Field";
    }

    public boolean isOutput() {
        return true;
    }

    public boolean isInput() {
        return false;
    }

    protected Set<StepField> getUsedFields(JsonOutputMeta meta) {
        return Collections.emptySet();
    }

    public IMetaverseNode createResourceNode(IExternalResourceInfo resource) throws MetaverseException {
        return this.createFileNode(resource.getName(), this.descriptor, "File");
    }

    protected void customAnalyze(JsonOutputMeta meta, IMetaverseNode rootNode) throws MetaverseAnalyzerException {
        super.customAnalyze((BaseStepMeta)meta, rootNode);
        rootNode.setProperty("isFileAppended", (Object)meta.isFileAppended());
        rootNode.setProperty("passDataToServletOutput", (Object)meta.passDataToServletOutput());
        rootNode.setProperty("addToResult", (Object)meta.AddToResult());
        rootNode.setProperty("jsonBloc", (Object)meta.getJsonBloc());
        rootNode.setProperty("operationType", (Object)meta.getOperationType());
        if (!StringUtils.isBlank((String)meta.getOutputValue())) {
            rootNode.setProperty("outputValue", (Object)meta.getOutputValue());
        }
    }

    public boolean hasOutputResource(JsonOutputMeta meta) {
        return meta.writesToFile() && (meta.getOperationType() == 1 || meta.getOperationType() == 2);
    }

    public IClonableStepAnalyzer newInstance() {
        return new JsonOutputAnalyzer();
    }
}

