/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.docbundle.metadata.writer;

import java.io.IOException;
import org.pentaho.reporting.libraries.docbundle.metadata.OfficeDocumentStatistic;
import org.pentaho.reporting.libraries.docbundle.metadata.writer.BundleMetaDataEntryWriteHandler;
import org.pentaho.reporting.libraries.docbundle.metadata.writer.BundleMetaDataXmlWriter;
import org.pentaho.reporting.libraries.xmlns.common.AttributeList;
import org.pentaho.reporting.libraries.xmlns.writer.XmlWriter;

public class DocumentStatisticWriteHandler
implements BundleMetaDataEntryWriteHandler {
    @Override
    public void write(BundleMetaDataXmlWriter bundleWriter, XmlWriter writer, String entryNamespace, String entryName, Object entryValue) throws IOException {
        if (bundleWriter == null) {
            throw new NullPointerException();
        }
        if (writer == null) {
            throw new NullPointerException();
        }
        if (entryName == null) {
            throw new NullPointerException();
        }
        if (entryNamespace == null) {
            throw new NullPointerException();
        }
        if (entryValue == null) {
            throw new NullPointerException();
        }
        if (!(entryValue instanceof OfficeDocumentStatistic)) {
            return;
        }
        AttributeList attributeList = new AttributeList();
        if (!writer.isNamespaceDefined(entryNamespace)) {
            String defaultNamespace = bundleWriter.getDefaultPrefix(entryNamespace);
            if (defaultNamespace != null && !writer.isNamespacePrefixDefined(defaultNamespace)) {
                attributeList.addNamespaceDeclaration(defaultNamespace, entryNamespace);
            } else {
                attributeList.addNamespaceDeclaration("autoGenNs", entryNamespace);
            }
        }
        OfficeDocumentStatistic statistic = (OfficeDocumentStatistic)entryValue;
        attributeList.setAttribute("urn:oasis:names:tc:opendocument:xmlns:meta:1.0", "table-count", String.valueOf(statistic.getTableCount()));
        attributeList.setAttribute("urn:oasis:names:tc:opendocument:xmlns:meta:1.0", "image-count", String.valueOf(statistic.getImageCount()));
        attributeList.setAttribute("urn:oasis:names:tc:opendocument:xmlns:meta:1.0", "object-count", String.valueOf(statistic.getObjectCount()));
        attributeList.setAttribute("urn:oasis:names:tc:opendocument:xmlns:meta:1.0", "page-count", String.valueOf(statistic.getPageCount()));
        attributeList.setAttribute("urn:oasis:names:tc:opendocument:xmlns:meta:1.0", "paragraph-count", String.valueOf(statistic.getParagraphCount()));
        attributeList.setAttribute("urn:oasis:names:tc:opendocument:xmlns:meta:1.0", "word-count", String.valueOf(statistic.getWordCount()));
        attributeList.setAttribute("urn:oasis:names:tc:opendocument:xmlns:meta:1.0", "character-count", String.valueOf(statistic.getCharacterCount()));
        writer.writeTag(entryNamespace, entryName, attributeList, true);
    }
}

