/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.requirejs.impl.plugins;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.pentaho.requirejs.IRequireJsPackageConfiguration;
import org.pentaho.requirejs.IRequireJsPackageConfigurationPlugin;

public class AmdPluginConfig
implements IRequireJsPackageConfigurationPlugin {
    public void apply(IRequireJsPackageConfiguration requireJsPackageConfig, Function<String, IRequireJsPackageConfiguration> dependencyResolver, Function<String, String> resolveModuleId, Map<String, ?> requireConfig) {
        Map config;
        if (requireConfig.containsKey("config") && (config = (Map)requireConfig.get("config")).containsKey("amd")) {
            this.convertAmdConfigurations((Map)config.get("amd"), resolveModuleId);
        }
    }

    private void convertAmdConfigurations(Map<String, Object> configuration, Function<String, String> resolveModuleId) {
        if (configuration.containsKey("shim")) {
            Map originalShimConfiguration = (Map)configuration.get("shim");
            Map<String, ?> convertAmdShimConfigurations = this.convertAmdShimConfigurations(originalShimConfiguration, resolveModuleId);
            configuration.put("shim", convertAmdShimConfigurations);
        }
    }

    private Map<String, ?> convertAmdShimConfigurations(Map<String, Map<String, ?>> originalShimConfiguration, Function<String, String> resolveModuleId) {
        HashMap convertedShimConfiguration = new HashMap();
        for (String moduleId : originalShimConfiguration.keySet()) {
            String versionedModuleId = resolveModuleId.apply(moduleId);
            HashMap shimConfig = new HashMap();
            Map<String, ?> originalModuleShimConfiguration = originalShimConfiguration.get(moduleId);
            for (String key : originalModuleShimConfiguration.keySet()) {
                Object originalValue;
                Object convertedValue = originalValue = originalModuleShimConfiguration.get(key);
                if (key.equals("deps")) {
                    HashMap originalDeps = (HashMap)originalValue;
                    HashMap convertedDeps = new HashMap();
                    for (String depModuleId : originalDeps.keySet()) {
                        String versionedDepModuleId = resolveModuleId.apply(depModuleId);
                        convertedDeps.put(versionedDepModuleId, originalDeps.get(depModuleId));
                    }
                    convertedValue = convertedDeps;
                }
                shimConfig.put(key, convertedValue);
            }
            convertedShimConfiguration.put(versionedModuleId, shimConfig);
        }
        return convertedShimConfiguration;
    }
}

