/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.util;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.pentaho.di.base.AbstractMeta;
import org.pentaho.di.core.ProvidesDatabaseConnectionInformation;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.parameters.UnknownParamException;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.metastore.api.IMetaStore;

public class TransUtil {
    public static Map<String, ProvidesDatabaseConnectionInformation> collectOutputStepInTrans(TransMeta transMeta, Repository repository, IMetaStore metastore) throws KettleException {
        HashMap<String, ProvidesDatabaseConnectionInformation> stepMap = new HashMap<String, ProvidesDatabaseConnectionInformation>();
        for (StepMeta stepMeta : transMeta.getSteps()) {
            TransMeta relatedTransMeta;
            ProvidesDatabaseConnectionInformation info = TransUtil.getDatabaseConnectionInformation(stepMeta.getStepMetaInterface());
            if (info != null) {
                stepMap.put(StringUtils.trimToEmpty((String)stepMeta.getName()), info);
                continue;
            }
            if (stepMeta == null || stepMeta.getStepMetaInterface() == null || (relatedTransMeta = stepMeta.getStepMetaInterface().fetchTransMeta(stepMeta.getStepMetaInterface(), repository, metastore, (VariableSpace)transMeta)) == null) continue;
            stepMap.putAll(TransUtil.collectOutputStepInTrans(relatedTransMeta, repository, metastore));
        }
        return stepMap;
    }

    private static ProvidesDatabaseConnectionInformation getDatabaseConnectionInformation(Object o) {
        if (o != null && ProvidesDatabaseConnectionInformation.class.isAssignableFrom(o.getClass())) {
            return (ProvidesDatabaseConnectionInformation)ProvidesDatabaseConnectionInformation.class.cast(o);
        }
        return null;
    }

    public static void resetParams(AbstractMeta meta, LogChannelInterface logChannel) {
        String[] params;
        for (String key : params = meta.listParameters()) {
            try {
                meta.setParameterValue(key, meta.getParameterDefault(key));
                meta.setVariable(key, meta.getParameterDefault(key));
            }
            catch (UnknownParamException e) {
                logChannel.logDebug("couldn't set param " + key);
            }
        }
    }
}

