/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.trans.steps.common;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.pentaho.agilebi.modeler.models.annotations.AnnotationType;
import org.pentaho.agilebi.modeler.models.annotations.CreateCalculatedMember;
import org.pentaho.agilebi.modeler.models.annotations.ModelAnnotation;
import org.pentaho.agilebi.modeler.models.annotations.ModelAnnotationGroup;
import org.pentaho.di.core.refinery.publish.util.ObjectUtils;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.annotation.BaseAnnotationMeta;
import org.pentaho.di.trans.steps.annotation.ModelAnnotationMeta;
import org.pentaho.di.ui.core.PropsUI;
import org.pentaho.di.ui.core.gui.GUIResource;
import org.pentaho.di.ui.trans.steps.annotation.FieldSelectionDialog;
import org.pentaho.di.ui.trans.steps.annotation.ModelAnnotationActionCustomDialog;
import org.pentaho.di.ui.trans.steps.common.BaseComposite;
import org.pentaho.di.ui.trans.steps.common.ModelAnnotationEvent;
import org.pentaho.metastore.api.IMetaStore;

public abstract class ModelAnnotationsTableComposite
extends BaseComposite {
    private Composite parent;
    private Label wEdit;
    private Label wDelete;
    private Control topWidget;
    private Control bottomWidget;
    private TableViewer wFields;
    private Button wGetFields;
    private Button wAddCalcMeasure;
    private PropsUI props;
    private Color notInStreamColor;

    public ModelAnnotationsTableComposite(Composite parent, Control topWidget, Control bottomWidget) {
        super(parent, 0);
        this.parent = parent;
        this.topWidget = topWidget;
        this.bottomWidget = bottomWidget;
        this.init();
    }

    public void init() {
        this.props = PropsUI.getInstance();
        this.notInStreamColor = new Color((Device)this.parent.getDisplay(), 160, 160, 160);
    }

    public void createWidgets() {
        Control localTopWidget = this.createFieldsTableHeader(this.topWidget);
        this.wGetFields = new Button(this.parent, 8);
        this.wGetFields.setText(BaseMessages.getString(this.getLocalizationPkg(), (String)"ModelAnnotation.GetFields.Button", (String[])new String[0]));
        FormData fdGetFields = new FormData();
        fdGetFields.right = new FormAttachment(100, -10);
        fdGetFields.bottom = new FormAttachment(this.bottomWidget, -15);
        this.wGetFields.setLayoutData((Object)fdGetFields);
        this.wGetFields.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                ModelAnnotationsTableComposite.this.onGetFields();
            }
        });
        if (this.supportsCalculatedMeasure()) {
            this.wAddCalcMeasure = new Button(this.parent, 8);
            this.wAddCalcMeasure.setText(BaseMessages.getString(this.getLocalizationPkg(), (String)"ModelAnnotation.AddCalcMeasure.Button", (String[])new String[0]));
            FormData fdAddCalcMeasure = new FormData();
            fdAddCalcMeasure.right = new FormAttachment((Control)this.wGetFields, -4);
            fdAddCalcMeasure.bottom = new FormAttachment(this.bottomWidget, -15);
            this.wAddCalcMeasure.setLayoutData((Object)fdAddCalcMeasure);
            this.wAddCalcMeasure.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    ModelAnnotationsTableComposite.this.onCreateCalculatedMeasure();
                }
            });
        }
        this.wFields = new TableViewer(this.parent, 68098);
        this.wFields.getControl().addListener(13, new Listener(){

            public void handleEvent(Event event) {
                ModelAnnotationsTableComposite.this.onItemSelect();
            }
        });
        FormData fdFields = new FormData();
        fdFields.top = new FormAttachment(localTopWidget, 5);
        fdFields.left = new FormAttachment(0, 10);
        fdFields.right = new FormAttachment(100, -10);
        fdFields.bottom = new FormAttachment((Control)this.wGetFields, -10);
        this.wFields.getTable().setLayoutData((Object)fdFields);
        this.wFields.getTable().setHeaderVisible(true);
        TableViewerColumn fieldColumn = new TableViewerColumn(this.wFields, 0);
        fieldColumn.getColumn().setText(BaseMessages.getString(this.getLocalizationPkg(), (String)"ModelAnnotation.ColumnInfo.Field", (String[])new String[0]));
        fieldColumn.getColumn().setWidth(195);
        fieldColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                ModelAnnotation modelAnnotation = (ModelAnnotation)element;
                if (modelAnnotation.getType() == ModelAnnotation.Type.CREATE_CALCULATED_MEMBER) {
                    return BaseMessages.getString(ModelAnnotationsTableComposite.this.getLocalizationPkg(), (String)"ModelAnnotation.Fields.CalculatedMeasure", (String[])new String[0]);
                }
                return modelAnnotation.getField();
            }
        });
        TableViewerColumn actionColumn = new TableViewerColumn(this.wFields, 0);
        actionColumn.getColumn().setText(BaseMessages.getString(this.getLocalizationPkg(), (String)"ModelAnnotation.ColumnInfo.ModelAction", (String[])new String[0]));
        actionColumn.getColumn().setWidth(150);
        actionColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                ModelAnnotation modelAnnotation = (ModelAnnotation)element;
                if (modelAnnotation.getType() != null) {
                    return modelAnnotation.getType().description();
                }
                return "";
            }
        });
        TableViewerColumn summaryColumn = new TableViewerColumn(this.wFields, 0);
        summaryColumn.getColumn().setText(BaseMessages.getString(this.getLocalizationPkg(), (String)"ModelAnnotation.ColumnInfo.Summary", (String[])new String[0]));
        summaryColumn.getColumn().setWidth(0);
        summaryColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                ModelAnnotation modelAnnotation = (ModelAnnotation)element;
                if (modelAnnotation.getAnnotation() != null) {
                    return modelAnnotation.getAnnotation().getSummary();
                }
                return BaseMessages.getString(ModelAnnotationsTableComposite.this.getLocalizationPkg(), (String)"ModelAnnotation.Dialog.NoAnnotation", (String[])new String[0]);
            }
        });
        this.wFields.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent doubleClickEvent) {
                ModelAnnotationsTableComposite.this.onItemDoubleClick();
            }
        });
        this.wFields.getTable().setSize(900, 570);
    }

    private Control createFieldsTableHeader(Control topWidget) {
        Label wFieldsTableHeader = new Label(this.parent, 16384);
        wFieldsTableHeader.setText(BaseMessages.getString(this.getLocalizationPkg(), (String)"ModelAnnotation.FieldsTable.Header.Label", (String[])new String[0]));
        this.props.setLook((Control)wFieldsTableHeader);
        FormData fdFieldsTableHeader = new FormData();
        fdFieldsTableHeader.top = new FormAttachment(topWidget, 10);
        fdFieldsTableHeader.left = new FormAttachment(0, 10);
        wFieldsTableHeader.setLayoutData((Object)fdFieldsTableHeader);
        this.wDelete = new Label(this.parent, 0x800000);
        this.wDelete.setImage(GUIResource.getInstance().getImageDelete());
        this.wDelete.setToolTipText(BaseMessages.getString(this.getLocalizationPkg(), (String)"ModelAnnotation.FieldsTable.Header.Delete", (String[])new String[0]));
        this.wDelete.setEnabled(false);
        this.props.setLook((Control)this.wDelete);
        FormData fdDelete = new FormData();
        fdDelete.top = new FormAttachment(topWidget, 10);
        fdDelete.right = new FormAttachment(100, -10);
        this.wDelete.setLayoutData((Object)fdDelete);
        this.wEdit = new Label(this.parent, 0x800000);
        this.wEdit.setImage(GUIResource.getInstance().getImageEdit());
        this.wEdit.setToolTipText(BaseMessages.getString(this.getLocalizationPkg(), (String)"ModelAnnotation.FieldsTable.Header.Edit", (String[])new String[0]));
        this.wEdit.setEnabled(false);
        this.props.setLook((Control)this.wEdit);
        FormData fdEdit = new FormData();
        fdEdit.top = new FormAttachment(topWidget, 10);
        fdEdit.right = new FormAttachment((Control)this.wDelete, -4, 16384);
        this.wEdit.setLayoutData((Object)fdEdit);
        this.wDelete.addListener(4, new Listener(){

            public void handleEvent(Event event) {
                ModelAnnotationsTableComposite.this.onDelete();
            }
        });
        this.wEdit.addListener(4, new Listener(){

            public void handleEvent(Event event) {
                ModelAnnotationsTableComposite.this.onEdit();
            }
        });
        return wFieldsTableHeader;
    }

    public void populateTable(ModelAnnotationGroup modelAnnotations, TransMeta transMeta, String stepName, Shell shell) {
        String[] fieldNames = new String[]{};
        try {
            fieldNames = transMeta.getPrevStepFields(stepName).getFieldNames();
        }
        catch (Exception e) {
            this.logError("could not determine stream fields", e);
        }
        ModelAnnotationGroup tableModelAnnotations = ObjectUtils.deepClone(modelAnnotations);
        this.setData(tableModelAnnotations);
        this.adjustFont(this.getTable().getItems(), shell, fieldNames);
        this.toggleDeleteEditButtons();
    }

    public void toggleDeleteEditButtons() {
        int selectionCount = this.wFields.getTable().getSelectionCount();
        boolean validSelection = this.isAnnotationEditValid();
        this.wEdit.setEnabled(validSelection && selectionCount == 1);
        this.wEdit.setImage(new Image((Device)this.parent.getParent().getDisplay(), GUIResource.getInstance().getImageEdit(), selectionCount == 1 && validSelection ? 0 : 1));
        this.wDelete.setEnabled(selectionCount > 0);
        this.wDelete.setImage(new Image((Device)this.parent.getParent().getDisplay(), GUIResource.getInstance().getImageDelete(), selectionCount > 0 ? 0 : 1));
    }

    private boolean isAnnotationEditValid() {
        boolean validSelection = true;
        TableItem[] sel = this.wFields.getTable().getSelection();
        if (sel != null && sel.length > 0 && sel[0].getForeground().equals((Object)this.notInStreamColor)) {
            validSelection = false;
        }
        return validSelection;
    }

    public void deleteAnnotation() {
        int[] selectionIndices = this.getTable().getSelectionIndices();
        ModelAnnotationGroup toRemove = new ModelAnnotationGroup();
        ModelAnnotationGroup tableInput = this.getData();
        for (int selectionIndice : selectionIndices) {
            toRemove.add(tableInput.get(selectionIndice));
        }
        tableInput.removeAll((Collection)toRemove);
        this.refresh();
        this.toggleDeleteEditButtons();
    }

    public void editAnnotation(Shell shell, BaseAnnotationMeta input, TransMeta transMeta, String stepName, IMetaStore metaStore, Listener onClose) {
        if (this.getTable().getSelectionIndex() < 0) {
            return;
        }
        if (!this.isAnnotationEditValid()) {
            return;
        }
        ModelAnnotationActionCustomDialog actionDialog = new ModelAnnotationActionCustomDialog(shell, input, transMeta, stepName, metaStore);
        actionDialog.setSelectionIndex(this.getTable().getSelectionIndex());
        actionDialog.setModelAnnotations(this.getData());
        actionDialog.onClose(onClose);
        actionDialog.open();
    }

    public void createCalculatedMeasure(Shell shell, ModelAnnotationMeta input, TransMeta transMeta, String stepName, IMetaStore metaStore, final Listener onClose) {
        CreateCalculatedMember calculatedMember = new CreateCalculatedMember();
        final ModelAnnotation calculatedMemberAnnot = new ModelAnnotation((AnnotationType)calculatedMember);
        ModelAnnotationGroup modelAnnotations = ObjectUtils.deepClone(this.getData());
        modelAnnotations.add((Object)calculatedMemberAnnot);
        ModelAnnotationActionCustomDialog actionDialog = new ModelAnnotationActionCustomDialog(shell, input, transMeta, stepName, metaStore);
        actionDialog.setSelectionIndex(modelAnnotations.size() - 1);
        actionDialog.setModelAnnotations(modelAnnotations);
        actionDialog.onClose(new Listener(){

            public void handleEvent(Event event) {
                try {
                    ModelAnnotationEvent e = (ModelAnnotationEvent)event;
                    if (e.isActionCancelled()) {
                        ModelAnnotationsTableComposite.this.removePlaceholderCalculatedMember(e, calculatedMemberAnnot);
                    }
                }
                catch (Exception e) {
                    ModelAnnotationsTableComposite.this.logError(e.getMessage(), e);
                }
                onClose.handleEvent(event);
            }
        });
        actionDialog.open();
    }

    private void removePlaceholderCalculatedMember(ModelAnnotationEvent e, ModelAnnotation annotation) {
        if (e == null || e.getModelAnnotations() == null || annotation == null) {
            return;
        }
        ModelAnnotation toBeRemoved = null;
        for (ModelAnnotation modelAnnotation : e.getModelAnnotations()) {
            if (modelAnnotation.getType() == null || modelAnnotation.getType() != ModelAnnotation.Type.CREATE_CALCULATED_MEMBER || !modelAnnotation.getName().equals(annotation.getName())) continue;
            toBeRemoved = modelAnnotation;
            break;
        }
        if (toBeRemoved != null) {
            e.getModelAnnotations().remove(toBeRemoved);
        }
    }

    public void getFields(Shell parent, StepMetaInterface input, TransMeta transMeta, String stepName, Listener onClose) {
        ModelAnnotationGroup modelAnnotations = ObjectUtils.deepClone(this.getData());
        FieldSelectionDialog fieldSelectionDialog = new FieldSelectionDialog(parent, input, transMeta, stepName, modelAnnotations);
        fieldSelectionDialog.open();
        this.populateTable(modelAnnotations, transMeta, stepName, parent);
        onClose.handleEvent((Event)new ModelAnnotationEvent(modelAnnotations));
    }

    public void adjustFont(TableItem[] tableItems, final Shell shell, String[] fieldNamesArray) {
        try {
            final Table table = this.getTable();
            this.removeListener((Control)table, 5);
            this.removeListener((Control)table, 6);
            final ArrayList<TableItem> missingItems = new ArrayList<TableItem>();
            final List<String> fieldNames = Arrays.asList(fieldNamesArray);
            this.markMissingItems(tableItems, shell, fieldNames, missingItems);
            Listener mouseListener = new Listener(){

                public void handleEvent(Event event) {
                    boolean overMissing = false;
                    boolean needRefresh = false;
                    for (TableItem missingItem : missingItems) {
                        if (missingItem.isDisposed() || !ModelAnnotationsTableComposite.this.isMarkedMissing(missingItem)) {
                            needRefresh = true;
                            continue;
                        }
                        if (!missingItem.getBounds(0).contains(event.x, event.y) && !missingItem.getBounds(1).contains(event.x, event.y) && !missingItem.getBounds(2).contains(event.x, event.y)) continue;
                        table.setToolTipText(BaseMessages.getString(ModelAnnotationsTableComposite.this.getLocalizationPkg(), (String)"ModelAnnotation.FieldsTable.Missing.ToolTip", (String[])new String[0]));
                        overMissing = true;
                    }
                    if (needRefresh) {
                        missingItems.clear();
                        ModelAnnotationsTableComposite.this.markMissingItems(table.getItems(), shell, fieldNames, missingItems);
                    }
                    if (!overMissing) {
                        table.setToolTipText(null);
                    }
                }
            };
            table.addListener(5, mouseListener);
            table.addListener(6, mouseListener);
        }
        catch (Exception e) {
            this.logError("could not determine stream fields", e);
        }
    }

    private boolean isMarkedMissing(TableItem item) {
        return item.getForeground().equals((Object)this.notInStreamColor);
    }

    private void markMissingItems(TableItem[] tableItems, Shell shell, List<String> fieldNames, ArrayList<TableItem> missingItems) {
        for (TableItem tableItem : tableItems) {
            ModelAnnotation annotation = (ModelAnnotation)tableItem.getData();
            if (annotation.getType() == ModelAnnotation.Type.CREATE_CALCULATED_MEMBER || fieldNames.contains(tableItem.getText())) continue;
            tableItem.setForeground(this.notInStreamColor);
            FontData fontData = tableItem.getFont().getFontData()[0];
            Font font = new Font((Device)shell.getDisplay(), new FontData(fontData.getName(), fontData.getHeight(), 2));
            tableItem.setFont(font);
            missingItems.add(tableItem);
        }
    }

    private void removeListener(Control control, int listenerType) {
        Listener[] listeners = control.getListeners(listenerType);
        if (listeners.length > 0) {
            control.removeListener(listenerType, listeners[0]);
        }
    }

    public void setData(ModelAnnotationGroup group) {
        this.wFields.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.wFields.setInput((Object)group);
    }

    public ModelAnnotationGroup getData() {
        return this.wFields.getInput() == null ? new ModelAnnotationGroup() : this.wFields.getInput();
    }

    public void setEnabled(boolean enabled) {
        this.wFields.getControl().setEnabled(enabled);
        this.wGetFields.setEnabled(enabled);
    }

    public void refresh() {
        this.wFields.refresh();
    }

    public Table getTable() {
        return this.wFields.getTable();
    }

    protected abstract void onDelete();

    protected abstract void onEdit();

    protected abstract void onGetFields();

    protected abstract void onItemSelect();

    protected abstract void onItemDoubleClick();

    protected abstract boolean supportsCalculatedMeasure();

    protected abstract void onCreateCalculatedMeasure();
}

