/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.s3common;

import com.amazonaws.regions.Regions;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import java.util.Collection;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.provider.AbstractFileName;
import org.apache.commons.vfs2.provider.AbstractFileSystem;
import org.pentaho.amazon.s3.S3Util;
import org.pentaho.s3common.S3CommonFileProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class S3CommonFileSystem
extends AbstractFileSystem {
    private String awsAccessKeyCache;
    private String awsSecretKeyCache;
    private AmazonS3 client;
    private static final Logger logger = LoggerFactory.getLogger(S3CommonFileSystem.class);

    protected S3CommonFileSystem(FileName rootName, FileSystemOptions fileSystemOptions) {
        super(rootName, null, fileSystemOptions);
    }

    protected void addCapabilities(Collection caps) {
        caps.addAll(S3CommonFileProvider.capabilities);
    }

    protected abstract FileObject createFile(AbstractFileName var1) throws Exception;

    public AmazonS3 getS3Client() {
        if (this.client == null || this.hasClientChangedCredentials()) {
            try {
                this.client = (AmazonS3)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)AmazonS3ClientBuilder.standard().enableForceGlobalBucketAccess()).withRegion(Regions.DEFAULT_REGION)).build();
                this.awsAccessKeyCache = System.getProperty("aws.accessKeyId");
                this.awsSecretKeyCache = System.getProperty("aws.secretKey");
            }
            catch (Throwable t) {
                logger.error("Could not get an S3Client", t);
            }
        }
        return this.client;
    }

    private boolean hasClientChangedCredentials() {
        return this.client != null && (S3Util.hasChanged(this.awsAccessKeyCache, System.getProperty("aws.accessKeyId")) || S3Util.hasChanged(this.awsSecretKeyCache, System.getProperty("aws.secretKey")));
    }
}

