/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.big.data.kettle.plugins.hdfs.trans;

import java.util.Map;
import org.pentaho.big.data.api.cluster.NamedCluster;
import org.pentaho.big.data.api.cluster.NamedClusterService;
import org.pentaho.big.data.kettle.plugins.hdfs.trans.HadoopFileMeta;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.annotations.Step;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.injection.InjectionSupported;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.variables.Variables;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.metastore.MetaStoreConst;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.resource.ResourceDefinition;
import org.pentaho.di.resource.ResourceNamingInterface;
import org.pentaho.di.trans.steps.textfileoutput.TextFileOutputMeta;
import org.pentaho.metastore.api.IMetaStore;
import org.pentaho.runtime.test.RuntimeTester;
import org.pentaho.runtime.test.action.RuntimeTestActionService;
import org.w3c.dom.Node;

@Step(id="HadoopFileOutputPlugin", image="HDO.svg", name="HadoopFileOutputPlugin.Name", description="HadoopFileOutputPlugin.Description", documentationUrl="Products/Hadoop_File_Output", categoryDescription="i18n:org.pentaho.di.trans.step:BaseStep.Category.BigData", i18nPackageName="org.pentaho.di.trans.steps.hadoopfileoutput")
@InjectionSupported(localizationPrefix="HadoopFileOutput.Injection.", groups={"OUTPUT_FIELDS"})
public class HadoopFileOutputMeta
extends TextFileOutputMeta
implements HadoopFileMeta {
    private static Class<?> PKG = HadoopFileOutputMeta.class;
    private String sourceConfigurationName;
    private static final String SOURCE_CONFIGURATION_NAME = "source_configuration_name";
    private final NamedClusterService namedClusterService;
    private final RuntimeTestActionService runtimeTestActionService;
    private final RuntimeTester runtimeTester;
    private IMetaStore metaStore;
    private Node embeddedNamedClusterNode;

    public HadoopFileOutputMeta(NamedClusterService namedClusterService, RuntimeTestActionService runtimeTestActionService, RuntimeTester runtimeTester) {
        this.namedClusterService = namedClusterService;
        this.runtimeTestActionService = runtimeTestActionService;
        this.runtimeTester = runtimeTester;
    }

    public void setDefault() {
        super.setDefault();
        this.setFileName("");
    }

    public String getSourceConfigurationName() {
        return this.sourceConfigurationName;
    }

    public void setSourceConfigurationName(String ncName) {
        this.sourceConfigurationName = ncName;
    }

    protected String loadSource(Node stepnode, IMetaStore metastore) {
        this.metaStore = metastore;
        String url = XMLHandler.getTagValue((Node)stepnode, (String)"file", (String)"name");
        this.sourceConfigurationName = XMLHandler.getTagValue((Node)stepnode, (String)"file", (String)SOURCE_CONFIGURATION_NAME);
        this.embeddedNamedClusterNode = XMLHandler.getSubNode((Node)stepnode, (String)"NamedCluster");
        return this.getProcessedUrl(metastore, url);
    }

    protected String getProcessedUrl(IMetaStore metastore, String url) {
        NamedCluster c;
        if (url == null) {
            return null;
        }
        if (metastore == null) {
            try {
                this.metaStore = MetaStoreConst.openLocalPentahoMetaStore((boolean)false);
            }
            catch (Exception exception) {}
        } else {
            this.metaStore = metastore;
        }
        if ((c = this.getNamedCluster()) != null) {
            url = c.processURLsubstitution(url, this.metaStore, (VariableSpace)new Variables());
        }
        return url;
    }

    @Override
    public String getClusterName(String url) {
        NamedCluster cluster = this.getNamedCluster();
        return cluster == null ? null : cluster.getName();
    }

    public NamedCluster getNamedCluster() {
        NamedCluster cluster = null;
        if (this.metaStore != null) {
            cluster = this.namedClusterService.getNamedClusterByName(this.sourceConfigurationName, this.metaStore);
        } else if (this.namedClusterService.getClusterTemplate() != null) {
            cluster = this.namedClusterService.getClusterTemplate().fromXmlForEmbed(this.embeddedNamedClusterNode);
        }
        return cluster;
    }

    @Override
    public String getUrlPath(String incomingURL) {
        return this.getProcessedUrl(null, incomingURL);
    }

    protected void saveSource(StringBuilder retVal, String fileName) {
        retVal.append("      ").append(XMLHandler.addTagValue((String)"name", (String)fileName));
        retVal.append("      ").append(XMLHandler.addTagValue((String)SOURCE_CONFIGURATION_NAME, (String)this.sourceConfigurationName));
    }

    public String getXML() {
        String xml = super.getXML();
        NamedCluster c = this.namedClusterService.getNamedClusterByName(this.sourceConfigurationName, this.metaStore);
        if (c != null) {
            xml = xml + c.toXmlForEmbed("NamedCluster") + Const.CR;
        }
        return xml;
    }

    protected String loadSourceRep(Repository rep, ObjectId id_step, IMetaStore metaStore) throws KettleException {
        this.metaStore = metaStore;
        String url = rep.getStepAttributeString(id_step, "file_name");
        this.sourceConfigurationName = rep.getStepAttributeString(id_step, SOURCE_CONFIGURATION_NAME);
        return this.getProcessedUrl(metaStore, url);
    }

    protected void saveSourceRep(Repository rep, ObjectId id_transformation, ObjectId id_step, String fileName) throws KettleException {
        rep.saveStepAttribute(id_transformation, id_step, "file_name", fileName);
        rep.saveStepAttribute(id_transformation, id_step, SOURCE_CONFIGURATION_NAME, this.sourceConfigurationName);
    }

    public NamedClusterService getNamedClusterService() {
        return this.namedClusterService;
    }

    public RuntimeTester getRuntimeTester() {
        return this.runtimeTester;
    }

    public RuntimeTestActionService getRuntimeTestActionService() {
        return this.runtimeTestActionService;
    }

    public String exportResources(VariableSpace space, Map<String, ResourceDefinition> definitions, ResourceNamingInterface resourceNamingInterface, Repository repository, IMetaStore metaStore) throws KettleException {
        return null;
    }
}

