/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.plugins.fileopensave.cache;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.pentaho.di.plugins.fileopensave.api.providers.File;

public class FileCache {
    private Map<File, List<File>> fileCache = new HashMap<File, List<File>>();

    public boolean containsKey(File file) {
        return this.fileCache.containsKey(file);
    }

    public List<File> getFiles(File file) {
        return this.fileCache.get(file);
    }

    public void setFiles(File file, List<File> files) {
        this.fileCache.put(file, files);
    }

    public boolean removeFile(File parent, File file) {
        if (this.fileCache.containsKey(parent)) {
            this.fileCache.get(parent).remove(file);
            return true;
        }
        return false;
    }

    public boolean addFile(File parent, File file) {
        if (this.fileCache.containsKey(parent)) {
            this.fileCache.get(parent).add(file);
        }
        return false;
    }

    public boolean move(File oldParent, File oldFile, File newParent, File newFile) {
        return this.removeFile(oldParent, oldFile) && this.addFile(newParent, newFile);
    }

    public boolean fileExists(File parent, String path) {
        if (this.fileCache.containsKey(parent)) {
            return this.fileCache.get(parent).stream().anyMatch(file -> file.getPath().equals(path));
        }
        return false;
    }

    public boolean clear(File file) {
        if (this.fileCache.containsKey(file)) {
            this.fileCache.remove(file);
            return true;
        }
        return false;
    }
}

