/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.plugins.fileopensave.controllers;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.function.Supplier;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.pentaho.di.core.EngineMetaInterface;
import org.pentaho.di.core.LastUsedFile;
import org.pentaho.di.plugins.fileopensave.providers.repository.RepositoryFileProvider;
import org.pentaho.di.plugins.fileopensave.providers.repository.model.RepositoryDirectory;
import org.pentaho.di.plugins.fileopensave.providers.repository.model.RepositoryFile;
import org.pentaho.di.plugins.fileopensave.providers.repository.model.RepositoryName;
import org.pentaho.di.repository.IUser;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.repository.RepositoryDirectoryInterface;
import org.pentaho.di.repository.RepositoryExtended;
import org.pentaho.di.repository.RepositoryObject;
import org.pentaho.di.repository.RepositoryObjectInterface;
import org.pentaho.di.repository.RepositoryObjectType;
import org.pentaho.di.ui.core.PropsUI;
import org.pentaho.di.ui.spoon.Spoon;

public class RepositoryBrowserController {
    public static final String PENTAHO_ENTERPRISE_REPOSITORY = "PentahoEnterpriseRepository";
    public static Repository repository;
    public static final String TRANSFORMATION = "transformation";
    public static final String JOB = "job";
    public static final String FOLDER = "folder";
    public static final String FILTER = "*.ktr|*.kjb";
    private RepositoryDirectoryInterface rootDirectory;
    private Supplier<Spoon> spoonSupplier = Spoon::getInstance;
    private final RepositoryFileProvider repositoryFileProvider;

    public RepositoryBrowserController(RepositoryFileProvider repositoryFileProvider) {
        this.repositoryFileProvider = repositoryFileProvider;
    }

    public String getActiveFileName() {
        try {
            return this.getSpoon().getActiveMeta().getName();
        }
        catch (Exception e) {
            return "";
        }
    }

    private void removeRecentsUsingPath(String path) {
        Collection lastUsedRepoFiles = PropsUI.getInstance().getLastUsedRepoFiles().values();
        for (List lastUsedFiles : lastUsedRepoFiles) {
            for (int i = 0; i < lastUsedFiles.size(); ++i) {
                if (!(((LastUsedFile)lastUsedFiles.get(i)).getDirectory() + "/").startsWith(path + "/")) continue;
                lastUsedFiles.remove(i);
                --i;
            }
        }
    }

    public List<RepositoryFile> getRecentFiles() {
        if (this.spoonSupplier.get().rep == null) {
            return Collections.emptyList();
        }
        PropsUI props = PropsUI.getInstance();
        ArrayList<RepositoryFile> repositoryFiles = new ArrayList<RepositoryFile>();
        IUser userInfo = this.spoonSupplier.get().rep.getUserInfo();
        String repoAndUser = this.spoonSupplier.get().rep.getName() + ":" + (userInfo != null ? userInfo.getLogin() : "");
        List lastUsedFiles = props.getLastUsedRepoFiles().getOrDefault(repoAndUser, Collections.emptyList());
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, -30);
        Date dateBefore = calendar.getTime();
        for (int i = 0; i < lastUsedFiles.size(); ++i) {
            LastUsedFile lastUsedFile = (LastUsedFile)lastUsedFiles.get(i);
            if (lastUsedFile.getLastOpened().before(dateBefore) || lastUsedFile.getRepositoryName() == null || !lastUsedFile.getRepositoryName().equals(Spoon.getInstance().rep.getName())) continue;
            RepositoryFile repositoryFile = new RepositoryFile();
            String index = String.valueOf(i);
            repositoryFile.setObjectId(index);
            repositoryFile.setType(lastUsedFile.isTransformation() ? TRANSFORMATION : JOB);
            repositoryFile.setName(lastUsedFile.getFilename());
            repositoryFile.setPath(lastUsedFile.getDirectory());
            repositoryFile.setDate(lastUsedFile.getLastOpened());
            repositoryFile.setRepository(lastUsedFile.getRepositoryName());
            repositoryFile.setUsername(lastUsedFile.getUsername());
            repositoryFiles.add(repositoryFile);
        }
        return repositoryFiles;
    }

    private boolean renameRecent(String id, String type, String name) {
        RepositoryObject repositoryObject = null;
        try {
            repositoryObject = this.getRepository().getObjectInformation(() -> id, type.equals(TRANSFORMATION) ? RepositoryObjectType.TRANSFORMATION : RepositoryObjectType.JOB);
        }
        catch (Exception e) {
            return false;
        }
        if (repositoryObject != null) {
            Collection lastUsedRepoFiles = PropsUI.getInstance().getLastUsedRepoFiles().values();
            for (List lastUsedFiles : lastUsedRepoFiles) {
                for (LastUsedFile lastUsedFile : lastUsedFiles) {
                    if (!lastUsedFile.getDirectory().equals(repositoryObject.getRepositoryDirectory().getPath()) || !lastUsedFile.getFilename().equals(repositoryObject.getName())) continue;
                    lastUsedFile.setFilename(name);
                    return true;
                }
            }
        }
        return true;
    }

    public boolean updateRecentFiles(String oldPath, String newPath) {
        try {
            Collection lastUsedRepoFiles = PropsUI.getInstance().getLastUsedRepoFiles().values();
            for (List lastUsedFiles : lastUsedRepoFiles) {
                for (int i = 0; i < lastUsedFiles.size(); ++i) {
                    if (!(((LastUsedFile)lastUsedFiles.get(i)).getDirectory() + "/").startsWith(oldPath + "/")) continue;
                    if (((LastUsedFile)lastUsedFiles.get(i)).getDirectory().length() == oldPath.length()) {
                        ((LastUsedFile)lastUsedFiles.get(i)).setDirectory(newPath);
                        continue;
                    }
                    String prefix = newPath.substring(0, newPath.lastIndexOf("/")) + "/";
                    String newFolder = newPath.substring(newPath.lastIndexOf("/") + 1);
                    String suffix = ((LastUsedFile)lastUsedFiles.get(i)).getDirectory().substring(oldPath.length());
                    ((LastUsedFile)lastUsedFiles.get(i)).setDirectory(prefix + newFolder + suffix);
                }
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    private boolean hasDupeFolder(String parent, String name) {
        try {
            RepositoryDirectoryInterface rdi = this.getRepository().findDirectory(parent).findChild(name);
            return rdi != null;
        }
        catch (Exception e) {
            System.out.println(e);
            return false;
        }
    }

    public boolean saveFile(String path, String name, String fileName, boolean override) {
        boolean result = this.checkForSecurityOrDupeIssues(path, name, fileName, override);
        if (result) {
            try {
                RepositoryDirectoryInterface repositoryDirectoryInterface = this.findDirectory(path);
                this.getSpoon().getDisplay().asyncExec(() -> {
                    try {
                        EngineMetaInterface meta = this.getSpoon().getActiveMeta();
                        meta.setRepositoryDirectory(repositoryDirectoryInterface);
                        meta.setName(name);
                        this.getSpoon().saveToRepositoryConfirmed(meta);
                        this.getSpoon().delegates.tabs.renameTabs();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                });
            }
            catch (Exception e) {
                return false;
            }
        }
        return result;
    }

    public boolean checkForSecurityOrDupeIssues(String path, String name, String fileName, boolean override) {
        return this.checkSecurity() && !this.hasDupeFile(path, name, fileName, override);
    }

    private boolean hasDupeFile(String path, String name, String fileName, boolean override) {
        try {
            RepositoryObjectType type;
            RepositoryDirectoryInterface repositoryDirectoryInterface = this.getRepository().findDirectory(path);
            EngineMetaInterface meta = this.getSpoon().getActiveMeta();
            RepositoryObjectType repositoryObjectType = type = "Trans".equals(meta.getFileType()) ? RepositoryObjectType.TRANSFORMATION : RepositoryObjectType.JOB;
            if (this.getRepository().exists(name, repositoryDirectoryInterface, type)) {
                return !override || !name.equals(fileName);
            }
        }
        catch (Exception e) {
            System.out.println(e);
        }
        return false;
    }

    private boolean checkSecurity() {
        EngineMetaInterface meta = this.getSpoon().getActiveMeta();
        return this.getSpoon().saveToRepositoryCheckSecurity(meta);
    }

    public boolean openRecentFile(String repo, String id) {
        if (this.getSpoon().recentRepoFileExists(repo, id)) {
            this.getSpoon().getDisplay().asyncExec(() -> this.getSpoon().lastRepoFileSelect(repo, id));
            return true;
        }
        return false;
    }

    public List<org.pentaho.di.plugins.fileopensave.providers.repository.model.RepositoryObject> search(String path, String filter) {
        RepositoryDirectoryInterface repositoryDirectoryInterface = this.findDirectory(path);
        ArrayList<org.pentaho.di.plugins.fileopensave.providers.repository.model.RepositoryObject> repositoryObjects = new ArrayList<org.pentaho.di.plugins.fileopensave.providers.repository.model.RepositoryObject>();
        List repositoryObjects1 = ((RepositoryExtended)this.getRepository()).getChildren(repositoryDirectoryInterface.getObjectId().getId(), filter);
        for (RepositoryObjectInterface repositoryObject : repositoryObjects1) {
            if (repositoryObject instanceof RepositoryDirectoryInterface) {
                RepositoryDirectory repositoryDirectory = new RepositoryDirectory();
                repositoryDirectory.setPath(path + "/" + repositoryObject.getName());
                repositoryDirectory.setName(repositoryObject.getName());
                repositoryDirectory.setObjectId(repositoryObject.getObjectId().getId());
                repositoryObjects.add(repositoryDirectory);
                continue;
            }
            RepositoryFile repositoryFile = new RepositoryFile();
            repositoryFile.setPath(path + "/" + repositoryObject.getName());
            repositoryFile.setName(repositoryObject.getName());
            repositoryFile.setType(((RepositoryObject)repositoryObject).getObjectType() == RepositoryObjectType.TRANSFORMATION ? TRANSFORMATION : JOB);
            repositoryFile.setObjectId(repositoryObject.getObjectId().getId());
            repositoryObjects.add(repositoryFile);
        }
        return repositoryObjects;
    }

    public JSONArray getRecentSearches() {
        try {
            PropsUI props = PropsUI.getInstance();
            String jsonString = props.getRecentSearches();
            if (jsonString != null) {
                JSONParser jsonParser = new JSONParser();
                JSONObject jsonObject = (JSONObject)jsonParser.parse(jsonString);
                return (JSONArray)jsonObject.get((Object)this.getLogin());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new JSONArray();
    }

    public JSONArray storeRecentSearch(String recentSearch) {
        JSONArray recentSearches = this.getRecentSearches();
        try {
            if (recentSearch == null || recentSearches.contains((Object)recentSearch)) {
                return recentSearches;
            }
            recentSearches.add((Object)recentSearch);
            if (recentSearches.size() > 5) {
                recentSearches.remove(0);
            }
            PropsUI props = PropsUI.getInstance();
            String jsonValue = props.getRecentSearches();
            JSONParser jsonParser = new JSONParser();
            JSONObject jsonObject = jsonValue != null ? (JSONObject)jsonParser.parse(jsonValue) : new JSONObject();
            jsonObject.put((Object)this.getLogin(), (Object)recentSearches);
            props.setRecentSearches(jsonObject.toJSONString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return recentSearches;
    }

    private Spoon getSpoon() {
        return this.spoonSupplier.get();
    }

    private String getLogin() {
        String login = "file_repository_no_login";
        if (this.getSpoon().rep.getUserInfo() != null) {
            login = this.getSpoon().rep.getUserInfo().getLogin();
        }
        return login;
    }

    private RepositoryDirectoryInterface findDirectory(String path) {
        return this.rootDirectory.findDirectory(path);
    }

    public RepositoryName getCurrentRepo() {
        return new RepositoryName(this.getRepository().getName());
    }

    private Repository getRepository() {
        return repository != null ? repository : this.spoonSupplier.get().rep;
    }

    private Boolean isAdmin() {
        return this.getRepository().getUserInfo().isAdmin();
    }
}

