/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.plugins.fileopensave.providers.vfs;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.commons.io.IOUtils;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.FileType;
import org.apache.commons.vfs2.Selectors;
import org.pentaho.di.connections.ConnectionDetails;
import org.pentaho.di.connections.ConnectionManager;
import org.pentaho.di.connections.ConnectionProvider;
import org.pentaho.di.connections.vfs.VFSConnectionDetails;
import org.pentaho.di.connections.vfs.VFSConnectionProvider;
import org.pentaho.di.connections.vfs.VFSHelper;
import org.pentaho.di.connections.vfs.VFSRoot;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleFileException;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.variables.Variables;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.plugins.fileopensave.api.providers.BaseFileProvider;
import org.pentaho.di.plugins.fileopensave.api.providers.File;
import org.pentaho.di.plugins.fileopensave.api.providers.Utils;
import org.pentaho.di.plugins.fileopensave.api.providers.exception.FileException;
import org.pentaho.di.plugins.fileopensave.providers.vfs.model.VFSDirectory;
import org.pentaho.di.plugins.fileopensave.providers.vfs.model.VFSFile;
import org.pentaho.di.plugins.fileopensave.providers.vfs.model.VFSLocation;
import org.pentaho.di.plugins.fileopensave.providers.vfs.model.VFSTree;

public class VFSFileProvider
extends BaseFileProvider<VFSFile> {
    public static final String NAME = "VFS Connections";
    public static final String TYPE = "vfs";
    private Supplier<ConnectionManager> connectionManagerSupplier = ConnectionManager::getInstance;
    private Map<String, List<VFSFile>> roots = new HashMap<String, List<VFSFile>>();

    public Class<VFSFile> getFileClass() {
        return VFSFile.class;
    }

    public String getName() {
        return NAME;
    }

    public String getType() {
        return TYPE;
    }

    public boolean isAvailable() {
        return true;
    }

    public VFSTree getTree() {
        VFSTree vfsTree = new VFSTree(NAME);
        List providers = this.connectionManagerSupplier.get().getProvidersByType(VFSConnectionProvider.class);
        for (ConnectionProvider provider : providers) {
            for (ConnectionDetails connectionDetails : provider.getConnectionDetails()) {
                VFSLocation vfsLocation = new VFSLocation();
                vfsLocation.setName(connectionDetails.getName());
                vfsLocation.setRoot(NAME);
                vfsLocation.setHasChildren(true);
                vfsLocation.setCanDelete(true);
                vfsLocation.setConnection(connectionDetails.getName());
                vfsTree.addChild(vfsLocation);
            }
        }
        return vfsTree;
    }

    private List<VFSFile> getRoot(VFSFile file) {
        if (this.roots.containsKey(file.getConnection())) {
            return this.roots.get(file.getConnection());
        }
        ArrayList<VFSFile> files = new ArrayList<VFSFile>();
        VFSConnectionDetails vfsConnectionDetails = (VFSConnectionDetails)ConnectionManager.getInstance().getConnectionDetails(file.getConnection());
        VFSConnectionProvider vfsConnectionProvider = (VFSConnectionProvider)ConnectionManager.getInstance().getConnectionProvider(vfsConnectionDetails.getType());
        List roots = vfsConnectionProvider.getLocations(vfsConnectionDetails);
        for (VFSRoot root : roots) {
            VFSDirectory vfsDirectory = new VFSDirectory();
            vfsDirectory.setName(root.getName());
            vfsDirectory.setDate(root.getModifiedDate());
            vfsDirectory.setHasChildren(true);
            vfsDirectory.setCanAddChildren(true);
            vfsDirectory.setConnection(vfsConnectionDetails.getName());
            vfsDirectory.setPath(vfsConnectionProvider.getProtocol(vfsConnectionDetails) + "://" + root.getName());
            vfsDirectory.setRoot(NAME);
            files.add(vfsDirectory);
        }
        this.roots.put(file.getConnection(), files);
        return files;
    }

    public List<VFSFile> getFiles(VFSFile file, String filters) {
        if (file.getPath() == null) {
            return this.getRoot(file);
        }
        ArrayList<VFSFile> files = new ArrayList<VFSFile>();
        try {
            FileObject fileObject = KettleVFS.getFileObject((String)file.getPath(), (VariableSpace)new Variables(), (FileSystemOptions)VFSHelper.getOpts((String)file.getPath(), (String)file.getConnection()));
            FileType fileType = fileObject.getType();
            if (fileType.hasChildren()) {
                FileObject[] children;
                for (FileObject child : children = fileObject.getChildren()) {
                    FileType fileType1 = child.getType();
                    if (fileType1.hasChildren()) {
                        files.add(VFSDirectory.create(file.getPath(), child, file.getConnection()));
                        continue;
                    }
                    if (!Utils.matches((String)child.getName().getBaseName(), (String)filters)) continue;
                    files.add(VFSFile.create(file.getPath(), child, file.getConnection()));
                }
            }
        }
        catch (FileSystemException | KettleFileException throwable) {
            // empty catch block
        }
        return files;
    }

    public List<VFSFile> delete(List<VFSFile> files) {
        ArrayList<VFSFile> deletedFiles = new ArrayList<VFSFile>();
        for (VFSFile file : files) {
            try {
                FileObject fileObject = KettleVFS.getFileObject((String)file.getPath(), (VariableSpace)new Variables(), (FileSystemOptions)VFSHelper.getOpts((String)file.getPath(), (String)file.getConnection()));
                if (!fileObject.delete()) continue;
                deletedFiles.add(file);
            }
            catch (FileSystemException | KettleFileException throwable) {}
        }
        return deletedFiles;
    }

    public VFSFile add(VFSFile folder) {
        try {
            FileObject fileObject = KettleVFS.getFileObject((String)folder.getPath(), (VariableSpace)new Variables(), (FileSystemOptions)VFSHelper.getOpts((String)folder.getPath(), (String)folder.getConnection()));
            fileObject.createFolder();
            String parent = folder.getPath().substring(0, folder.getPath().length() - 1);
            return VFSDirectory.create(parent, fileObject, folder.getConnection());
        }
        catch (FileSystemException | KettleFileException throwable) {
            return null;
        }
    }

    public VFSFile rename(VFSFile file, String newPath, boolean overwrite) {
        return this.doMove(file, newPath, overwrite);
    }

    public VFSFile move(VFSFile file, String toPath, boolean overwrite) {
        return this.doMove(file, toPath, overwrite);
    }

    private VFSFile doMove(VFSFile file, String newPath, Boolean overwrite) {
        try {
            FileObject fileObject = KettleVFS.getFileObject((String)file.getPath(), (VariableSpace)new Variables(), (FileSystemOptions)VFSHelper.getOpts((String)file.getPath(), (String)file.getConnection()));
            FileObject renameObject = KettleVFS.getFileObject((String)newPath, (VariableSpace)new Variables(), (FileSystemOptions)VFSHelper.getOpts((String)file.getPath(), (String)file.getConnection()));
            if (overwrite.booleanValue() && renameObject.exists()) {
                renameObject.delete();
            }
            fileObject.moveTo(renameObject);
            if (file instanceof VFSDirectory) {
                return VFSDirectory.create(renameObject.getParent().getPublicURIString(), renameObject, file.getConnection());
            }
            return VFSFile.create(renameObject.getParent().getPublicURIString(), renameObject, file.getConnection());
        }
        catch (FileSystemException | KettleFileException e) {
            return null;
        }
    }

    public VFSFile copy(VFSFile file, String toPath, boolean overwrite) throws FileException {
        try {
            FileObject fileObject = KettleVFS.getFileObject((String)file.getPath(), (VariableSpace)new Variables(), (FileSystemOptions)VFSHelper.getOpts((String)file.getPath(), (String)file.getConnection()));
            FileObject copyObject = KettleVFS.getFileObject((String)toPath, (VariableSpace)new Variables(), (FileSystemOptions)VFSHelper.getOpts((String)file.getPath(), (String)file.getConnection()));
            copyObject.copyFrom(fileObject, Selectors.SELECT_SELF);
            if (file instanceof VFSDirectory) {
                return VFSDirectory.create(copyObject.getParent().getPublicURIString(), fileObject, file.getConnection());
            }
            return VFSFile.create(copyObject.getParent().getPublicURIString(), fileObject, file.getConnection());
        }
        catch (FileSystemException | KettleFileException e) {
            throw new FileException();
        }
    }

    public boolean fileExists(VFSFile dir, String path) throws FileException {
        path = this.sanitizeName(dir, path);
        try {
            FileObject fileObject = KettleVFS.getFileObject((String)path, (VariableSpace)new Variables(), (FileSystemOptions)VFSHelper.getOpts((String)path, (String)dir.getConnection()));
            return fileObject.exists();
        }
        catch (FileSystemException | KettleFileException e) {
            throw new FileException();
        }
    }

    public InputStream readFile(VFSFile file) {
        try {
            FileObject fileObject = KettleVFS.getFileObject((String)file.getPath(), (VariableSpace)new Variables(), (FileSystemOptions)VFSHelper.getOpts((String)file.getPath(), (String)file.getConnection()));
            return fileObject.getContent().getInputStream();
        }
        catch (FileSystemException | KettleException e) {
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public VFSFile writeFile(InputStream inputStream, VFSFile destDir, String path, boolean overwrite) throws FileException {
        FileObject fileObject = null;
        try {
            fileObject = KettleVFS.getFileObject((String)path, (VariableSpace)new Variables(), (FileSystemOptions)VFSHelper.getOpts((String)destDir.getPath(), (String)destDir.getConnection()));
        }
        catch (KettleException ke) {
            throw new FileException();
        }
        if (fileObject == null) return null;
        try (OutputStream outputStream = fileObject.getContent().getOutputStream();){
            IOUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
            outputStream.flush();
            VFSFile vFSFile = VFSFile.create(destDir.getPath(), fileObject, destDir.getConnection());
            return vFSFile;
        }
        catch (IOException e) {
            return null;
        }
    }

    public boolean isSame(File file1, File file2) {
        if (file1 instanceof VFSFile && file2 instanceof VFSFile) {
            VFSFile vfsFile1 = (VFSFile)file1;
            VFSFile vfsFile2 = (VFSFile)file2;
            return vfsFile1.getConnection().equals(vfsFile2.getConnection());
        }
        return false;
    }

    public String getNewName(VFSFile destDir, String newPath) throws FileException {
        String extension = Utils.getExtension((String)newPath);
        String parent = Utils.getParent((String)newPath);
        String name = Utils.getName((String)newPath).replace("." + extension, "");
        int i = 1;
        String testName = this.sanitizeName(destDir, newPath);
        try {
            while (KettleVFS.getFileObject((String)testName, (VariableSpace)new Variables(), (FileSystemOptions)VFSHelper.getOpts((String)testName, (String)destDir.getConnection())).exists()) {
                testName = Utils.isValidExtension((String)extension) ? this.sanitizeName(destDir, parent + name + " " + i + "." + extension) : this.sanitizeName(destDir, newPath + " " + i);
                ++i;
            }
        }
        catch (FileSystemException | KettleFileException e) {
            return testName;
        }
        return testName;
    }

    public VFSFile getParent(VFSFile file) {
        VFSFile vfsFile = new VFSFile();
        vfsFile.setConnection(file.getConnection());
        vfsFile.setPath(file.getParent());
        return vfsFile;
    }

    public String sanitizeName(VFSFile destDir, String newPath) {
        return this.getConnectionProvider(newPath).sanitizeName(newPath);
    }

    private VFSConnectionProvider<VFSConnectionDetails> getConnectionProvider(String key) {
        VFSConnectionProvider vfsConnectionProvider = (VFSConnectionProvider)ConnectionManager.getInstance().getConnectionProvider(key);
        return vfsConnectionProvider;
    }
}

