/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.singlethreader;

import java.util.ArrayList;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.logging.KettleLogStore;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.SingleThreadedTransExecutor;
import org.pentaho.di.trans.StepWithMappingMeta;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.RowAdapter;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.TransStepUtil;
import org.pentaho.di.trans.steps.mapping.MappingValueRename;
import org.pentaho.di.trans.steps.mappinginput.MappingInputData;
import org.pentaho.di.trans.steps.singlethreader.SingleThreaderData;
import org.pentaho.di.trans.steps.singlethreader.SingleThreaderMeta;

public class SingleThreader
extends BaseStep
implements StepInterface {
    private static Class<?> PKG = SingleThreaderMeta.class;
    private SingleThreaderMeta meta;
    private SingleThreaderData data;

    public SingleThreader(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    @Override
    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        boolean timeWindow;
        this.meta = (SingleThreaderMeta)smi;
        this.setData((SingleThreaderData)sdi);
        SingleThreaderData singleThreaderData = this.getData();
        Object[] row = this.getRow();
        if (row == null) {
            if (singleThreaderData.batchCount > 0) {
                singleThreaderData.batchCount = 0;
                return this.execOneIteration();
            }
            this.setOutputDone();
            return false;
        }
        if (this.first) {
            this.first = false;
            singleThreaderData.startTime = System.currentTimeMillis();
        }
        singleThreaderData.rowProducer.putRow(this.getInputRowMeta(), row);
        ++singleThreaderData.batchCount;
        if (this.getStepMeta().isDoingErrorHandling()) {
            singleThreaderData.errorBuffer.add(row);
        }
        boolean countWindow = singleThreaderData.batchSize > 0 && singleThreaderData.batchCount >= singleThreaderData.batchSize;
        boolean bl = timeWindow = singleThreaderData.batchTime > 0 && System.currentTimeMillis() - singleThreaderData.startTime > (long)singleThreaderData.batchTime;
        if (countWindow || timeWindow) {
            singleThreaderData.batchCount = 0;
            boolean more = this.execOneIteration();
            if (!more) {
                this.setOutputDone();
                return false;
            }
            singleThreaderData.startTime = System.currentTimeMillis();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean execOneIteration() {
        boolean more = false;
        try {
            more = this.getData().executor.oneIteration();
            if (this.getData().executor.isStopped() || this.getData().executor.getErrors() > 0L) {
                boolean bl = this.handleError();
                return bl;
            }
        }
        catch (Exception e) {
            this.setErrors(1L);
            this.stopAll();
            this.logError(BaseMessages.getString(PKG, (String)"SingleThreader.Log.ErrorOccurredInSubTransformation", (String[])new String[0]));
            boolean bl = false;
            return bl;
        }
        finally {
            if (this.getStepMeta().isDoingErrorHandling()) {
                this.getData().errorBuffer.clear();
            }
        }
        return more;
    }

    private boolean handleError() throws KettleStepException {
        SingleThreaderData singleThreaderData = this.getData();
        if (this.getStepMeta().isDoingErrorHandling()) {
            int lastLogLine = KettleLogStore.getLastBufferLineNr();
            StringBuffer logText = KettleLogStore.getAppender().getBuffer(singleThreaderData.mappingTrans.getLogChannelId(), false, singleThreaderData.lastLogLine);
            singleThreaderData.lastLogLine = lastLogLine;
            for (Object[] row : singleThreaderData.errorBuffer) {
                this.putError(this.getInputRowMeta(), row, 1L, logText.toString(), null, "STR-001");
            }
            singleThreaderData.executor.clearError();
            return true;
        }
        this.setErrors(1L);
        this.stopAll();
        this.logError(BaseMessages.getString(PKG, (String)"SingleThreader.Log.ErrorOccurredInSubTransformation", (String[])new String[0]));
        return false;
    }

    public void prepareMappingExecution() throws KettleException {
        SingleThreaderData singleThreaderData = this.getData();
        singleThreaderData.mappingTransMeta.setTransformationType(TransMeta.TransformationType.SingleThreaded);
        singleThreaderData.mappingTrans = new Trans(singleThreaderData.mappingTransMeta, this.getTrans());
        StepWithMappingMeta.activateParams(this.getData().mappingTrans, this.getData().mappingTrans, this, this.getData().mappingTrans.listParameters(), this.meta.getParameters(), this.meta.getParameterValues(), this.meta.isPassingAllParameters());
        this.getData().mappingTrans.activateParameters();
        singleThreaderData.mappingTrans.getTransMeta().setUsingThreadPriorityManagment(false);
        singleThreaderData.mappingTrans.setParentTrans(this.getTrans());
        singleThreaderData.mappingTrans.setSafeModeEnabled(this.getTrans().isSafeModeEnabled());
        singleThreaderData.mappingTrans.setGatheringMetrics(this.getTrans().isGatheringMetrics());
        singleThreaderData.mappingTrans.setMappingStepName(this.getStepname());
        this.initServletConfig();
        singleThreaderData.mappingTrans.prepareExecution(null);
        if (singleThreaderData.injectStepMeta.isMappingInput()) {
            MappingInputData mappingInputData = (MappingInputData)singleThreaderData.mappingTrans.findDataInterface(singleThreaderData.injectStepMeta.getName());
            mappingInputData.sourceSteps = new StepInterface[0];
            mappingInputData.valueRenames = new ArrayList<MappingValueRename>();
        }
        singleThreaderData.rowProducer = singleThreaderData.mappingTrans.addRowProducer(this.meta.getInjectStep(), 0);
        StepInterface retrieveStep = singleThreaderData.mappingTrans.getStepInterface(this.meta.getRetrieveStep(), 0);
        retrieveStep.addRowListener(new RowAdapter(){

            @Override
            public void rowWrittenEvent(RowMetaInterface rowMeta, Object[] row) throws KettleStepException {
                SingleThreader.this.putRow(rowMeta, row);
            }
        });
        singleThreaderData.mappingTrans.startThreads();
        singleThreaderData.executor = new SingleThreadedTransExecutor(singleThreaderData.mappingTrans);
        try {
            boolean ok = singleThreaderData.executor.init();
            if (!ok) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"SingleThreader.Exception.UnableToInitSingleThreadedTransformation", (String[])new String[0]));
            }
        }
        catch (KettleException e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"SingleThreader.Exception.UnableToPrepareExecutionOfMapping", (String[])new String[0]), (Throwable)e);
        }
        this.getTrans().addActiveSubTransformation(this.getStepname(), singleThreaderData.mappingTrans);
    }

    void initServletConfig() {
        TransStepUtil.initServletConfig(this.getTrans(), this.getData().getMappingTrans());
    }

    @Override
    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (SingleThreaderMeta)smi;
        this.setData((SingleThreaderData)sdi);
        SingleThreaderData singleThreaderData = this.getData();
        if (super.init(smi, sdi)) {
            try {
                singleThreaderData.batchSize = Const.toInt((String)this.environmentSubstitute(this.meta.getBatchSize()), (int)0);
                singleThreaderData.batchTime = Const.toInt((String)this.environmentSubstitute(this.meta.getBatchTime()), (int)0);
                this.meta.setRepository(this.getTransMeta().getRepository());
                singleThreaderData.mappingTransMeta = SingleThreaderMeta.loadSingleThreadedTransMeta(this.meta, this.meta.getRepository(), this, this.meta.isPassingAllParameters());
                if (singleThreaderData.mappingTransMeta != null) {
                    String retrieveStepName;
                    String injectStepName = this.environmentSubstitute(this.meta.getInjectStep());
                    singleThreaderData.injectStepMeta = singleThreaderData.mappingTransMeta.findStep(injectStepName);
                    if (singleThreaderData.injectStepMeta == null) {
                        this.logError("The inject step with name '" + injectStepName + "' couldn't be found in the sub-transformation");
                    }
                    if (!Utils.isEmpty((CharSequence)(retrieveStepName = this.environmentSubstitute(this.meta.getRetrieveStep())))) {
                        singleThreaderData.retrieveStepMeta = singleThreaderData.mappingTransMeta.findStep(retrieveStepName);
                        if (singleThreaderData.retrieveStepMeta == null) {
                            this.logError("The retrieve step with name '" + retrieveStepName + "' couldn't be found in the sub-transformation");
                        }
                    }
                    this.prepareMappingExecution();
                    if (this.getStepMeta().isDoingErrorHandling()) {
                        singleThreaderData.errorBuffer = new ArrayList<Object[]>();
                    }
                    return true;
                }
                this.logError("No valid mapping was specified!");
                return false;
            }
            catch (Exception e) {
                this.logError("Unable to load the mapping transformation because of an error : " + e.toString());
                this.logError(Const.getStackTracker((Throwable)e));
            }
        }
        return false;
    }

    @Override
    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        try {
            if (this.getData().executor != null) {
                this.getData().executor.dispose();
            }
        }
        catch (KettleException e) {
            this.log.logError("Error disposing of sub-transformation: ", (Throwable)e);
        }
        super.dispose(smi, sdi);
    }

    @Override
    public void stopRunning(StepMetaInterface stepMetaInterface, StepDataInterface stepDataInterface) throws KettleException {
        if (this.getData().mappingTrans != null) {
            this.getData().mappingTrans.stopAll();
        }
    }

    @Override
    public void stopAll() {
        if (this.getData().mappingTrans != null) {
            this.getData().mappingTrans.stopAll();
        }
        super.stopAll();
    }

    public Trans getMappingTrans() {
        return this.getData().mappingTrans;
    }

    SingleThreaderData getData() {
        return this.data;
    }

    private void setData(SingleThreaderData data) {
        this.data = data;
    }
}

