/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.update;

import com.google.common.primitives.Ints;
import java.util.List;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.SQLStatement;
import org.pentaho.di.core.database.Database;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.injection.AfterInjection;
import org.pentaho.di.core.injection.Injection;
import org.pentaho.di.core.injection.InjectionSupported;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaBoolean;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.shared.SharedObjectInterface;
import org.pentaho.di.trans.DatabaseImpact;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.step.utils.RowMetaUtils;
import org.pentaho.di.trans.steps.update.Update;
import org.pentaho.di.trans.steps.update.UpdateData;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

@InjectionSupported(localizationPrefix="UpdateMeta.Injection.", groups={"KEYS", "UPDATES"})
public class UpdateMeta
extends BaseStepMeta
implements StepMetaInterface {
    private static Class<?> PKG = UpdateMeta.class;
    private List<? extends SharedObjectInterface> databases;
    @Injection(name="SCHEMA_NAME")
    private String schemaName;
    @Injection(name="TABLE_NAME")
    private String tableName;
    private DatabaseMeta databaseMeta;
    @Injection(name="KEY_STREAM", group="KEYS")
    private String[] keyStream;
    @Injection(name="KEY_LOOKUP", group="KEYS")
    private String[] keyLookup;
    @Injection(name="KEY_CONDITION", group="KEYS")
    private String[] keyCondition;
    @Injection(name="KEY_STREAM2", group="KEYS")
    private String[] keyStream2;
    @Injection(name="UPDATE_LOOKUP", group="UPDATES")
    private String[] updateLookup;
    @Injection(name="UPDATE_STREAM", group="UPDATES")
    private String[] updateStream;
    @Injection(name="COMMIT_SIZE")
    private String commitSize;
    @Injection(name="IGNORE_LOOKUP_FAILURE")
    private boolean errorIgnored;
    @Injection(name="FLAG_FIELD")
    private String ignoreFlagField;
    @Injection(name="SKIP_LOOKUP")
    private boolean skipLookup;
    @Injection(name="BATCH_UPDATE")
    private boolean useBatchUpdate;

    @Injection(name="CONNECTIONNAME")
    public void setConnection(String connectionName) {
        this.databaseMeta = DatabaseMeta.findDatabase(this.databases, (String)connectionName);
    }

    @Deprecated
    public int getCommitSize() {
        return Integer.parseInt(this.commitSize);
    }

    public String getCommitSizeVar() {
        return this.commitSize;
    }

    public int getCommitSize(VariableSpace vs) {
        this.commitSize = this.commitSize == null ? "0" : this.commitSize;
        return Integer.parseInt(vs.environmentSubstitute(this.commitSize));
    }

    @Deprecated
    public void setCommitSize(int commitSize) {
        this.commitSize = Integer.toString(commitSize);
    }

    public void setCommitSize(String commitSize) {
        this.commitSize = commitSize;
    }

    public boolean isSkipLookup() {
        return this.skipLookup;
    }

    public void setSkipLookup(boolean skipLookup) {
        this.skipLookup = skipLookup;
    }

    public DatabaseMeta getDatabaseMeta() {
        return this.databaseMeta;
    }

    public void setDatabaseMeta(DatabaseMeta database) {
        this.databaseMeta = database;
    }

    public String[] getKeyCondition() {
        return this.keyCondition;
    }

    public void setKeyCondition(String[] keyCondition) {
        this.keyCondition = keyCondition;
    }

    public String[] getKeyLookup() {
        return this.keyLookup;
    }

    public void setKeyLookup(String[] keyLookup) {
        this.keyLookup = keyLookup;
    }

    public String[] getKeyStream() {
        return this.keyStream;
    }

    public void setKeyStream(String[] keyStream) {
        this.keyStream = keyStream;
    }

    public String[] getKeyStream2() {
        return this.keyStream2;
    }

    public void setKeyStream2(String[] keyStream2) {
        this.keyStream2 = keyStream2;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String[] getUpdateLookup() {
        return this.updateLookup;
    }

    public void setUpdateLookup(String[] updateLookup) {
        this.updateLookup = updateLookup;
    }

    public String[] getUpdateStream() {
        return this.updateStream;
    }

    public void setUpdateStream(String[] updateStream) {
        this.updateStream = updateStream;
    }

    public boolean isErrorIgnored() {
        return this.errorIgnored;
    }

    public void setErrorIgnored(boolean ignoreError) {
        this.errorIgnored = ignoreError;
    }

    public String getIgnoreFlagField() {
        return this.ignoreFlagField;
    }

    public void setIgnoreFlagField(String ignoreFlagField) {
        this.ignoreFlagField = ignoreFlagField;
    }

    @Override
    public void loadXML(Node stepnode, List<DatabaseMeta> databases, IMetaStore metaStore) throws KettleXMLException {
        this.databases = databases;
        this.readData(stepnode, databases);
    }

    public void allocate(int nrkeys, int nrvalues) {
        this.keyStream = new String[nrkeys];
        this.keyLookup = new String[nrkeys];
        this.keyCondition = new String[nrkeys];
        this.keyStream2 = new String[nrkeys];
        this.updateLookup = new String[nrvalues];
        this.updateStream = new String[nrvalues];
    }

    @Override
    public Object clone() {
        UpdateMeta retval = (UpdateMeta)super.clone();
        int nrkeys = this.keyStream.length;
        int nrvalues = this.updateLookup.length;
        retval.allocate(nrkeys, nrvalues);
        System.arraycopy(this.keyStream, 0, retval.keyStream, 0, nrkeys);
        System.arraycopy(this.keyLookup, 0, retval.keyLookup, 0, nrkeys);
        System.arraycopy(this.keyCondition, 0, retval.keyCondition, 0, nrkeys);
        System.arraycopy(this.keyStream2, 0, retval.keyStream2, 0, nrkeys);
        System.arraycopy(this.updateLookup, 0, retval.updateLookup, 0, nrvalues);
        System.arraycopy(this.updateStream, 0, retval.updateStream, 0, nrvalues);
        return retval;
    }

    private void readData(Node stepnode, List<? extends SharedObjectInterface> databases) throws KettleXMLException {
        try {
            int i;
            String con = XMLHandler.getTagValue((Node)stepnode, (String)"connection");
            this.databaseMeta = DatabaseMeta.findDatabase(databases, (String)con);
            String csize = XMLHandler.getTagValue((Node)stepnode, (String)"commit");
            this.commitSize = csize == null ? "0" : csize;
            this.useBatchUpdate = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"use_batch"));
            this.skipLookup = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"skip_lookup"));
            this.errorIgnored = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"error_ignored"));
            this.ignoreFlagField = XMLHandler.getTagValue((Node)stepnode, (String)"ignore_flag_field");
            this.schemaName = XMLHandler.getTagValue((Node)stepnode, (String)"lookup", (String)"schema");
            this.tableName = XMLHandler.getTagValue((Node)stepnode, (String)"lookup", (String)"table");
            Node lookup = XMLHandler.getSubNode((Node)stepnode, (String)"lookup");
            int nrkeys = XMLHandler.countNodes((Node)lookup, (String)"key");
            int nrvalues = XMLHandler.countNodes((Node)lookup, (String)"value");
            this.allocate(nrkeys, nrvalues);
            for (i = 0; i < nrkeys; ++i) {
                Node knode = XMLHandler.getSubNodeByNr((Node)lookup, (String)"key", (int)i);
                this.keyStream[i] = XMLHandler.getTagValue((Node)knode, (String)"name");
                this.keyLookup[i] = XMLHandler.getTagValue((Node)knode, (String)"field");
                this.keyCondition[i] = XMLHandler.getTagValue((Node)knode, (String)"condition");
                if (this.keyCondition[i] == null) {
                    this.keyCondition[i] = "=";
                }
                this.keyStream2[i] = XMLHandler.getTagValue((Node)knode, (String)"name2");
            }
            for (i = 0; i < nrvalues; ++i) {
                Node vnode = XMLHandler.getSubNodeByNr((Node)lookup, (String)"value", (int)i);
                this.updateLookup[i] = XMLHandler.getTagValue((Node)vnode, (String)"name");
                this.updateStream[i] = XMLHandler.getTagValue((Node)vnode, (String)"rename");
                if (this.updateStream[i] != null) continue;
                this.updateStream[i] = this.updateLookup[i];
            }
        }
        catch (Exception e) {
            throw new KettleXMLException(BaseMessages.getString(PKG, (String)"UpdateMeta.Exception.UnableToReadStepInfoFromXML", (String[])new String[0]), (Throwable)e);
        }
    }

    @Override
    public void setDefault() {
        int i;
        this.skipLookup = false;
        this.keyStream = null;
        this.updateLookup = null;
        this.databaseMeta = null;
        this.commitSize = "100";
        this.schemaName = "";
        this.tableName = BaseMessages.getString(PKG, (String)"UpdateMeta.DefaultTableName", (String[])new String[0]);
        int nrkeys = 0;
        int nrvalues = 0;
        this.allocate(nrkeys, nrvalues);
        for (i = 0; i < nrkeys; ++i) {
            this.keyLookup[i] = "age";
            this.keyCondition[i] = "BETWEEN";
            this.keyStream[i] = "age_from";
            this.keyStream2[i] = "age_to";
        }
        for (i = 0; i < nrvalues; ++i) {
            this.updateLookup[i] = BaseMessages.getString(PKG, (String)"UpdateMeta.ColumnName.ReturnField", (String[])new String[0]) + i;
            this.updateStream[i] = BaseMessages.getString(PKG, (String)"UpdateMeta.ColumnName.NewName", (String[])new String[0]) + i;
        }
    }

    @Override
    public String getXML() {
        int i;
        StringBuilder retval = new StringBuilder();
        retval.append("    " + XMLHandler.addTagValue((String)"connection", (String)(this.databaseMeta == null ? "" : this.databaseMeta.getName())));
        retval.append("    " + XMLHandler.addTagValue((String)"skip_lookup", (boolean)this.skipLookup));
        retval.append("    " + XMLHandler.addTagValue((String)"commit", (String)this.commitSize));
        retval.append("    " + XMLHandler.addTagValue((String)"use_batch", (boolean)this.useBatchUpdate));
        retval.append("    " + XMLHandler.addTagValue((String)"error_ignored", (boolean)this.errorIgnored));
        retval.append("    " + XMLHandler.addTagValue((String)"ignore_flag_field", (String)this.ignoreFlagField));
        retval.append("    <lookup>" + Const.CR);
        retval.append("      " + XMLHandler.addTagValue((String)"schema", (String)this.schemaName));
        retval.append("      " + XMLHandler.addTagValue((String)"table", (String)this.tableName));
        for (i = 0; i < this.keyStream.length; ++i) {
            retval.append("      <key>" + Const.CR);
            retval.append("        " + XMLHandler.addTagValue((String)"name", (String)this.keyStream[i]));
            retval.append("        " + XMLHandler.addTagValue((String)"field", (String)this.keyLookup[i]));
            retval.append("        " + XMLHandler.addTagValue((String)"condition", (String)this.keyCondition[i]));
            retval.append("        " + XMLHandler.addTagValue((String)"name2", (String)this.keyStream2[i]));
            retval.append("        </key>" + Const.CR);
        }
        for (i = 0; i < this.updateLookup.length; ++i) {
            retval.append("      <value>" + Const.CR);
            retval.append("        " + XMLHandler.addTagValue((String)"name", (String)this.updateLookup[i]));
            retval.append("        " + XMLHandler.addTagValue((String)"rename", (String)this.updateStream[i]));
            retval.append("        </value>" + Const.CR);
        }
        retval.append("      </lookup>" + Const.CR);
        return retval.toString();
    }

    @Override
    public void readRep(Repository rep, IMetaStore metaStore, ObjectId id_step, List<DatabaseMeta> databases) throws KettleException {
        this.databases = databases;
        try {
            int i;
            this.databaseMeta = rep.loadDatabaseMetaFromStepAttribute(id_step, "id_connection", databases);
            this.skipLookup = rep.getStepAttributeBoolean(id_step, "skip_lookup");
            this.commitSize = rep.getStepAttributeString(id_step, "commit");
            if (this.commitSize == null) {
                long comSz = -1L;
                try {
                    comSz = rep.getStepAttributeInteger(id_step, "commit");
                }
                catch (Exception ex) {
                    this.commitSize = "100";
                }
                if (comSz >= 0L) {
                    this.commitSize = Long.toString(comSz);
                }
            }
            this.useBatchUpdate = rep.getStepAttributeBoolean(id_step, "use_batch");
            this.schemaName = rep.getStepAttributeString(id_step, "schema");
            this.tableName = rep.getStepAttributeString(id_step, "table");
            this.errorIgnored = rep.getStepAttributeBoolean(id_step, "error_ignored");
            this.ignoreFlagField = rep.getStepAttributeString(id_step, "ignore_flag_field");
            int nrKeyName = rep.countNrStepAttributes(id_step, "key_name");
            int nrKeyField = rep.countNrStepAttributes(id_step, "key_field");
            int nrKeyCondition = rep.countNrStepAttributes(id_step, "key_condition");
            int nrKeyName2 = rep.countNrStepAttributes(id_step, "key_name2");
            int nrkeys = Ints.max((int[])new int[]{nrKeyName, nrKeyCondition, nrKeyField, nrKeyName2});
            int nrValueName = rep.countNrStepAttributes(id_step, "value_name");
            int nrValueRename = rep.countNrStepAttributes(id_step, "value_rename");
            int nrvalues = Ints.max((int[])new int[]{nrValueName, nrValueRename});
            this.allocate(nrkeys, nrvalues);
            for (i = 0; i < nrkeys; ++i) {
                this.keyStream[i] = rep.getStepAttributeString(id_step, i, "key_name");
                this.keyLookup[i] = rep.getStepAttributeString(id_step, i, "key_field");
                this.keyCondition[i] = rep.getStepAttributeString(id_step, i, "key_condition");
                this.keyStream2[i] = rep.getStepAttributeString(id_step, i, "key_name2");
            }
            for (i = 0; i < nrvalues; ++i) {
                this.updateLookup[i] = rep.getStepAttributeString(id_step, i, "value_name");
                this.updateStream[i] = rep.getStepAttributeString(id_step, i, "value_rename");
            }
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"UpdateMeta.Exception.UnexpectedErrorReadingStepInfoFromRepository", (String[])new String[0]), (Throwable)e);
        }
    }

    @Override
    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId id_transformation, ObjectId id_step) throws KettleException {
        try {
            int i;
            rep.saveDatabaseMetaStepAttribute(id_transformation, id_step, "id_connection", this.databaseMeta);
            rep.saveStepAttribute(id_transformation, id_step, "skip_lookup", this.skipLookup);
            rep.saveStepAttribute(id_transformation, id_step, "commit", this.commitSize);
            rep.saveStepAttribute(id_transformation, id_step, "use_batch", this.useBatchUpdate);
            rep.saveStepAttribute(id_transformation, id_step, "schema", this.schemaName);
            rep.saveStepAttribute(id_transformation, id_step, "table", this.tableName);
            rep.saveStepAttribute(id_transformation, id_step, "error_ignored", this.errorIgnored);
            rep.saveStepAttribute(id_transformation, id_step, "ignore_flag_field", this.ignoreFlagField);
            for (i = 0; i < this.keyStream.length; ++i) {
                rep.saveStepAttribute(id_transformation, id_step, i, "key_name", this.keyStream[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "key_field", this.keyLookup[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "key_condition", this.keyCondition[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "key_name2", this.keyStream2[i]);
            }
            for (i = 0; i < this.updateLookup.length; ++i) {
                rep.saveStepAttribute(id_transformation, id_step, i, "value_name", this.updateLookup[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "value_rename", this.updateStream[i]);
            }
            if (this.databaseMeta != null) {
                rep.insertStepDatabase(id_transformation, id_step, this.databaseMeta.getObjectId());
            }
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"UpdateMeta.Exception.UnableToSaveStepInfoToRepository", (String[])new String[0]) + id_step, (Throwable)e);
        }
    }

    @Override
    public void getFields(RowMetaInterface row, String name, RowMetaInterface[] info, StepMeta nextStep, VariableSpace space, Repository repository, IMetaStore metaStore) throws KettleStepException {
        if (this.ignoreFlagField != null && this.ignoreFlagField.length() > 0) {
            ValueMetaBoolean v = new ValueMetaBoolean(this.ignoreFlagField);
            v.setOrigin(name);
            row.addValueMeta((ValueMetaInterface)v);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info, VariableSpace space, Repository repository, IMetaStore metaStore) {
        CheckResult cr;
        String error_message = "";
        if (this.databaseMeta != null) {
            Database db = new Database(loggingObject, this.databaseMeta);
            db.shareVariablesWith((VariableSpace)transMeta);
            try {
                boolean error_found;
                boolean first;
                db.connect();
                if (!Utils.isEmpty((CharSequence)this.tableName)) {
                    cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"UpdateMeta.CheckResult.TableNameOK", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
                    remarks.add((CheckResultInterface)cr);
                    first = true;
                    error_found = false;
                    error_message = "";
                    RowMetaInterface r = db.getTableFieldsMeta(this.schemaName, this.tableName);
                    if (r != null) {
                        ValueMetaInterface v;
                        String lufield;
                        int i;
                        cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"UpdateMeta.CheckResult.TableExists", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
                        remarks.add((CheckResultInterface)cr);
                        for (i = 0; i < this.keyLookup.length; ++i) {
                            lufield = this.keyLookup[i];
                            v = r.searchValueMeta(lufield);
                            if (v != null) continue;
                            if (first) {
                                first = false;
                                error_message = error_message + BaseMessages.getString(PKG, (String)"UpdateMeta.CheckResult.MissingCompareFieldsInTargetTable", (String[])new String[0]) + Const.CR;
                            }
                            error_found = true;
                            error_message = error_message + "\t\t" + lufield + Const.CR;
                        }
                        cr = error_found ? new CheckResult(4, error_message, (CheckResultSourceInterface)stepMeta) : new CheckResult(1, BaseMessages.getString(PKG, (String)"UpdateMeta.CheckResult.AllLookupFieldsFound", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
                        remarks.add((CheckResultInterface)cr);
                        first = true;
                        error_found = false;
                        error_message = "";
                        for (i = 0; i < this.updateLookup.length; ++i) {
                            lufield = this.updateLookup[i];
                            v = r.searchValueMeta(lufield);
                            if (v != null) continue;
                            if (first) {
                                first = false;
                                error_message = error_message + BaseMessages.getString(PKG, (String)"UpdateMeta.CheckResult.MissingFieldsToUpdateInTargetTable", (String[])new String[0]) + Const.CR;
                            }
                            error_found = true;
                            error_message = error_message + "\t\t" + lufield + Const.CR;
                        }
                        cr = error_found ? new CheckResult(4, error_message, (CheckResultSourceInterface)stepMeta) : new CheckResult(1, BaseMessages.getString(PKG, (String)"UpdateMeta.CheckResult.AllFieldsToUpdateFoundInTargetTable", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
                        remarks.add((CheckResultInterface)cr);
                    } else {
                        error_message = BaseMessages.getString(PKG, (String)"UpdateMeta.CheckResult.CouldNotReadTableInfo", (String[])new String[0]);
                        cr = new CheckResult(4, error_message, (CheckResultSourceInterface)stepMeta);
                        remarks.add((CheckResultInterface)cr);
                    }
                }
                if (prev != null && prev.size() > 0) {
                    int i;
                    cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"UpdateMeta.CheckResult.StepReceivingDatas", (String[])new String[]{prev.size() + ""}), (CheckResultSourceInterface)stepMeta);
                    remarks.add((CheckResultInterface)cr);
                    first = true;
                    error_message = "";
                    error_found = false;
                    for (i = 0; i < this.keyStream.length; ++i) {
                        ValueMetaInterface v = prev.searchValueMeta(this.keyStream[i]);
                        if (v != null) continue;
                        if (first) {
                            first = false;
                            error_message = error_message + BaseMessages.getString(PKG, (String)"UpdateMeta.CheckResult.MissingFieldsInInput", (String[])new String[0]) + Const.CR;
                        }
                        error_found = true;
                        error_message = error_message + "\t\t" + this.keyStream[i] + Const.CR;
                    }
                    for (i = 0; i < this.keyStream2.length; ++i) {
                        ValueMetaInterface v;
                        if (this.keyStream2[i] == null || this.keyStream2[i].length() <= 0 || (v = prev.searchValueMeta(this.keyStream2[i])) != null) continue;
                        if (first) {
                            first = false;
                            error_message = error_message + BaseMessages.getString(PKG, (String)"UpdateMeta.CheckResult.MissingFieldsInInput2", (String[])new String[0]) + Const.CR;
                        }
                        error_found = true;
                        error_message = error_message + "\t\t" + this.keyStream[i] + Const.CR;
                    }
                    cr = error_found ? new CheckResult(4, error_message, (CheckResultSourceInterface)stepMeta) : new CheckResult(1, BaseMessages.getString(PKG, (String)"UpdateMeta.CheckResult.AllFieldsFoundInInput", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
                    remarks.add((CheckResultInterface)cr);
                    first = true;
                    error_found = false;
                    error_message = "";
                    for (i = 0; i < this.updateStream.length; ++i) {
                        String lufield = this.updateStream[i];
                        ValueMetaInterface v = prev.searchValueMeta(lufield);
                        if (v != null) continue;
                        if (first) {
                            first = false;
                            error_message = error_message + BaseMessages.getString(PKG, (String)"UpdateMeta.CheckResult.MissingInputStreamFields", (String[])new String[0]) + Const.CR;
                        }
                        error_found = true;
                        error_message = error_message + "\t\t" + lufield + Const.CR;
                    }
                    cr = error_found ? new CheckResult(4, error_message, (CheckResultSourceInterface)stepMeta) : new CheckResult(1, BaseMessages.getString(PKG, (String)"UpdateMeta.CheckResult.AllFieldsFoundInInput2", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
                    remarks.add((CheckResultInterface)cr);
                }
                error_message = BaseMessages.getString(PKG, (String)"UpdateMeta.CheckResult.MissingFieldsInInput3", (String[])new String[0]) + Const.CR;
                cr = new CheckResult(4, error_message, (CheckResultSourceInterface)stepMeta);
                remarks.add((CheckResultInterface)cr);
            }
            catch (KettleException e) {
                error_message = BaseMessages.getString(PKG, (String)"UpdateMeta.CheckResult.DatabaseErrorOccurred", (String[])new String[0]) + e.getMessage();
                cr = new CheckResult(4, error_message, (CheckResultSourceInterface)stepMeta);
                remarks.add((CheckResultInterface)cr);
            }
            finally {
                db.disconnect();
            }
        } else {
            error_message = BaseMessages.getString(PKG, (String)"UpdateMeta.CheckResult.InvalidConnection", (String[])new String[0]);
            cr = new CheckResult(4, error_message, (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
        if (input.length > 0) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"UpdateMeta.CheckResult.StepReceivingInfoFromOtherSteps", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"UpdateMeta.CheckResult.NoInputError", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
    }

    @Override
    public SQLStatement getSQLStatements(TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, Repository repository, IMetaStore metaStore) throws KettleStepException {
        SQLStatement retval;
        block14: {
            retval = new SQLStatement(stepMeta.getName(), this.databaseMeta, null);
            if (this.databaseMeta != null) {
                if (prev != null && prev.size() > 0) {
                    RowMetaInterface tableFields = RowMetaUtils.getRowMetaForUpdate(prev, this.keyLookup, this.keyStream, this.updateLookup, this.updateStream);
                    if (!Utils.isEmpty((CharSequence)this.tableName)) {
                        String schemaTable = this.databaseMeta.getQuotedSchemaTableCombination(this.schemaName, this.tableName);
                        Database db = new Database(loggingObject, this.databaseMeta);
                        db.shareVariablesWith((VariableSpace)transMeta);
                        try {
                            String sql;
                            db.connect();
                            if (this.getIgnoreFlagField() != null && this.getIgnoreFlagField().length() > 0) {
                                prev.addValueMeta((ValueMetaInterface)new ValueMetaBoolean(this.getIgnoreFlagField()));
                            }
                            String cr_table = db.getDDL(schemaTable, tableFields, null, false, null, true);
                            String cr_index = "";
                            String[] idx_fields = null;
                            if (this.keyLookup != null && this.keyLookup.length > 0) {
                                idx_fields = new String[this.keyLookup.length];
                                for (int i = 0; i < this.keyLookup.length; ++i) {
                                    idx_fields[i] = this.keyLookup[i];
                                }
                            } else {
                                retval.setError(BaseMessages.getString(PKG, (String)"UpdateMeta.CheckResult.MissingKeyFields", (String[])new String[0]));
                            }
                            if (idx_fields != null && idx_fields.length > 0 && !db.checkIndexExists(schemaTable, idx_fields)) {
                                String indexname = "idx_" + this.tableName + "_lookup";
                                cr_index = db.getCreateIndexStatement(schemaTable, indexname, idx_fields, false, false, false, true);
                            }
                            if ((sql = cr_table + cr_index).length() == 0) {
                                retval.setSQL(null);
                                break block14;
                            }
                            retval.setSQL(sql);
                        }
                        catch (KettleException e) {
                            retval.setError(BaseMessages.getString(PKG, (String)"UpdateMeta.ReturnValue.ErrorOccurred", (String[])new String[0]) + e.getMessage());
                        }
                    } else {
                        retval.setError(BaseMessages.getString(PKG, (String)"UpdateMeta.ReturnValue.NoTableDefinedOnConnection", (String[])new String[0]));
                    }
                } else {
                    retval.setError(BaseMessages.getString(PKG, (String)"UpdateMeta.ReturnValue.NotReceivingAnyFields", (String[])new String[0]));
                }
            } else {
                retval.setError(BaseMessages.getString(PKG, (String)"UpdateMeta.ReturnValue.NoConnectionDefined", (String[])new String[0]));
            }
        }
        return retval;
    }

    @Override
    public void analyseImpact(List<DatabaseImpact> impact, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info, Repository repository, IMetaStore metaStore) throws KettleStepException {
        if (prev != null) {
            DatabaseImpact ii;
            ValueMetaInterface v;
            int i;
            for (i = 0; i < this.keyLookup.length; ++i) {
                v = prev.searchValueMeta(this.keyStream[i]);
                ii = new DatabaseImpact(1, transMeta.getName(), stepMeta.getName(), this.databaseMeta.getDatabaseName(), this.tableName, this.keyLookup[i], this.keyStream[i], v != null ? v.getOrigin() : "?", "", "Type = " + v.toStringMeta());
                impact.add(ii);
            }
            for (i = 0; i < this.updateLookup.length; ++i) {
                v = prev.searchValueMeta(this.updateStream[i]);
                ii = new DatabaseImpact(6, transMeta.getName(), stepMeta.getName(), this.databaseMeta.getDatabaseName(), this.tableName, this.updateLookup[i], this.updateStream[i], v != null ? v.getOrigin() : "?", "", "Type = " + v.toStringMeta());
                impact.add(ii);
            }
        }
    }

    @Override
    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta tr, Trans trans) {
        return new Update(stepMeta, stepDataInterface, cnr, tr, trans);
    }

    @Override
    public StepDataInterface getStepData() {
        return new UpdateData();
    }

    @Override
    public DatabaseMeta[] getUsedDatabaseConnections() {
        if (this.databaseMeta != null) {
            return new DatabaseMeta[]{this.databaseMeta};
        }
        return super.getUsedDatabaseConnections();
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    @Override
    public boolean supportsErrorHandling() {
        return true;
    }

    public boolean useBatchUpdate() {
        return this.useBatchUpdate;
    }

    public void setUseBatchUpdate(boolean useBatchUpdate) {
        this.useBatchUpdate = useBatchUpdate;
    }

    @AfterInjection
    public void afterInjectionSynchronization() {
        int nrFields;
        int n = nrFields = this.keyStream == null ? -1 : this.keyStream.length;
        if (nrFields <= 0) {
            return;
        }
        String[][] rtn = Utils.normalizeArrays((int)nrFields, (String[][])new String[][]{this.keyLookup, this.keyCondition, this.keyStream2});
        this.keyLookup = rtn[0];
        this.keyCondition = rtn[1];
        this.keyStream2 = rtn[2];
        nrFields = this.updateLookup.length;
        rtn = Utils.normalizeArrays((int)nrFields, (String[][])new String[][]{this.updateStream});
        this.updateStream = rtn[0];
    }
}

