/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.www;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import javax.imageio.ImageIO;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.pentaho.di.core.gui.AreaOwner;
import org.pentaho.di.core.gui.Point;
import org.pentaho.di.core.gui.SwingGC;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.job.Job;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.job.JobPainter;
import org.pentaho.di.job.entry.JobEntryCopy;
import org.pentaho.di.www.BaseHttpServlet;
import org.pentaho.di.www.CarteObjectEntry;
import org.pentaho.di.www.CartePluginInterface;
import org.pentaho.di.www.GetTransStatusServlet;

public class GetJobImageServlet
extends BaseHttpServlet
implements CartePluginInterface {
    private static final long serialVersionUID = -4365372274638005929L;
    private static Class<?> PKG = GetTransStatusServlet.class;
    public static final String CONTEXT_PATH = "/kettle/jobImage";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        block11: {
            Job job;
            if (this.isJettyMode() && !request.getContextPath().startsWith(CONTEXT_PATH)) {
                return;
            }
            if (this.log.isDebug()) {
                this.logDebug(BaseMessages.getString(PKG, (String)"GetJobImageServlet.Log.JobImageRequested", (String[])new String[0]));
            }
            String jobName = request.getParameter("name");
            String id = request.getParameter("id");
            if (Utils.isEmpty((CharSequence)id)) {
                CarteObjectEntry entry = this.getJobMap().getFirstCarteObjectEntry(jobName);
                if (entry == null) {
                    job = null;
                } else {
                    id = entry.getId();
                    job = this.getJobMap().getJob(entry);
                }
            } else {
                CarteObjectEntry entry = new CarteObjectEntry(jobName, id);
                job = this.getJobMap().getJob(entry);
            }
            try {
                if (job == null) break block11;
                response.setStatus(200);
                response.setCharacterEncoding("UTF-8");
                response.setContentType("image/png");
                BufferedImage image = this.generateJobImage(job.getJobMeta());
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                try {
                    ImageIO.write((RenderedImage)image, "png", os);
                }
                finally {
                    os.flush();
                }
                response.setContentLength(os.size());
                ServletOutputStream out = response.getOutputStream();
                out.write(os.toByteArray());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private BufferedImage generateJobImage(JobMeta jobMeta) throws Exception {
        float magnification = 1.0f;
        Point maximum = jobMeta.getMaximum();
        maximum.multiply(magnification);
        SwingGC gc = new SwingGC(null, maximum, 32, 0, 0);
        JobPainter jobPainter = new JobPainter(gc, jobMeta, maximum, null, null, null, null, null, new ArrayList<AreaOwner>(), new ArrayList<JobEntryCopy>(), 32, 1, 0, 0, true, "Arial", 10);
        jobPainter.setMagnification(magnification);
        jobPainter.drawJob();
        BufferedImage image = (BufferedImage)gc.getImage();
        return image;
    }

    public String toString() {
        return "Job Image Handler";
    }

    @Override
    public String getService() {
        return "/kettle/jobImage (" + this.toString() + ")";
    }

    @Override
    public String getContextPath() {
        return CONTEXT_PATH;
    }
}

