/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.www;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.Date;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.owasp.encoder.Encode;
import org.pentaho.di.cluster.HttpUtil;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.gui.Point;
import org.pentaho.di.core.logging.KettleLogStore;
import org.pentaho.di.core.util.EnvUtil;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.step.BaseStepData;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepStatus;
import org.pentaho.di.www.BaseHttpServlet;
import org.pentaho.di.www.CarteObjectEntry;
import org.pentaho.di.www.CartePluginInterface;
import org.pentaho.di.www.SlaveServerTransStatus;
import org.pentaho.di.www.StatusServletUtils;
import org.pentaho.di.www.TransformationMap;
import org.pentaho.di.www.WebResult;
import org.pentaho.di.www.cache.CarteStatusCache;

public class GetTransStatusServlet
extends BaseHttpServlet
implements CartePluginInterface {
    private static Class<?> PKG = GetTransStatusServlet.class;
    private static final long serialVersionUID = 3634806745372015720L;
    public static final String CONTEXT_PATH = "/kettle/transStatus";
    public static final String SEND_RESULT = "sendResult";
    private static final byte[] XML_HEADER = XMLHandler.getXMLHeader((String)"UTF-8").getBytes(Charset.forName("UTF-8"));
    @VisibleForTesting
    CarteStatusCache cache = CarteStatusCache.getInstance();

    public GetTransStatusServlet() {
    }

    public GetTransStatusServlet(TransformationMap transformationMap) {
        super(transformationMap);
    }

    @Override
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Trans trans;
        CarteObjectEntry entry;
        if (this.isJettyMode() && !request.getContextPath().startsWith(CONTEXT_PATH)) {
            return;
        }
        if (this.log.isDebug()) {
            this.logDebug(BaseMessages.getString(PKG, (String)"TransStatusServlet.Log.TransStatusRequested", (String[])new String[0]));
        }
        String transName = request.getParameter("name");
        String id = request.getParameter("id");
        String root = request.getRequestURI() == null ? "/pentaho" : request.getRequestURI().substring(0, request.getRequestURI().indexOf(CONTEXT_PATH));
        String prefix = this.isJettyMode() ? "/static" : root + "/content/common-ui/resources/themes";
        boolean useXML = "Y".equalsIgnoreCase(request.getParameter("xml"));
        int startLineNr = Const.toInt((String)request.getParameter("from"), (int)0);
        response.setStatus(200);
        if (useXML) {
            response.setContentType("text/xml");
            response.setCharacterEncoding("UTF-8");
        } else {
            response.setCharacterEncoding("UTF-8");
            response.setContentType("text/html;charset=UTF-8");
        }
        if (Utils.isEmpty((CharSequence)id)) {
            entry = this.getTransformationMap().getFirstCarteObjectEntry(transName);
            if (entry == null) {
                trans = null;
            } else {
                id = entry.getId();
                trans = this.getTransformationMap().getTransformation(entry);
            }
        } else {
            entry = new CarteObjectEntry(transName, id);
            trans = this.getTransformationMap().getTransformation(entry);
        }
        if (trans != null) {
            if (useXML) {
                try {
                    boolean sendResultXmlWithStatus;
                    ServletOutputStream out = null;
                    byte[] data = null;
                    String logId = trans.getLogChannelId();
                    boolean finishedOrStopped = trans.isFinishedOrStopped();
                    boolean dontUseCache = sendResultXmlWithStatus = "Y".equalsIgnoreCase(request.getParameter(SEND_RESULT));
                    if (finishedOrStopped && (data = this.cache.get(logId, startLineNr)) != null && !dontUseCache) {
                        response.setContentLength(XML_HEADER.length + data.length);
                        out = response.getOutputStream();
                        out.write(XML_HEADER);
                        out.write(data);
                        out.flush();
                    } else {
                        int lastLineNr = KettleLogStore.getLastBufferLineNr();
                        String logText = this.getLogText(trans, startLineNr, lastLineNr);
                        response.setContentType("text/xml");
                        response.setCharacterEncoding("UTF-8");
                        SlaveServerTransStatus transStatus = new SlaveServerTransStatus(transName, entry.getId(), trans.getStatus());
                        transStatus.setFirstLoggingLineNr(startLineNr);
                        transStatus.setLastLoggingLineNr(lastLineNr);
                        transStatus.setLogDate(trans.getLogDate());
                        for (int i = 0; i < trans.nrSteps(); ++i) {
                            StepInterface baseStep = trans.getRunThread(i);
                            if (!baseStep.isRunning() && baseStep.getStatus() == BaseStepData.StepExecutionStatus.STATUS_EMPTY) continue;
                            StepStatus stepStatus = new StepStatus(baseStep);
                            transStatus.getStepStatusList().add(stepStatus);
                        }
                        String loggingString = HttpUtil.encodeBase64ZippedString((String)logText);
                        transStatus.setLoggingString(loggingString);
                        transStatus.setResult(trans.getResult());
                        transStatus.setPaused(trans.isPaused());
                        String xml = transStatus.getXML(sendResultXmlWithStatus);
                        data = xml.getBytes(Charset.forName("UTF-8"));
                        out = response.getOutputStream();
                        response.setContentLength(XML_HEADER.length + data.length);
                        out.write(XML_HEADER);
                        out.write(data);
                        out.flush();
                        if (finishedOrStopped && (transStatus.isFinished() || transStatus.isStopped()) && logId != null && !dontUseCache) {
                            this.cache.put(logId, xml, startLineNr);
                        }
                    }
                    response.flushBuffer();
                }
                catch (KettleException e) {
                    throw new ServletException("Unable to get the transformation status in XML format", (Throwable)e);
                }
            }
            PrintWriter out = response.getWriter();
            int lastLineNr = KettleLogStore.getLastBufferLineNr();
            int tableBorder = 0;
            response.setContentType("text/html;charset=UTF-8");
            out.println("<HTML>");
            out.println("<HEAD>");
            out.println("<TITLE>" + BaseMessages.getString(PKG, (String)"TransStatusServlet.KettleTransStatus", (String[])new String[0]) + "</TITLE>");
            if (EnvUtil.getSystemProperty((String)"KETTLE_CARTE_REFRESH_STATUS", (String)"N").equalsIgnoreCase("Y")) {
                out.println("<META http-equiv=\"Refresh\" content=\"10;url=" + this.convertContextPath(CONTEXT_PATH) + "?name=" + URLEncoder.encode(transName, "UTF-8") + "&id=" + URLEncoder.encode(id, "UTF-8") + "\">");
            }
            out.println("<META http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\">");
            if (this.isJettyMode()) {
                out.println("<link rel=\"stylesheet\" type=\"text/css\" href=\"/static/css/carte.css\" />");
            } else {
                out.print(StatusServletUtils.getPentahoStyles(root));
            }
            out.println("</HEAD>");
            out.println("<BODY style=\"overflow: auto;\">");
            out.println("<div class=\"row\" id=\"pucHeader\">");
            out.println("<div class=\"workspaceHeading\" style=\"padding: 0px 0px 0px 10px;\">" + Encode.forHtml((String)BaseMessages.getString(PKG, (String)"TransStatusServlet.TopTransStatus", (String[])new String[]{transName})) + "</div>");
            out.println("</div>");
            try {
                out.println("<div class=\"row\" style=\"padding: 0px 0px 0px 30px\">");
                out.println("<div class=\"row\" style=\"padding-top: 30px;\">");
                out.print("<a href=\"" + this.convertContextPath("/kettle/status") + "\">");
                out.print("<img src=\"" + prefix + "/images/back.svg\" style=\"margin-right: 5px; width: 16px; height: 16px; vertical-align: middle;\">");
                out.print(BaseMessages.getString(PKG, (String)"CarteStatusServlet.BackToCarteStatus", (String[])new String[0]) + "</a>");
                out.println("</div>");
                out.println("<div class=\"row\" style=\"padding: 30px 0px 75px 0px; display: table;\">");
                out.println("<div style=\"display: table-row;\">");
                out.println("<div style=\"padding: 0px 30px 0px 0px; width: 60px; display: table-cell; vertical-align: top;\">");
                out.println("<img src=\"" + prefix + "/images/trans.svg\" style=\"width: 60px; height: 60px;\"></img>");
                out.println("</div>");
                out.println("<div style=\"vertical-align: top; display: table-cell;\">");
                out.println("<table style=\"border-collapse: collapse;\" border=\"" + tableBorder + "\">");
                out.print("<tr class=\"cellTableRow\" style=\"border: solid; border-width: 1px 0; border-top: none; border-color: #E3E3E3; font-size: 12; text-align: left;\"> <th style=\"font-weight: normal; padding: 8px 10px 10px 10px\" class=\"cellTableHeader\">" + BaseMessages.getString(PKG, (String)"TransStatusServlet.CarteObjectId", (String[])new String[0]) + "</th> <th style=\"font-weight: normal; padding: 8px 10px 10px 10px\" class=\"cellTableHeader\">" + BaseMessages.getString(PKG, (String)"TransStatusServlet.TransStatus", (String[])new String[0]) + "</th> <th style=\"font-weight: normal; padding: 8px 10px 10px 10px\" class=\"cellTableHeader\">" + BaseMessages.getString(PKG, (String)"TransStatusServlet.LastLogDate", (String[])new String[0]) + "</th> </tr>");
                out.print("<tr class=\"cellTableRow\" style=\"border: solid; border-width: 1px 0; border-bottom: none; font-size: 12; text-align: left;\">");
                out.print("<td style=\"padding: 8px 10px 10px 10px\" class=\"cellTableCell cellTableFirstColumn\">" + Encode.forHtml((String)id) + "</td>");
                out.print("<td style=\"padding: 8px 10px 10px 10px\" class=\"cellTableCell\" id=\"statusColor\" style=\"font-weight: bold;\">" + Encode.forHtml((String)trans.getStatus()) + "</td>");
                String dateStr = XMLHandler.date2string((Date)trans.getLogDate());
                out.print("<td style=\"padding: 8px 10px 10px 10px\" class=\"cellTableCell cellTableLastColumn\">" + dateStr.substring(0, dateStr.indexOf(32)) + "</td>");
                out.print("</tr>");
                out.print("</table>");
                out.print("</div>");
                out.println("<div style=\"padding: 0px 0px 0px 20px; width: 90px; display: table-cell; vertical-align: top;\">");
                out.print("<div style=\"display: block; margin-left: auto; margin-right: auto; padding: 5px 0px;\">");
                out.print("<a target=\"_blank\" href=\"" + this.convertContextPath(CONTEXT_PATH) + "?name=" + URLEncoder.encode(transName, "UTF-8") + "&id=" + URLEncoder.encode(id, "UTF-8") + "&xml=y\"><img src=\"" + prefix + "/images/view-as-xml.svg\" style=\"display: block; margin: auto; width: 22px; height: 22px;\"></a>");
                out.print("</div>");
                out.println("<div style=\"text-align: center; padding-top: 12px; font-size: 12px;\">");
                out.print("<a target=\"_blank\" href=\"" + this.convertContextPath(CONTEXT_PATH) + "?name=" + URLEncoder.encode(transName, "UTF-8") + "&id=" + URLEncoder.encode(id, "UTF-8") + "&xml=y\">" + BaseMessages.getString(PKG, (String)"TransStatusServlet.ShowAsXml", (String[])new String[0]) + "</a>");
                out.print("</div>");
                out.print("</div>");
                out.print("</div>");
                out.print("</div>");
                out.print("<div class=\"row\" style=\"padding: 0px 0px 75px 0px;\">");
                out.print("<div class=\"workspaceHeading\" style=\"padding: 0px 0px 30px 0px;\">Step detail</div>");
                out.println("<table class=\"pentaho-table\" border=\"" + tableBorder + "\">");
                out.print("<tr class=\"cellTableRow\"> <th class=\"cellTableHeader\">" + BaseMessages.getString(PKG, (String)"TransStatusServlet.Stepname", (String[])new String[0]) + "</th> <th class=\"cellTableHeader\">" + BaseMessages.getString(PKG, (String)"TransStatusServlet.CopyNr", (String[])new String[0]) + "</th> <th class=\"cellTableHeader\">" + BaseMessages.getString(PKG, (String)"TransStatusServlet.Read", (String[])new String[0]) + "</th> <th class=\"cellTableHeader\">" + BaseMessages.getString(PKG, (String)"TransStatusServlet.Written", (String[])new String[0]) + "</th> <th class=\"cellTableHeader\">" + BaseMessages.getString(PKG, (String)"TransStatusServlet.Input", (String[])new String[0]) + "</th> <th class=\"cellTableHeader\">" + BaseMessages.getString(PKG, (String)"TransStatusServlet.Output", (String[])new String[0]) + "</th> <th class=\"cellTableHeader\">" + BaseMessages.getString(PKG, (String)"TransStatusServlet.Updated", (String[])new String[0]) + "</th> <th class=\"cellTableHeader\">" + BaseMessages.getString(PKG, (String)"TransStatusServlet.Rejected", (String[])new String[0]) + "</th> <th class=\"cellTableHeader\">" + BaseMessages.getString(PKG, (String)"TransStatusServlet.Errors", (String[])new String[0]) + "</th> <th class=\"cellTableHeader\">" + BaseMessages.getString(PKG, (String)"TransStatusServlet.Active", (String[])new String[0]) + "</th> <th class=\"cellTableHeader\">" + BaseMessages.getString(PKG, (String)"TransStatusServlet.Time", (String[])new String[0]) + "</th> <th class=\"cellTableHeader\">" + BaseMessages.getString(PKG, (String)"TransStatusServlet.Speed", (String[])new String[0]) + "</th> <th class=\"cellTableHeader\">" + BaseMessages.getString(PKG, (String)"TransStatusServlet.prinout", (String[])new String[0]) + "</th> </tr>");
                boolean evenRow = true;
                for (int i = 0; i < trans.nrSteps(); ++i) {
                    StepInterface step = trans.getRunThread(i);
                    if (!step.isRunning() && step.getStatus() == BaseStepData.StepExecutionStatus.STATUS_EMPTY) continue;
                    StepStatus stepStatus = new StepStatus(step);
                    boolean snif = false;
                    String htmlString = "";
                    if (step.isRunning() && !step.isStopped() && !step.isPaused()) {
                        snif = true;
                        String sniffLink = " <a href=\"" + this.convertContextPath("/kettle/sniffStep") + "?trans=" + URLEncoder.encode(transName, "UTF-8") + "&id=" + URLEncoder.encode(id, "UTF-8") + "&lines=50&copynr=" + step.getCopy() + "&type=" + "output" + "&step=" + URLEncoder.encode(step.getStepname(), "UTF-8") + "\">" + Encode.forHtml((String)stepStatus.getStepname()) + "</a>";
                        stepStatus.setStepname(sniffLink);
                    }
                    String rowClass = evenRow ? "cellTableEvenRow" : "cellTableOddRow";
                    String cellClass = evenRow ? "cellTableEvenRowCell" : "cellTableOddRowCell";
                    htmlString = "<tr class=\"" + rowClass + "\"><td class=\"cellTableCell cellTableFirstColumn " + cellClass + "\">" + stepStatus.getStepname() + "</td><td class=\"cellTableCell " + cellClass + "\">" + stepStatus.getCopy() + "</td><td class=\"cellTableCell " + cellClass + "\">" + stepStatus.getLinesRead() + "</td><td class=\"cellTableCell " + cellClass + "\">" + stepStatus.getLinesWritten() + "</td><td class=\"cellTableCell " + cellClass + "\">" + stepStatus.getLinesInput() + "</td><td class=\"cellTableCell " + cellClass + "\">" + stepStatus.getLinesOutput() + "</td><td class=\"cellTableCell " + cellClass + "\">" + stepStatus.getLinesUpdated() + "</td><td class=\"cellTableCell " + cellClass + "\">" + stepStatus.getLinesRejected() + "</td><td class=\"cellTableCell " + cellClass + "\">" + stepStatus.getErrors() + "</td><td class=\"cellTableCell " + cellClass + "\">" + stepStatus.getStatusDescription() + "</td><td class=\"cellTableCell " + cellClass + "\">" + stepStatus.getSeconds() + "</td><td class=\"cellTableCell " + cellClass + "\">" + stepStatus.getSpeed() + "</td><td class=\"cellTableCell cellTableLastColumn " + cellClass + "\">" + stepStatus.getPriority() + "</td></tr>";
                    evenRow = !evenRow;
                    out.print(htmlString);
                }
                out.println("</table>");
                out.println("</div>");
                out.print("<div class=\"row\" style=\"padding: 0px 0px 75px 0px;\">");
                out.print("<div class=\"workspaceHeading\" style=\"padding: 0px 0px 30px 0px;\">Canvas preview</div>");
                Point max = trans.getTransMeta().getMaximum();
                max.x += 20;
                max.y += 20;
                out.print("<iframe height=\"" + max.y + "\" width=\"" + 875 + "\" seamless src=\"" + this.convertContextPath("/kettle/transImage") + "?name=" + URLEncoder.encode(transName, "UTF-8") + "&id=" + URLEncoder.encode(id, "UTF-8") + "\"></iframe>");
                out.print("</div>");
                out.print("<div class=\"row\" style=\"padding: 0px 0px 30px 0px;\">");
                out.print("<div class=\"workspaceHeading\" style=\"padding: 0px 0px 30px 0px;\">Transformation log</div>");
                out.println("<textarea id=\"translog\" cols=\"120\" rows=\"20\" wrap=\"off\" name=\"Transformation log\" readonly=\"readonly\" style=\"height: auto;\">" + Encode.forHtml((String)this.getLogText(trans, startLineNr, lastLineNr)) + "</textarea>");
                out.print("</div>");
                out.println("<script type=\"text/javascript\">");
                out.println("element = document.getElementById( 'statusColor' );");
                out.println("if( element.innerHTML == 'Running' || element.innerHTML == 'Finished' ){");
                out.println("element.style.color = '#009900';");
                out.println("} else if( element.innerHTML == 'Stopped' ) {");
                out.println("element.style.color = '#7C0B2B';");
                out.println("} else {");
                out.println("element.style.color = '#F1C40F';");
                out.println("}");
                out.println("</script>");
                out.println("<script type=\"text/javascript\"> ");
                out.println("  translog.scrollTop=translog.scrollHeight; ");
                out.println("</script> ");
            }
            catch (Exception ex) {
                out.println("<pre>");
                out.println(Encode.forHtml((String)Const.getStackTracker((Throwable)ex)));
                out.println("</pre>");
            }
            out.println("</div>");
            out.println("</BODY>");
            out.println("</HTML>");
        } else {
            PrintWriter out = response.getWriter();
            if (useXML) {
                out.println(new WebResult("ERROR", BaseMessages.getString(PKG, (String)"TransStatusServlet.Log.CoundNotFindSpecTrans", (String[])new String[]{transName})));
            } else {
                out.println("<H1>" + Encode.forHtml((String)BaseMessages.getString(PKG, (String)"TransStatusServlet.Log.CoundNotFindTrans", (String[])new String[]{transName})) + "</H1>");
                out.println("<a href=\"" + this.convertContextPath("/kettle/status") + "\">" + BaseMessages.getString(PKG, (String)"TransStatusServlet.BackToStatusPage", (String[])new String[0]) + "</a><p>");
            }
        }
    }

    public String toString() {
        return "Trans Status Handler";
    }

    @Override
    public String getService() {
        return "/kettle/transStatus (" + this.toString() + ")";
    }

    @Override
    public String getContextPath() {
        return CONTEXT_PATH;
    }

    private String getLogText(Trans trans, int startLineNr, int lastLineNr) throws KettleException {
        try {
            return KettleLogStore.getAppender().getBuffer(trans.getLogChannel().getLogChannelId(), false, startLineNr, lastLineNr).toString();
        }
        catch (OutOfMemoryError error) {
            throw new KettleException("Log string is too long", (Throwable)error);
        }
    }
}

