/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.core.database.dialog;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.database.DatabaseTestResults;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.ui.core.database.dialog.DatabaseExplorerDialog;
import org.pentaho.di.ui.core.database.dialog.tags.ExtTextbox;
import org.pentaho.di.ui.core.dialog.ErrorDialog;
import org.pentaho.di.ui.core.dialog.PreviewRowsDialog;
import org.pentaho.di.ui.core.dialog.ShowMessageDialog;
import org.pentaho.ui.database.event.DataHandler;
import org.pentaho.ui.xul.components.XulTextbox;
import org.pentaho.ui.xul.containers.XulTree;

public class DataOverrideHandler
extends DataHandler {
    boolean cancelPressed = false;
    private static Class<?> PKG = DataOverrideHandler.class;
    private List<DatabaseMeta> databases;

    public void onCancel() {
        super.onCancel();
        this.cancelPressed = true;
    }

    public void onOK() {
        super.onOK();
        this.cancelPressed = false;
    }

    public Object getData() {
        if (!this.cancelPressed) {
            return super.getData();
        }
        return null;
    }

    public void explore() {
        Shell parent = this.getShell();
        DatabaseMeta dbinfo = new DatabaseMeta();
        this.getInfo(dbinfo);
        try {
            if (dbinfo.getAccessType() != 3) {
                DatabaseExplorerDialog ded = new DatabaseExplorerDialog(parent, 0, dbinfo, this.databases, true);
                ded.open();
            } else {
                MessageBox mb = new MessageBox(parent, 34);
                mb.setText(BaseMessages.getString(PKG, (String)"DatabaseDialog.ExplorerNotImplemented.Title", (String[])new String[0]));
                mb.setMessage(BaseMessages.getString(PKG, (String)"DatabaseDialog.ExplorerNotImplemented.Message", (String[])new String[0]));
                mb.open();
            }
        }
        catch (Exception e) {
            new ErrorDialog(parent, BaseMessages.getString(PKG, (String)"DatabaseDialog.ErrorParameters.title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"DatabaseDialog.ErrorParameters.description", (String[])new String[0]), e);
        }
    }

    private Shell getShell() {
        Object obj = this.document.getRootElement().getManagedObject();
        Shell parent = obj instanceof Shell ? (Shell)obj : ((Composite)obj).getShell();
        if (parent == null) {
            throw new IllegalStateException("Could not get Shell reference from Xul Dialog Tree.");
        }
        return parent;
    }

    public void showFeatureList() {
        Shell parent = this.getShell();
        DatabaseMeta dbinfo = new DatabaseMeta();
        this.getInfo(dbinfo);
        try {
            List buffer = dbinfo.getFeatureSummary();
            if (buffer.size() > 0) {
                RowMetaInterface rowMeta = ((RowMetaAndData)buffer.get(0)).getRowMeta();
                ArrayList<Object[]> rowData = new ArrayList<Object[]>();
                for (RowMetaAndData row : buffer) {
                    rowData.add(row.getData());
                }
                PreviewRowsDialog prd = new PreviewRowsDialog(parent, (VariableSpace)dbinfo, 0, null, rowMeta, rowData);
                prd.setTitleMessage(BaseMessages.getString(PKG, (String)"DatabaseDialog.FeatureList.title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"DatabaseDialog.FeatureList.title", (String[])new String[0]));
                prd.open();
            }
        }
        catch (Exception e) {
            new ErrorDialog(parent, BaseMessages.getString(PKG, (String)"DatabaseDialog.FeatureListError.title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"DatabaseDialog.FeatureListError.description", (String[])new String[0]), e);
        }
    }

    protected void getControls() {
        super.getControls();
        XulTextbox[] boxes = new XulTextbox[]{this.hostNameBox, this.databaseNameBox, this.portNumberBox, this.userNameBox, this.passwordBox, this.customDriverClassBox, this.customUrlBox, this.dataTablespaceBox, this.indexTablespaceBox, this.poolSizeBox, this.maxPoolSizeBox, this.languageBox, this.systemNumberBox, this.clientBox, this.serverInstanceBox, this.warehouseBox};
        for (int i = 0; i < boxes.length; ++i) {
            XulTextbox xulTextbox = boxes[i];
            if (xulTextbox == null || !(xulTextbox instanceof ExtTextbox)) continue;
            ExtTextbox ext = (ExtTextbox)xulTextbox;
            ext.setVariableSpace((VariableSpace)this.databaseMeta);
        }
        XulTree[] trees = new XulTree[]{this.poolParameterTree, this.clusterParameterTree, this.optionsParameterTree};
        for (int i = 0; i < trees.length; ++i) {
            XulTree xulTree = trees[i];
            if (xulTree == null) continue;
            xulTree.setData((Object)this.databaseMeta);
        }
    }

    public List<DatabaseMeta> getDatabases() {
        return this.databases;
    }

    public void setDatabases(List<DatabaseMeta> databases) {
        this.databases = databases;
    }

    protected void showMessage(String message, boolean scroll) {
        Shell parent = this.getShell();
        ShowMessageDialog msgDialog = new ShowMessageDialog(parent, 34, BaseMessages.getString(PKG, (String)"DatabaseDialog.DatabaseConnectionTest.title", (String[])new String[0]), message, scroll);
        msgDialog.open();
    }

    protected void showMessage(DatabaseTestResults databaseTestResults) {
        String title;
        Shell parent = this.getShell();
        String message = databaseTestResults.getMessage();
        boolean success = databaseTestResults.isSuccess();
        String string = title = success ? BaseMessages.getString(PKG, (String)"DatabaseDialog.DatabaseConnectionTestSuccess.title", (String[])new String[0]) : BaseMessages.getString(PKG, (String)"DatabaseDialog.DatabaseConnectionTest.title", (String[])new String[0]);
        if (success && message.contains(Const.CR)) {
            message = message.substring(0, message.indexOf(Const.CR)) + Const.CR + message.substring(message.indexOf(Const.CR));
            message = message.substring(0, message.lastIndexOf(Const.CR));
        }
        ShowMessageDialog msgDialog = new ShowMessageDialog(parent, 34, title, message, message.length() > 300);
        msgDialog.setType(success ? 1 : 0);
        msgDialog.open();
    }
}

