/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.job.entries.special;

import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.job.entries.special.JobEntrySpecial;
import org.pentaho.di.job.entry.JobEntryDialogInterface;
import org.pentaho.di.job.entry.JobEntryInterface;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.ui.core.gui.GUIResource;
import org.pentaho.di.ui.core.gui.WindowProperty;
import org.pentaho.di.ui.job.dialog.JobDialog;
import org.pentaho.di.ui.job.entry.JobEntryDialog;
import org.pentaho.di.ui.trans.step.BaseStepDialog;

public class JobEntrySpecialDialog
extends JobEntryDialog
implements JobEntryDialogInterface {
    private static Class<?> PKG = JobEntrySpecial.class;
    private static final String NOSCHEDULING = BaseMessages.getString(PKG, (String)"JobSpecial.Type.NoScheduling", (String[])new String[0]);
    private static final String INTERVAL = BaseMessages.getString(PKG, (String)"JobSpecial.Type.Interval", (String[])new String[0]);
    private static final String DAILY = BaseMessages.getString(PKG, (String)"JobSpecial.Type.Daily", (String[])new String[0]);
    private static final String WEEKLY = BaseMessages.getString(PKG, (String)"JobSpecial.Type.Weekly", (String[])new String[0]);
    private static final String MONTHLY = BaseMessages.getString(PKG, (String)"JobSpecial.Type.Monthly", (String[])new String[0]);
    private Button wOK;
    private Button wCancel;
    private Listener lsOK;
    private Listener lsCancel;
    private Shell shell;
    private SelectionAdapter lsDef;
    private JobEntrySpecial jobEntry;
    private boolean backupChanged;
    private Display display;
    private Button wRepeat;
    private Spinner wIntervalSeconds;
    private Spinner wIntervalMinutes;
    private CCombo wType;
    private Spinner wHour;
    private Spinner wMinutes;
    private CCombo wDayOfWeek;
    private Spinner wDayOfMonth;
    private Label wlName;
    private Text wName;
    private FormData fdlName;
    private FormData fdName;

    public JobEntrySpecialDialog(Shell parent, JobEntryInterface jobEntryInt, Repository rep, JobMeta jobMeta) {
        super(parent, jobEntryInt, rep, jobMeta);
        this.jobEntry = (JobEntrySpecial)jobEntryInt;
    }

    public JobEntryInterface open() {
        Shell parent = this.getParent();
        this.display = parent.getDisplay();
        this.shell = new Shell(parent, this.props.getJobsDialogStyle());
        this.props.setLook((Control)this.shell);
        JobDialog.setShellImage(this.shell, (JobEntryInterface)this.jobEntry);
        this.shell.setImage(GUIResource.getInstance().getImageStart());
        ModifyListener lsMod = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                JobEntrySpecialDialog.this.jobEntry.setChanged();
            }
        };
        this.backupChanged = this.jobEntry.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"JobSpecial.Dummy.Label", (String[])new String[0]));
        int margin = 4;
        int middle = this.props.getMiddlePct();
        this.wlName = new Label((Composite)this.shell, 131072);
        this.wlName.setText(BaseMessages.getString(PKG, (String)"JobSpecial.Jobname.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlName);
        this.fdlName = new FormData();
        this.fdlName.left = new FormAttachment(0, 0);
        this.fdlName.right = new FormAttachment(middle, -margin);
        this.fdlName.top = new FormAttachment(0, margin);
        this.wlName.setLayoutData((Object)this.fdlName);
        this.wName = new Text((Composite)this.shell, 18436);
        this.props.setLook((Control)this.wName);
        this.wName.addModifyListener(lsMod);
        this.fdName = new FormData();
        this.fdName.left = new FormAttachment(middle, 0);
        this.fdName.top = new FormAttachment(0, margin);
        this.fdName.right = new FormAttachment(100, 0);
        this.wName.setLayoutData((Object)this.fdName);
        BaseStepDialog.setSize(this.shell, 350, 120, true);
        if (!this.jobEntry.isDummy()) {
            this.shell.setText(BaseMessages.getString(PKG, (String)"JobSpecial.Scheduling.Label", (String[])new String[0]));
            this.wRepeat = new Button((Composite)this.shell, 32);
            this.wRepeat.addListener(13, new Listener(){

                public void handleEvent(Event arg0) {
                    JobEntrySpecialDialog.this.enableDisableControls();
                }
            });
            this.placeControl(this.shell, BaseMessages.getString(PKG, (String)"JobSpecial.Repeat.Label", (String[])new String[0]), (Control)this.wRepeat, (Control)this.wName);
            this.wType = new CCombo((Composite)this.shell, 18436);
            this.wType.addModifyListener(lsMod);
            this.wType.addListener(13, new Listener(){

                public void handleEvent(Event arg0) {
                    JobEntrySpecialDialog.this.enableDisableControls();
                }
            });
            this.wType.add(NOSCHEDULING);
            this.wType.add(INTERVAL);
            this.wType.add(DAILY);
            this.wType.add(WEEKLY);
            this.wType.add(MONTHLY);
            this.wType.setEditable(false);
            this.wType.setVisibleItemCount(this.wType.getItemCount());
            this.placeControl(this.shell, BaseMessages.getString(PKG, (String)"JobSpecial.Type.Label", (String[])new String[0]), (Control)this.wType, (Control)this.wRepeat);
            this.wIntervalSeconds = new Spinner((Composite)this.shell, 18436);
            this.wIntervalSeconds.setMinimum(0);
            this.wIntervalSeconds.setMaximum(Integer.MAX_VALUE);
            this.placeControl(this.shell, BaseMessages.getString(PKG, (String)"JobSpecial.IntervalSeconds.Label", (String[])new String[0]), (Control)this.wIntervalSeconds, (Control)this.wType);
            this.wIntervalMinutes = new Spinner((Composite)this.shell, 18436);
            this.wIntervalMinutes.setMinimum(0);
            this.wIntervalMinutes.setMaximum(Integer.MAX_VALUE);
            this.placeControl(this.shell, BaseMessages.getString(PKG, (String)"JobSpecial.IntervalMinutes.Label", (String[])new String[0]), (Control)this.wIntervalMinutes, (Control)this.wIntervalSeconds);
            Composite time = new Composite((Composite)this.shell, 0);
            time.setLayout((Layout)new FillLayout());
            this.wHour = new Spinner(time, 18436);
            this.wHour.setMinimum(0);
            this.wHour.setMaximum(23);
            this.wMinutes = new Spinner(time, 18436);
            this.wMinutes.setMinimum(0);
            this.wMinutes.setMaximum(59);
            this.placeControl(this.shell, BaseMessages.getString(PKG, (String)"JobSpecial.TimeOfDay.Label", (String[])new String[0]), (Control)time, (Control)this.wIntervalMinutes);
            this.wDayOfWeek = new CCombo((Composite)this.shell, 18436);
            this.wDayOfWeek.addModifyListener(lsMod);
            this.wDayOfWeek.add(BaseMessages.getString(PKG, (String)"JobSpecial.DayOfWeek.Sunday", (String[])new String[0]));
            this.wDayOfWeek.add(BaseMessages.getString(PKG, (String)"JobSpecial.DayOfWeek.Monday", (String[])new String[0]));
            this.wDayOfWeek.add(BaseMessages.getString(PKG, (String)"JobSpecial.DayOfWeek.Tuesday", (String[])new String[0]));
            this.wDayOfWeek.add(BaseMessages.getString(PKG, (String)"JobSpecial.DayOfWeek.Wednesday", (String[])new String[0]));
            this.wDayOfWeek.add(BaseMessages.getString(PKG, (String)"JobSpecial.DayOfWeek.Thursday", (String[])new String[0]));
            this.wDayOfWeek.add(BaseMessages.getString(PKG, (String)"JobSpecial.DayOfWeek.Friday", (String[])new String[0]));
            this.wDayOfWeek.add(BaseMessages.getString(PKG, (String)"JobSpecial.DayOfWeek.Saturday", (String[])new String[0]));
            this.wDayOfWeek.setEditable(false);
            this.wDayOfWeek.setVisibleItemCount(this.wDayOfWeek.getItemCount());
            this.placeControl(this.shell, BaseMessages.getString(PKG, (String)"JobSpecial.DayOfWeek.Label", (String[])new String[0]), (Control)this.wDayOfWeek, (Control)time);
            this.wDayOfMonth = new Spinner((Composite)this.shell, 18436);
            this.wDayOfMonth.addModifyListener(lsMod);
            this.wDayOfMonth.setMinimum(1);
            this.wDayOfMonth.setMaximum(30);
            this.placeControl(this.shell, BaseMessages.getString(PKG, (String)"JobSpecial.DayOfMonth.Label", (String[])new String[0]), (Control)this.wDayOfMonth, (Control)this.wDayOfWeek);
            this.lsDef = new SelectionAdapter(){

                public void widgetDefaultSelected(SelectionEvent e) {
                    JobEntrySpecialDialog.this.ok();
                }
            };
            this.wType.addSelectionListener((SelectionListener)this.lsDef);
            BaseStepDialog.setSize(this.shell, 370, 285, true);
        }
        this.wOK = new Button((Composite)this.shell, 8);
        this.wOK.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        BaseStepDialog.positionBottomButtons((Composite)this.shell, new Button[]{this.wOK, this.wCancel}, margin, (Control)this.wDayOfMonth);
        this.lsCancel = new Listener(){

            public void handleEvent(Event e) {
                JobEntrySpecialDialog.this.cancel();
            }
        };
        this.lsOK = new Listener(){

            public void handleEvent(Event e) {
                JobEntrySpecialDialog.this.ok();
            }
        };
        this.wOK.addListener(13, this.lsOK);
        this.wCancel.addListener(13, this.lsCancel);
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                JobEntrySpecialDialog.this.cancel();
            }
        });
        this.getData();
        this.enableDisableControls();
        this.shell.open();
        this.props.setDialogSize(this.shell, "JobSpecialDialogSize");
        while (!this.shell.isDisposed()) {
            if (this.display.readAndDispatch()) continue;
            this.display.sleep();
        }
        return this.jobEntry;
    }

    public void dispose() {
        this.shell.setSize(350, 120);
        WindowProperty winprop = new WindowProperty(this.shell);
        this.props.setScreen(winprop);
        this.shell.dispose();
    }

    public void getData() {
        if (!this.jobEntry.isDummy()) {
            this.wRepeat.setSelection(this.jobEntry.isRepeat());
            this.wType.select(this.jobEntry.getSchedulerType());
            this.wIntervalSeconds.setSelection(this.jobEntry.getIntervalSeconds());
            this.wIntervalMinutes.setSelection(this.jobEntry.getIntervalMinutes());
            this.wHour.setSelection(this.jobEntry.getHour());
            this.wMinutes.setSelection(this.jobEntry.getMinutes());
            this.wDayOfWeek.select(this.jobEntry.getWeekDay());
            this.wDayOfMonth.setSelection(this.jobEntry.getDayOfMonth());
            this.wType.addSelectionListener((SelectionListener)this.lsDef);
        }
        this.wName.setText(this.jobEntry.getName());
    }

    private void cancel() {
        this.jobEntry.setChanged(this.backupChanged);
        this.jobEntry = null;
        this.dispose();
    }

    private void ok() {
        if (!this.jobEntry.isDummy()) {
            this.jobEntry.setRepeat(this.wRepeat.getSelection());
            this.jobEntry.setSchedulerType(this.wType.getSelectionIndex());
            this.jobEntry.setIntervalSeconds(this.wIntervalSeconds.getSelection());
            this.jobEntry.setIntervalMinutes(this.wIntervalMinutes.getSelection());
            this.jobEntry.setHour(this.wHour.getSelection());
            this.jobEntry.setMinutes(this.wMinutes.getSelection());
            this.jobEntry.setWeekDay(this.wDayOfWeek.getSelectionIndex());
            this.jobEntry.setDayOfMonth(this.wDayOfMonth.getSelection());
        }
        this.jobEntry.setName(this.wName.getText());
        this.dispose();
    }

    private void placeControl(Shell pShell, String text, Control control, Control under) {
        int middle = this.props.getMiddlePct();
        int margin = 4;
        Label label = new Label((Composite)pShell, 131072);
        label.setText(text);
        this.props.setLook((Control)label);
        FormData formDataLabel = new FormData();
        formDataLabel.left = new FormAttachment(0, 0);
        formDataLabel.top = under != null ? new FormAttachment(under, margin) : new FormAttachment(0, 0);
        formDataLabel.right = new FormAttachment(middle, 0);
        label.setLayoutData((Object)formDataLabel);
        this.props.setLook(control);
        FormData formDataControl = new FormData();
        formDataControl.left = new FormAttachment(middle, 0);
        formDataControl.top = under != null ? new FormAttachment(under, margin) : new FormAttachment(0, 0);
        formDataControl.right = new FormAttachment(100, 0);
        control.setLayoutData((Object)formDataControl);
    }

    private void enableDisableControls() {
        if (!this.jobEntry.isDummy()) {
            this.wType.setEnabled(true);
            if (NOSCHEDULING.equals(this.wType.getText())) {
                this.wIntervalSeconds.setEnabled(false);
                this.wIntervalMinutes.setEnabled(false);
                this.wDayOfWeek.setEnabled(false);
                this.wDayOfMonth.setEnabled(false);
                this.wHour.setEnabled(false);
                this.wMinutes.setEnabled(false);
            } else if (INTERVAL.equals(this.wType.getText())) {
                this.wIntervalSeconds.setEnabled(true);
                this.wIntervalMinutes.setEnabled(true);
                this.wDayOfWeek.setEnabled(false);
                this.wDayOfMonth.setEnabled(false);
                this.wHour.setEnabled(false);
                this.wMinutes.setEnabled(false);
            } else if (DAILY.equals(this.wType.getText())) {
                this.wIntervalSeconds.setEnabled(false);
                this.wIntervalMinutes.setEnabled(false);
                this.wDayOfWeek.setEnabled(false);
                this.wDayOfMonth.setEnabled(false);
                this.wHour.setEnabled(true);
                this.wMinutes.setEnabled(true);
            } else if (WEEKLY.equals(this.wType.getText())) {
                this.wIntervalSeconds.setEnabled(false);
                this.wIntervalMinutes.setEnabled(false);
                this.wDayOfWeek.setEnabled(true);
                this.wDayOfMonth.setEnabled(false);
                this.wHour.setEnabled(true);
                this.wMinutes.setEnabled(true);
            } else if (MONTHLY.equals(this.wType.getText())) {
                this.wIntervalSeconds.setEnabled(false);
                this.wIntervalMinutes.setEnabled(false);
                this.wDayOfWeek.setEnabled(false);
                this.wDayOfMonth.setEnabled(true);
                this.wHour.setEnabled(true);
                this.wMinutes.setEnabled(true);
            }
        }
    }
}

