/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.spoon;

import org.pentaho.di.repository.RepositoryDirectoryInterface;
import org.pentaho.di.ui.spoon.TabItemInterface;
import org.pentaho.xul.swt.tab.TabItem;

public class TabMapEntry {
    private TabItem tabItem;
    private String filename;
    private String objectName;
    private RepositoryDirectoryInterface repositoryDirectory;
    private String connection;
    private String versionLabel;
    private TabItemInterface object;
    private ObjectType objectType;
    private boolean showingLocation;

    public TabMapEntry(TabItem tabItem, String filename, String objectName, RepositoryDirectoryInterface repositoryDirectory, String versionLabel, TabItemInterface object, ObjectType objectType, String connection) {
        this.tabItem = tabItem;
        this.filename = filename;
        this.objectName = objectName;
        this.repositoryDirectory = repositoryDirectory;
        this.versionLabel = versionLabel;
        this.object = object;
        this.objectType = objectType;
        this.connection = connection;
    }

    public TabMapEntry(TabItem tabItem, String filename, String objectName, RepositoryDirectoryInterface repositoryDirectory, String versionLabel, TabItemInterface object, ObjectType objectType) {
        this(tabItem, filename, objectName, repositoryDirectory, versionLabel, object, objectType, null);
    }

    public boolean equals(Object obj) {
        TabMapEntry entry = (TabMapEntry)obj;
        boolean sameType = this.objectType.equals((Object)entry.objectType);
        boolean sameName = this.objectName != null && entry.objectName != null && this.objectName.equals(entry.objectName);
        boolean sameFile = this.filename == null && entry.filename == null || this.filename != null && this.filename.equals(entry.filename);
        boolean sameVersion = this.versionLabel == null && entry.versionLabel == null || this.versionLabel != null && this.versionLabel.equals(entry.versionLabel);
        boolean sameDirectory = this.repositoryDirectory == null && entry.repositoryDirectory == null || this.repositoryDirectory != null && entry.repositoryDirectory != null && this.repositoryDirectory.getPath().equals(entry.repositoryDirectory.getPath());
        return sameType && sameName && sameVersion && sameFile && sameDirectory;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public void setObjectName(String objectName) {
        this.objectName = objectName;
    }

    public String getVersionLabel() {
        return this.versionLabel;
    }

    public void setVersionLabel(String versionLabel) {
        this.versionLabel = versionLabel;
    }

    public TabItemInterface getObject() {
        return this.object;
    }

    public void setObject(TabItemInterface object) {
        this.object = object;
    }

    public TabItem getTabItem() {
        return this.tabItem;
    }

    public void setTabItem(TabItem tabItem) {
        this.tabItem = tabItem;
    }

    public ObjectType getObjectType() {
        return this.objectType;
    }

    public void setObjectType(ObjectType objectType) {
        this.objectType = objectType;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public RepositoryDirectoryInterface getRepositoryDirectory() {
        return this.repositoryDirectory;
    }

    public void setRepositoryDirectory(RepositoryDirectoryInterface repositoryDirectory) {
        this.repositoryDirectory = repositoryDirectory;
    }

    public boolean isShowingLocation() {
        return this.showingLocation;
    }

    public void setShowingLocation(boolean showingLocation) {
        this.showingLocation = showingLocation;
    }

    public String getConnection() {
        return this.connection;
    }

    public void setConnection(String connection) {
        this.connection = connection;
    }

    public static enum ObjectType {
        TRANSFORMATION_GRAPH,
        JOB_GRAPH,
        SLAVE_SERVER,
        BROWSER,
        PLUGIN;

    }
}

