/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.spoon.tree.provider;

import org.pentaho.di.base.AbstractMeta;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.KettleRepositoryLostException;
import org.pentaho.di.ui.core.dialog.ErrorDialog;
import org.pentaho.di.ui.core.gui.GUIResource;
import org.pentaho.di.ui.core.widget.tree.TreeNode;
import org.pentaho.di.ui.spoon.DatabasesCollector;
import org.pentaho.di.ui.spoon.Spoon;
import org.pentaho.di.ui.spoon.tree.provider.AutomaticTreeFolderProvider;

public class DBConnectionFolderProvider
extends AutomaticTreeFolderProvider {
    private static Class<?> PKG = Spoon.class;
    public static final String STRING_CONNECTIONS = BaseMessages.getString(PKG, (String)"Spoon.STRING_CONNECTIONS", (String[])new String[0]);
    private GUIResource guiResource;
    private Spoon spoon;

    public DBConnectionFolderProvider(GUIResource guiResource, Spoon spoon) {
        this.guiResource = guiResource;
        this.spoon = spoon;
    }

    public DBConnectionFolderProvider() {
        this(GUIResource.getInstance(), Spoon.getInstance());
    }

    @Override
    public void refresh(AbstractMeta meta, TreeNode treeNode, String filter) {
        DatabasesCollector collector;
        block6: {
            collector = new DatabasesCollector(meta, this.spoon.getRepository());
            try {
                try {
                    collector.collectDatabases();
                }
                catch (KettleException e) {
                    if (e.getCause() instanceof KettleRepositoryLostException) {
                        Spoon.getInstance().handleRepositoryLost((KettleRepositoryLostException)e.getCause());
                        collector = new DatabasesCollector(meta, null);
                        collector.collectDatabases();
                        break block6;
                    }
                    throw e;
                }
            }
            catch (KettleException e) {
                new ErrorDialog(Spoon.getInstance().getShell(), BaseMessages.getString(PKG, (String)"Spoon.ErrorDialog.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"Spoon.ErrorDialog.ErrorFetchingFromRepo.DbConnections", (String[])new String[0]), (Exception)((Object)e));
            }
        }
        for (String dbName : collector.getDatabaseNames()) {
            if (!this.filterMatch(dbName, filter)) continue;
            DatabaseMeta databaseMeta = collector.getMetaFor(dbName);
            TreeNode childTreeNode = this.createTreeNode(treeNode, databaseMeta.getDisplayName(), this.guiResource.getImageConnectionTree());
            if (!databaseMeta.isShared()) continue;
            childTreeNode.setFont(this.guiResource.getFontBold());
        }
    }

    @Override
    public String getTitle() {
        return STRING_CONNECTIONS;
    }

    @Override
    public Class getType() {
        return DatabaseMeta.class;
    }
}

