/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.trans.debug;

import java.util.Hashtable;
import java.util.Map;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.pentaho.di.core.Condition;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.debug.StepDebugMeta;
import org.pentaho.di.trans.debug.TransDebugMeta;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.ui.core.PropsUI;
import org.pentaho.di.ui.core.gui.GUIResource;
import org.pentaho.di.ui.core.gui.WindowProperty;
import org.pentaho.di.ui.core.widget.ColumnInfo;
import org.pentaho.di.ui.core.widget.ConditionEditor;
import org.pentaho.di.ui.core.widget.LabelText;
import org.pentaho.di.ui.core.widget.TableView;
import org.pentaho.di.ui.trans.step.BaseStepDialog;

public class TransDebugDialog
extends Dialog {
    private static Class<?> PKG = TransDebugDialog.class;
    public static final int DEBUG_CANCEL = 0;
    public static final int DEBUG_LAUNCH = 1;
    public static final int DEBUG_CONFIG = 2;
    private Display display;
    private Shell parent;
    private Shell shell;
    private PropsUI props;
    private int retval;
    private Button wOK;
    private Button wCancel;
    private Button wLaunch;
    private TableView wSteps;
    private TransDebugMeta transDebugMeta;
    private Composite wComposite;
    private LabelText wRowCount;
    private int margin;
    private int middle;
    private Button wFirstRows;
    private Button wPauseBreakPoint;
    private Condition condition;
    private RowMetaInterface stepInputFields;
    private ConditionEditor wCondition;
    private Label wlCondition;
    private Map<StepMeta, StepDebugMeta> stepDebugMetaMap;
    private int previousIndex;

    public TransDebugDialog(Shell parent, TransDebugMeta transDebugMeta) {
        super(parent);
        this.parent = parent;
        this.transDebugMeta = transDebugMeta;
        this.props = PropsUI.getInstance();
        this.stepDebugMetaMap = new Hashtable<StepMeta, StepDebugMeta>();
        this.stepDebugMetaMap.putAll(transDebugMeta.getStepDebugMetaMap());
        this.previousIndex = -1;
        this.retval = 0;
    }

    public int open() {
        this.display = this.parent.getDisplay();
        this.shell = new Shell(this.parent, 268504304);
        this.props.setLook((Control)this.shell);
        this.shell.setImage(GUIResource.getInstance().getImageTransGraph());
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"TransDebugDialog.Shell.Title", (String[])new String[0]));
        this.margin = 4;
        this.middle = this.props.getMiddlePct();
        this.wOK = new Button((Composite)this.shell, 8);
        this.wOK.setText(BaseMessages.getString(PKG, (String)"TransDebugDialog.Configure.Label", (String[])new String[0]));
        this.wOK.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TransDebugDialog.this.ok(true);
            }
        });
        this.wLaunch = new Button((Composite)this.shell, 8);
        this.wLaunch.setText(BaseMessages.getString(PKG, (String)"TransDebugDialog.Launch.Label", (String[])new String[0]));
        this.wLaunch.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TransDebugDialog.this.ok(false);
            }
        });
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.wCancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TransDebugDialog.this.cancel();
            }
        });
        BaseStepDialog.positionBottomButtons((Composite)this.shell, new Button[]{this.wLaunch, this.wOK, this.wCancel}, this.margin, null);
        this.wOK.setToolTipText(BaseMessages.getString(PKG, (String)"TransDebugDialog.Configure.ToolTip", (String[])new String[0]));
        this.wLaunch.setToolTipText(BaseMessages.getString(PKG, (String)"TransDebugDialog.Launch.ToolTip", (String[])new String[0]));
        ColumnInfo[] stepColumns = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"TransDebugDialog.Column.StepName", (String[])new String[0]), 1, false, true)};
        int nrSteps = this.transDebugMeta.getTransMeta().nrSteps();
        this.wSteps = new TableView((VariableSpace)this.transDebugMeta.getTransMeta(), (Composite)this.shell, 67588, stepColumns, nrSteps, true, null, this.props);
        FormData fdSteps = new FormData();
        fdSteps.left = new FormAttachment(0, 0);
        fdSteps.right = new FormAttachment(this.middle, -this.margin);
        fdSteps.top = new FormAttachment(0, this.margin);
        fdSteps.bottom = new FormAttachment((Control)this.wOK, -this.margin * 2);
        this.wSteps.setLayoutData(fdSteps);
        this.wSteps.table.setHeaderVisible(false);
        this.wSteps.table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TransDebugDialog.this.getStepDebugMeta();
                TransDebugDialog.this.showStepDebugInformation();
            }
        });
        this.wSteps.table.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.character == '\r') {
                    TransDebugDialog.this.wLaunch.notifyListeners(13, new Event());
                }
            }
        });
        this.wComposite = new Composite((Composite)this.shell, 2048);
        this.props.setLook((Control)this.wComposite);
        FormData fdComposite = new FormData();
        fdComposite.left = new FormAttachment(this.middle, 0);
        fdComposite.right = new FormAttachment(100, 0);
        fdComposite.top = new FormAttachment(0, this.margin);
        fdComposite.bottom = new FormAttachment((Control)this.wOK, -this.margin * 2);
        this.wComposite.setLayoutData((Object)fdComposite);
        FormLayout compositeLayout = new FormLayout();
        compositeLayout.marginWidth = 5;
        compositeLayout.marginHeight = 5;
        this.wComposite.setLayout((Layout)compositeLayout);
        this.getData();
        BaseStepDialog.setSize(this.shell);
        this.shell.open();
        this.wLaunch.setFocus();
        this.shell.setDefaultButton(this.wLaunch);
        while (!this.shell.isDisposed()) {
            if (this.display.readAndDispatch()) continue;
            this.display.sleep();
        }
        return this.retval;
    }

    private void getData() {
        this.getStepDebugMeta();
        this.refreshStepList();
    }

    private void refreshStepList() {
        GUIResource resource = GUIResource.getInstance();
        int maxIconSize = 0;
        int indexSelected = -1;
        this.wSteps.table.removeAll();
        for (int i = 0; i < this.transDebugMeta.getTransMeta().getSteps().size(); ++i) {
            StepDebugMeta stepDebugMeta;
            StepMeta stepMeta = this.transDebugMeta.getTransMeta().getStep(i);
            TableItem item = new TableItem(this.wSteps.table, 0);
            Image image = resource.getImagesSteps().get(stepMeta.getStepID()).getAsBitmapForSize((Device)this.display, 32, 32);
            item.setImage(0, image);
            item.setText(0, "");
            item.setText(1, stepMeta.getName());
            if (image.getBounds().width > maxIconSize) {
                maxIconSize = image.getBounds().width;
            }
            if ((stepDebugMeta = this.stepDebugMetaMap.get(stepMeta)) == null) continue;
            item.setBackground(resource.getColorLightPentaho());
            if (indexSelected >= 0) continue;
            indexSelected = i;
        }
        this.wSteps.removeEmptyRows();
        this.wSteps.optWidth(false);
        this.wSteps.table.getColumn(0).setWidth(maxIconSize + 10);
        this.wSteps.table.getColumn(0).setAlignment(0x1000000);
        if (indexSelected >= 0) {
            this.wSteps.table.setSelection(indexSelected);
            this.showStepDebugInformation();
        }
    }

    private void getStepDebugMeta() {
        int index = this.wSteps.getSelectionIndex();
        if (this.previousIndex >= 0) {
            if (this.wComposite.getChildren().length == 0) {
                return;
            }
            StepMeta stepMeta = this.transDebugMeta.getTransMeta().getStep(this.previousIndex);
            StepDebugMeta stepDebugMeta = new StepDebugMeta(stepMeta);
            stepDebugMeta.setCondition(this.condition);
            stepDebugMeta.setPausingOnBreakPoint(this.wPauseBreakPoint.getSelection());
            stepDebugMeta.setReadingFirstRows(this.wFirstRows.getSelection());
            stepDebugMeta.setRowCount(Const.toInt((String)this.wRowCount.getText(), (int)-1));
            this.stepDebugMetaMap.put(stepMeta, stepDebugMeta);
        }
        this.previousIndex = index;
    }

    private void getInfo(TransDebugMeta meta) {
        meta.getStepDebugMetaMap().clear();
        meta.getStepDebugMetaMap().putAll(this.stepDebugMetaMap);
    }

    private void ok(boolean config) {
        this.retval = config ? 2 : 1;
        this.getStepDebugMeta();
        this.getInfo(this.transDebugMeta);
        this.dispose();
    }

    private void dispose() {
        this.props.setScreen(new WindowProperty(this.shell));
        this.shell.dispose();
    }

    private void cancel() {
        this.retval = 0;
        this.dispose();
    }

    private void showStepDebugInformation() {
        for (Control control : this.wComposite.getChildren()) {
            control.dispose();
        }
        this.wComposite.layout(true, true);
        int[] selectionIndices = this.wSteps.table.getSelectionIndices();
        if (selectionIndices == null || selectionIndices.length != 1) {
            return;
        }
        this.previousIndex = selectionIndices[0];
        final StepMeta stepMeta = this.transDebugMeta.getTransMeta().getStep(selectionIndices[0]);
        StepDebugMeta stepDebugMeta = this.stepDebugMetaMap.get(stepMeta);
        this.wRowCount = new LabelText(this.wComposite, BaseMessages.getString(PKG, (String)"TransDebugDialog.RowCount.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"TransDebugDialog.RowCount.ToolTip", (String[])new String[0]));
        FormData fdRowCount = new FormData();
        fdRowCount.left = new FormAttachment(0, 0);
        fdRowCount.right = new FormAttachment(100, 0);
        fdRowCount.top = new FormAttachment(0, 0);
        this.wRowCount.setLayoutData(fdRowCount);
        this.wRowCount.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent arg0) {
                TransDebugDialog.this.ok(false);
            }
        });
        this.wFirstRows = new Button(this.wComposite, 32);
        this.props.setLook((Control)this.wFirstRows);
        this.wFirstRows.setText(BaseMessages.getString(PKG, (String)"TransDebugDialog.FirstRows.Label", (String[])new String[0]));
        this.wFirstRows.setToolTipText(BaseMessages.getString(PKG, (String)"TransDebugDialog.FirstRows.ToolTip", (String[])new String[0]));
        FormData fdFirstRows = new FormData();
        fdFirstRows.left = new FormAttachment(this.middle, 0);
        fdFirstRows.right = new FormAttachment(100, 0);
        fdFirstRows.top = new FormAttachment((Control)this.wRowCount, this.margin);
        this.wFirstRows.setLayoutData((Object)fdFirstRows);
        this.wPauseBreakPoint = new Button(this.wComposite, 32);
        this.props.setLook((Control)this.wPauseBreakPoint);
        this.wPauseBreakPoint.setText(BaseMessages.getString(PKG, (String)"TransDebugDialog.PauseBreakPoint.Label", (String[])new String[0]));
        this.wPauseBreakPoint.setToolTipText(BaseMessages.getString(PKG, (String)"TransDebugDialog.PauseBreakPoint.ToolTip", (String[])new String[0]));
        FormData fdPauseBreakPoint = new FormData();
        fdPauseBreakPoint.left = new FormAttachment(this.middle, 0);
        fdPauseBreakPoint.right = new FormAttachment(100, 0);
        fdPauseBreakPoint.top = new FormAttachment((Control)this.wFirstRows, this.margin);
        this.wPauseBreakPoint.setLayoutData((Object)fdPauseBreakPoint);
        this.condition = null;
        if (stepDebugMeta != null) {
            this.condition = stepDebugMeta.getCondition();
        }
        if (this.condition == null) {
            this.condition = new Condition();
        }
        try {
            this.stepInputFields = this.transDebugMeta.getTransMeta().getStepFields(stepMeta);
        }
        catch (KettleStepException e) {
            this.stepInputFields = new RowMeta();
        }
        this.wlCondition = new Label(this.wComposite, 131072);
        this.props.setLook((Control)this.wlCondition);
        this.wlCondition.setText(BaseMessages.getString(PKG, (String)"TransDebugDialog.Condition.Label", (String[])new String[0]));
        this.wlCondition.setToolTipText(BaseMessages.getString(PKG, (String)"TransDebugDialog.Condition.ToolTip", (String[])new String[0]));
        FormData fdlCondition = new FormData();
        fdlCondition.left = new FormAttachment(0, 0);
        fdlCondition.right = new FormAttachment(this.middle, -this.margin);
        fdlCondition.top = new FormAttachment((Control)this.wPauseBreakPoint, this.margin);
        this.wlCondition.setLayoutData((Object)fdlCondition);
        this.wCondition = new ConditionEditor(this.wComposite, 2048, this.condition, this.stepInputFields);
        FormData fdCondition = new FormData();
        fdCondition.left = new FormAttachment(this.middle, 0);
        fdCondition.right = new FormAttachment(100, 0);
        fdCondition.top = new FormAttachment((Control)this.wPauseBreakPoint, this.margin);
        fdCondition.bottom = new FormAttachment(100, 0);
        this.wCondition.setLayoutData(fdCondition);
        this.getStepDebugData(stepDebugMeta);
        Button wClear = new Button(this.wComposite, 8);
        this.props.setLook((Control)wClear);
        wClear.setText(BaseMessages.getString(PKG, (String)"TransDebugDialog.Clear.Label", (String[])new String[0]));
        wClear.setToolTipText(BaseMessages.getString(PKG, (String)"TransDebugDialog.Clear.ToolTip", (String[])new String[0]));
        FormData fdClear = new FormData();
        fdClear.left = new FormAttachment(0, 0);
        fdClear.bottom = new FormAttachment(100, 0);
        wClear.setLayoutData((Object)fdClear);
        wClear.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TransDebugDialog.this.stepDebugMetaMap.remove(stepMeta);
                ((TransDebugDialog)TransDebugDialog.this).wSteps.table.setSelection(new int[0]);
                TransDebugDialog.this.previousIndex = -1;
                TransDebugDialog.this.refreshStepList();
                TransDebugDialog.this.showStepDebugInformation();
            }
        });
        this.wComposite.layout(true, true);
    }

    private void getStepDebugData(StepDebugMeta stepDebugMeta) {
        if (stepDebugMeta == null) {
            return;
        }
        if (stepDebugMeta.getRowCount() > 0) {
            this.wRowCount.setText(Integer.toString(stepDebugMeta.getRowCount()));
        } else {
            this.wRowCount.setText("");
        }
        this.wFirstRows.setSelection(stepDebugMeta.isReadingFirstRows());
        this.wPauseBreakPoint.setSelection(stepDebugMeta.isPausingOnBreakPoint());
    }
}

