/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.repository.pur;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.encryption.Encr;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.repository.RepositoryElementInterface;
import org.pentaho.di.repository.StringObjectId;
import org.pentaho.di.repository.pur.AbstractDelegate;
import org.pentaho.di.repository.pur.ITransformer;
import org.pentaho.di.repository.pur.PurRepository;
import org.pentaho.di.repository.pur.SharedObjectAssembler;
import org.pentaho.platform.api.repository2.unified.RepositoryFile;
import org.pentaho.platform.api.repository2.unified.VersionSummary;
import org.pentaho.platform.api.repository2.unified.data.node.DataNode;
import org.pentaho.platform.api.repository2.unified.data.node.DataProperty;
import org.pentaho.platform.api.repository2.unified.data.node.NodeRepositoryFileData;
import org.pentaho.platform.repository.RepositoryFilenameUtils;

public class DatabaseDelegate
extends AbstractDelegate
implements ITransformer,
SharedObjectAssembler<DatabaseMeta>,
Serializable {
    private static final long serialVersionUID = 1512547938350522165L;
    private static final String PROP_INDEX_TBS = "INDEX_TBS";
    private static final String PROP_DATA_TBS = "DATA_TBS";
    private static final String PROP_SERVERNAME = "SERVERNAME";
    private static final String PROP_PASSWORD = "PASSWORD";
    private static final String PROP_USERNAME = "USERNAME";
    private static final String PROP_PORT = "PORT";
    private static final String PROP_DATABASE_NAME = "DATABASE_NAME";
    private static final String PROP_HOST_NAME = "HOST_NAME";
    private static final String PROP_CONTYPE = "CONTYPE";
    private static final String PROP_TYPE = "TYPE";
    private static final String NODE_ROOT = "databaseMeta";
    private static final String NODE_ATTRIBUTES = "attributes";
    private PurRepository repo;

    public DatabaseDelegate(PurRepository repo) {
        this.repo = repo;
    }

    @Override
    public DataNode elementToDataNode(RepositoryElementInterface element) throws KettleException {
        DatabaseMeta databaseMeta = (DatabaseMeta)element;
        DataNode rootNode = new DataNode(NODE_ROOT);
        rootNode.setProperty(PROP_TYPE, databaseMeta.getPluginId());
        rootNode.setProperty(PROP_CONTYPE, DatabaseMeta.getAccessTypeDesc((int)databaseMeta.getAccessType()));
        rootNode.setProperty(PROP_HOST_NAME, databaseMeta.getHostname());
        rootNode.setProperty(PROP_DATABASE_NAME, databaseMeta.getDatabaseName());
        rootNode.setProperty(PROP_PORT, new Long(Const.toInt((String)databaseMeta.getDatabasePortNumberString(), (int)-1)).longValue());
        rootNode.setProperty(PROP_USERNAME, databaseMeta.getUsername());
        rootNode.setProperty(PROP_PASSWORD, Encr.encryptPasswordIfNotUsingVariables((String)databaseMeta.getPassword()));
        rootNode.setProperty(PROP_SERVERNAME, databaseMeta.getServername());
        rootNode.setProperty(PROP_DATA_TBS, databaseMeta.getDataTablespace());
        rootNode.setProperty(PROP_INDEX_TBS, databaseMeta.getIndexTablespace());
        DataNode attrNode = rootNode.addNode(NODE_ATTRIBUTES);
        Properties attributes = databaseMeta.getAttributes();
        Enumeration<Object> keys = databaseMeta.getAttributes().keys();
        while (keys.hasMoreElements()) {
            String code = (String)keys.nextElement();
            String attribute = (String)attributes.get(code);
            String escapedCode = RepositoryFilenameUtils.escape((String)code, (List)this.repo.getUnderlyingRepository().getReservedChars());
            attrNode.setProperty(escapedCode, attribute);
        }
        return rootNode;
    }

    @Override
    public RepositoryElementInterface dataNodeToElement(DataNode rootNode) throws KettleException {
        DatabaseMeta databaseMeta = new DatabaseMeta();
        this.dataNodeToElement(rootNode, (RepositoryElementInterface)databaseMeta);
        return databaseMeta;
    }

    @Override
    public void dataNodeToElement(DataNode rootNode, RepositoryElementInterface element) throws KettleException {
        DatabaseMeta databaseMeta = (DatabaseMeta)element;
        databaseMeta.setDatabaseType(this.getString(rootNode, PROP_TYPE));
        databaseMeta.setAccessType(DatabaseMeta.getAccessType((String)this.getString(rootNode, PROP_CONTYPE)));
        databaseMeta.setHostname(this.getString(rootNode, PROP_HOST_NAME));
        databaseMeta.setDBName(this.getString(rootNode, PROP_DATABASE_NAME));
        databaseMeta.setDBPort(this.getString(rootNode, PROP_PORT));
        databaseMeta.setUsername(this.getString(rootNode, PROP_USERNAME));
        databaseMeta.setPassword(Encr.decryptPasswordOptionallyEncrypted((String)this.getString(rootNode, PROP_PASSWORD)));
        databaseMeta.setServername(this.getString(rootNode, PROP_SERVERNAME));
        databaseMeta.setDataTablespace(this.getString(rootNode, PROP_DATA_TBS));
        databaseMeta.setIndexTablespace(this.getString(rootNode, PROP_INDEX_TBS));
        DataNode attrNode = rootNode.getNode(NODE_ATTRIBUTES);
        for (DataProperty property : attrNode.getProperties()) {
            String code = property.getName();
            String attribute = property.getString();
            String unescapeCode = RepositoryFilenameUtils.unescape((String)code);
            databaseMeta.getAttributes().put(unescapeCode, Const.NVL((String)attribute, (String)""));
        }
    }

    public Repository getRepository() {
        return this.repo;
    }

    @Override
    public DatabaseMeta assemble(RepositoryFile file, NodeRepositoryFileData data, VersionSummary version) throws KettleException {
        DatabaseMeta databaseMeta = (DatabaseMeta)this.dataNodeToElement(data.getNode());
        String fileName = file.getName();
        if (fileName.endsWith(".kdb")) {
            fileName = fileName.substring(0, fileName.length() - 4);
        }
        databaseMeta.setChangedDate(file.getLastModifiedDate());
        databaseMeta.setName(fileName);
        databaseMeta.setDisplayName(file.getTitle());
        databaseMeta.setObjectId((ObjectId)new StringObjectId(file.getId().toString()));
        databaseMeta.setObjectRevision(this.repo.createObjectRevision(version));
        databaseMeta.clearChanged();
        return databaseMeta;
    }
}

