/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.salesforceinput;

import java.util.List;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.annotations.Step;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.injection.Injection;
import org.pentaho.di.core.injection.InjectionDeep;
import org.pentaho.di.core.injection.InjectionSupported;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaDate;
import org.pentaho.di.core.row.value.ValueMetaFactory;
import org.pentaho.di.core.row.value.ValueMetaInteger;
import org.pentaho.di.core.row.value.ValueMetaString;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.steps.salesforce.SalesforceConnectionUtils;
import org.pentaho.di.trans.steps.salesforce.SalesforceStepMeta;
import org.pentaho.di.trans.steps.salesforceinput.SalesforceInput;
import org.pentaho.di.trans.steps.salesforceinput.SalesforceInputData;
import org.pentaho.di.trans.steps.salesforceinput.SalesforceInputField;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

@Step(id="SalesforceInput", i18nPackageName="org.pentaho.di.trans.steps.salesforceinput", name="SalesforceInput.TypeLongDesc.SalesforceInput", description="SalesforceInput.TypeTooltipDesc.SalesforceInput", categoryDescription="i18n:org.pentaho.di.trans.step:BaseStep.Category.Input", image="SFI.svg", documentationUrl="Products/Salesforce_Input")
@InjectionSupported(localizationPrefix="SalesforceInputMeta.Injection.", groups={"FIELDS"})
public class SalesforceInputMeta
extends SalesforceStepMeta {
    public static String DATE_TIME_FORMAT = "yyyy-MM-dd HH:mm:ss";
    private static Class<?> PKG = SalesforceInputMeta.class;
    @Injection(name="INCLUDE_SQL_IN_OUTPUT")
    private boolean includeSQL;
    @Injection(name="SQL_FIELDNAME")
    private String sqlField;
    @Injection(name="INCLUDE_TIMESTAMP_IN_OUTPUT")
    private boolean includeTimestamp;
    @Injection(name="TIMESTAMP_FIELDNAME")
    private String timestampField;
    @Injection(name="INCLUDE_URL_IN_OUTPUT")
    private boolean includeTargetURL;
    @Injection(name="URL_FIELDNAME")
    private String targetURLField;
    @Injection(name="INCLUDE_MODULE_IN_OUTPUT")
    private boolean includeModule;
    @Injection(name="MODULE_FIELDNAME")
    private String moduleField;
    @Injection(name="INCLUDE_DELETION_DATE_IN_OUTPUT")
    private boolean includeDeletionDate;
    @Injection(name="DELETION_DATE_FIELDNAME")
    private String deletionDateField;
    @Injection(name="INCLUDE_ROWNUM_IN_OUTPUT")
    private boolean includeRowNumber;
    @Injection(name="ROWNUM_FIELDNAME")
    private String rowNumberField;
    @Injection(name="QUERY_CONDITION")
    private String condition;
    @Injection(name="LIMIT")
    private String rowLimit;
    @InjectionDeep
    private SalesforceInputField[] inputFields;
    @Injection(name="USE_SPECIFIED_QUERY")
    private boolean specifyQuery;
    @Injection(name="SPECIFY_QUERY")
    private String query;
    private int nrFields;
    @Injection(name="END_DATE")
    private String readTo;
    @Injection(name="START_DATE")
    private String readFrom;
    private int recordsFilter;
    @Injection(name="QUERY_ALL")
    private boolean queryAll;

    public SalesforceInputField[] getInputFields() {
        return this.inputFields;
    }

    public void setInputFields(SalesforceInputField[] inputFields) {
        this.inputFields = inputFields;
    }

    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public boolean isSpecifyQuery() {
        return this.specifyQuery;
    }

    public void setSpecifyQuery(boolean specifyQuery) {
        this.specifyQuery = specifyQuery;
    }

    public boolean isQueryAll() {
        return this.queryAll;
    }

    public void setQueryAll(boolean queryAll) {
        this.queryAll = queryAll;
    }

    public String getCondition() {
        return this.condition;
    }

    public void setCondition(String condition) {
        this.condition = condition;
    }

    public void setTargetURLField(String targetURLField) {
        this.targetURLField = targetURLField;
    }

    public void setSQLField(String sqlField) {
        this.sqlField = sqlField;
    }

    public void setTimestampField(String timestampField) {
        this.timestampField = timestampField;
    }

    public void setModuleField(String moduleField) {
        this.moduleField = moduleField;
    }

    public int getRecordsFilter() {
        return this.recordsFilter;
    }

    public void setRecordsFilter(int recordsFilter) {
        this.recordsFilter = recordsFilter;
    }

    @Injection(name="RETRIEVE")
    public void setRecordsFilterDesc(String recordsFilterDesc) {
        this.recordsFilter = SalesforceConnectionUtils.getRecordsFilterByDesc(recordsFilterDesc);
    }

    public boolean includeTargetURL() {
        return this.includeTargetURL;
    }

    public boolean includeSQL() {
        return this.includeSQL;
    }

    public void setIncludeSQL(boolean includeSQL) {
        this.includeSQL = includeSQL;
    }

    public boolean includeTimestamp() {
        return this.includeTimestamp;
    }

    public void setIncludeTimestamp(boolean includeTimestamp) {
        this.includeTimestamp = includeTimestamp;
    }

    public boolean includeModule() {
        return this.includeModule;
    }

    public void setIncludeTargetURL(boolean includeTargetURL) {
        this.includeTargetURL = includeTargetURL;
    }

    public void setIncludeModule(boolean includeModule) {
        this.includeModule = includeModule;
    }

    public boolean includeRowNumber() {
        return this.includeRowNumber;
    }

    public void setIncludeRowNumber(boolean includeRowNumber) {
        this.includeRowNumber = includeRowNumber;
    }

    public boolean includeDeletionDate() {
        return this.includeDeletionDate;
    }

    public void setIncludeDeletionDate(boolean includeDeletionDate) {
        this.includeDeletionDate = includeDeletionDate;
    }

    public String getRowLimit() {
        return this.rowLimit;
    }

    public void setRowLimit(String rowLimit) {
        this.rowLimit = rowLimit;
    }

    public String getRowNumberField() {
        return this.rowNumberField;
    }

    public String getDeletionDateField() {
        return this.deletionDateField;
    }

    public void setDeletionDateField(String value) {
        this.deletionDateField = value;
    }

    public String getTargetURLField() {
        return this.targetURLField;
    }

    public String getReadFrom() {
        return this.readFrom;
    }

    public void setReadFrom(String readFrom) {
        this.readFrom = readFrom;
    }

    public String getReadTo() {
        return this.readTo;
    }

    public void setReadTo(String readTo) {
        this.readTo = readTo;
    }

    public String getSQLField() {
        return this.sqlField;
    }

    public String getTimestampField() {
        return this.timestampField;
    }

    public String getModuleField() {
        return this.moduleField;
    }

    public void setRowNumberField(String rowNumberField) {
        this.rowNumberField = rowNumberField;
    }

    @Override
    public void loadXML(Node stepnode, List<DatabaseMeta> databases, IMetaStore metaStore) throws KettleXMLException {
        super.loadXML(stepnode, databases, metaStore);
        this.readData(stepnode);
    }

    @Override
    public Object clone() {
        SalesforceInputMeta retval = (SalesforceInputMeta)((Object)super.clone());
        int nrFields = this.inputFields.length;
        retval.allocate(nrFields);
        for (int i = 0; i < nrFields; ++i) {
            if (this.inputFields[i] == null) continue;
            retval.inputFields[i] = (SalesforceInputField)this.inputFields[i].clone();
        }
        return retval;
    }

    @Override
    public String getXML() {
        StringBuilder retval = new StringBuilder(super.getXML());
        retval.append("    ").append(XMLHandler.addTagValue((String)"condition", (String)this.getCondition()));
        retval.append("    ").append(XMLHandler.addTagValue((String)"specifyQuery", (boolean)this.isSpecifyQuery()));
        retval.append("    ").append(XMLHandler.addTagValue((String)"query", (String)this.getQuery()));
        retval.append("    ").append(XMLHandler.addTagValue((String)"include_targeturl", (boolean)this.includeTargetURL()));
        retval.append("    ").append(XMLHandler.addTagValue((String)"targeturl_field", (String)this.getTargetURLField()));
        retval.append("    ").append(XMLHandler.addTagValue((String)"include_module", (boolean)this.includeModule()));
        retval.append("    ").append(XMLHandler.addTagValue((String)"module_field", (String)this.getModuleField()));
        retval.append("    ").append(XMLHandler.addTagValue((String)"include_rownum", (boolean)this.includeRowNumber()));
        retval.append("    ").append(XMLHandler.addTagValue((String)"include_deletion_date", (boolean)this.includeDeletionDate()));
        retval.append("    ").append(XMLHandler.addTagValue((String)"deletion_date_field", (String)this.getDeletionDateField()));
        retval.append("    ").append(XMLHandler.addTagValue((String)"rownum_field", (String)this.getRowNumberField()));
        retval.append("    ").append(XMLHandler.addTagValue((String)"include_sql", (boolean)this.includeSQL()));
        retval.append("    ").append(XMLHandler.addTagValue((String)"sql_field", (String)this.getSQLField()));
        retval.append("    ").append(XMLHandler.addTagValue((String)"include_Timestamp", (boolean)this.includeTimestamp()));
        retval.append("    ").append(XMLHandler.addTagValue((String)"timestamp_field", (String)this.getTimestampField()));
        retval.append("    ").append(XMLHandler.addTagValue((String)"read_from", (String)this.getReadFrom()));
        retval.append("    ").append(XMLHandler.addTagValue((String)"read_to", (String)this.getReadTo()));
        retval.append("    ").append(XMLHandler.addTagValue((String)"records_filter", (String)SalesforceConnectionUtils.getRecordsFilterCode(this.getRecordsFilter())));
        retval.append("    ").append(XMLHandler.addTagValue((String)"queryAll", (boolean)this.isQueryAll()));
        retval.append("    ").append(XMLHandler.openTag((String)"fields")).append(Const.CR);
        for (SalesforceInputField field : this.inputFields) {
            retval.append(field.getXML());
        }
        retval.append("    ").append(XMLHandler.closeTag((String)"fields")).append(Const.CR);
        retval.append("    ").append(XMLHandler.addTagValue((String)"limit", (String)this.getRowLimit()));
        return retval.toString();
    }

    private void readData(Node stepnode) throws KettleXMLException {
        try {
            this.setCondition(XMLHandler.getTagValue((Node)stepnode, (String)"condition"));
            this.setQuery(XMLHandler.getTagValue((Node)stepnode, (String)"query"));
            this.setSpecifyQuery("Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"specifyQuery")));
            this.setIncludeTargetURL("Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"include_targeturl")));
            this.setTargetURLField(XMLHandler.getTagValue((Node)stepnode, (String)"targeturl_field"));
            this.setIncludeModule("Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"include_module")));
            this.setModuleField(XMLHandler.getTagValue((Node)stepnode, (String)"module_field"));
            this.setIncludeRowNumber("Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"include_rownum")));
            this.setIncludeDeletionDate("Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"include_deletion_date")));
            this.setRowNumberField(XMLHandler.getTagValue((Node)stepnode, (String)"rownum_field"));
            this.setDeletionDateField(XMLHandler.getTagValue((Node)stepnode, (String)"deletion_date_field"));
            this.setIncludeSQL("Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"include_sql")));
            this.setSQLField(XMLHandler.getTagValue((Node)stepnode, (String)"sql_field"));
            this.setIncludeTimestamp("Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"include_Timestamp")));
            this.setTimestampField(XMLHandler.getTagValue((Node)stepnode, (String)"timestamp_field"));
            this.setReadFrom(XMLHandler.getTagValue((Node)stepnode, (String)"read_from"));
            this.setReadTo(XMLHandler.getTagValue((Node)stepnode, (String)"read_to"));
            this.setRecordsFilter(SalesforceConnectionUtils.getRecordsFilterByCode(Const.NVL((String)XMLHandler.getTagValue((Node)stepnode, (String)"records_filter"), (String)"")));
            this.setQueryAll("Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"queryAll")));
            Node fields = XMLHandler.getSubNode((Node)stepnode, (String)"fields");
            int nrFields = XMLHandler.countNodes((Node)fields, (String)"field");
            this.allocate(nrFields);
            for (int i = 0; i < nrFields; ++i) {
                SalesforceInputField field;
                Node fnode = XMLHandler.getSubNodeByNr((Node)fields, (String)"field", (int)i);
                this.inputFields[i] = field = new SalesforceInputField(fnode);
            }
            this.setRowLimit(XMLHandler.getTagValue((Node)stepnode, (String)"limit"));
        }
        catch (Exception e) {
            throw new KettleXMLException("Unable to load step info from XML", (Throwable)e);
        }
    }

    public void allocate(int nrfields) {
        this.setInputFields(new SalesforceInputField[nrfields]);
    }

    public int getNrFields() {
        return this.nrFields;
    }

    @Override
    public void setDefault() {
        super.setDefault();
        this.setIncludeDeletionDate(false);
        this.setQueryAll(false);
        this.setReadFrom("");
        this.setReadTo("");
        this.nrFields = 0;
        this.setSpecifyQuery(false);
        this.setQuery("");
        this.setCondition("");
        this.setIncludeTargetURL(false);
        this.setTargetURLField("");
        this.setIncludeModule(false);
        this.setModuleField("");
        this.setIncludeRowNumber(false);
        this.setRowNumberField("");
        this.setDeletionDateField("");
        this.setIncludeSQL(false);
        this.setSQLField("");
        this.setIncludeTimestamp(false);
        this.setTimestampField("");
        this.allocate(0);
        this.setRowLimit("0");
    }

    public void getFields(RowMetaInterface r, String name, RowMetaInterface[] info, StepMeta nextStep, VariableSpace space, Repository repository, IMetaStore metaStore) throws KettleStepException {
        ValueMetaString v;
        for (int i = 0; i < this.inputFields.length; ++i) {
            SalesforceInputField field = this.inputFields[i];
            int type = field.getType();
            if (type == 0) {
                type = 2;
            }
            try {
                ValueMetaInterface v2 = ValueMetaFactory.createValueMeta((String)space.environmentSubstitute(field.getName()), (int)type);
                v2.setLength(field.getLength());
                v2.setPrecision(field.getPrecision());
                v2.setOrigin(name);
                v2.setConversionMask(field.getFormat());
                v2.setDecimalSymbol(field.getDecimalSymbol());
                v2.setGroupingSymbol(field.getGroupSymbol());
                v2.setCurrencySymbol(field.getCurrencySymbol());
                r.addValueMeta(v2);
                continue;
            }
            catch (Exception e) {
                throw new KettleStepException((Throwable)e);
            }
        }
        if (this.includeTargetURL && !Utils.isEmpty((CharSequence)this.targetURLField)) {
            v = new ValueMetaString(space.environmentSubstitute(this.targetURLField));
            v.setLength(250);
            v.setPrecision(-1);
            v.setOrigin(name);
            r.addValueMeta((ValueMetaInterface)v);
        }
        if (this.includeModule && !Utils.isEmpty((CharSequence)this.moduleField)) {
            v = new ValueMetaString(space.environmentSubstitute(this.moduleField));
            v.setLength(250);
            v.setPrecision(-1);
            v.setOrigin(name);
            r.addValueMeta((ValueMetaInterface)v);
        }
        if (this.includeSQL && !Utils.isEmpty((CharSequence)this.sqlField)) {
            v = new ValueMetaString(space.environmentSubstitute(this.sqlField));
            v.setLength(250);
            v.setPrecision(-1);
            v.setOrigin(name);
            r.addValueMeta((ValueMetaInterface)v);
        }
        if (this.includeTimestamp && !Utils.isEmpty((CharSequence)this.timestampField)) {
            v = new ValueMetaDate(space.environmentSubstitute(this.timestampField));
            v.setOrigin(name);
            r.addValueMeta((ValueMetaInterface)v);
        }
        if (this.includeRowNumber && !Utils.isEmpty((CharSequence)this.rowNumberField)) {
            v = new ValueMetaInteger(space.environmentSubstitute(this.rowNumberField));
            v.setLength(10, 0);
            v.setOrigin(name);
            r.addValueMeta((ValueMetaInterface)v);
        }
        if (this.includeDeletionDate && !Utils.isEmpty((CharSequence)this.deletionDateField)) {
            v = new ValueMetaDate(space.environmentSubstitute(this.deletionDateField));
            v.setOrigin(name);
            r.addValueMeta((ValueMetaInterface)v);
        }
    }

    @Override
    public void readRep(Repository rep, IMetaStore metaStore, ObjectId idStep, List<DatabaseMeta> databases) throws KettleException {
        super.readRep(rep, metaStore, idStep, databases);
        try {
            this.setCondition(rep.getStepAttributeString(idStep, "condition"));
            this.setQuery(rep.getStepAttributeString(idStep, "query"));
            this.setSpecifyQuery(rep.getStepAttributeBoolean(idStep, "specifyQuery"));
            this.setIncludeTargetURL(rep.getStepAttributeBoolean(idStep, "include_targeturl"));
            this.setTargetURLField(rep.getStepAttributeString(idStep, "targeturl_field"));
            this.setIncludeModule(rep.getStepAttributeBoolean(idStep, "include_module"));
            this.setModuleField(rep.getStepAttributeString(idStep, "module_field"));
            this.setIncludeRowNumber(rep.getStepAttributeBoolean(idStep, "include_rownum"));
            this.setIncludeDeletionDate(rep.getStepAttributeBoolean(idStep, "include_deletion_date"));
            this.setRowNumberField(rep.getStepAttributeString(idStep, "rownum_field"));
            this.setDeletionDateField(rep.getStepAttributeString(idStep, "deletion_date_field"));
            this.setIncludeSQL(rep.getStepAttributeBoolean(idStep, "include_sql"));
            this.setSQLField(rep.getStepAttributeString(idStep, "sql_field"));
            this.setIncludeTimestamp(rep.getStepAttributeBoolean(idStep, "include_Timestamp"));
            this.setTimestampField(rep.getStepAttributeString(idStep, "timestamp_field"));
            this.setRowLimit(rep.getStepAttributeString(idStep, "limit"));
            this.setReadFrom(rep.getStepAttributeString(idStep, "read_from"));
            this.setReadTo(rep.getStepAttributeString(idStep, "read_to"));
            this.setRecordsFilter(SalesforceConnectionUtils.getRecordsFilterByCode(Const.NVL((String)rep.getStepAttributeString(idStep, "records_filter"), (String)"")));
            this.setQueryAll(rep.getStepAttributeBoolean(idStep, "queryAll"));
            int nrFields = rep.countNrStepAttributes(idStep, "field_name");
            this.allocate(nrFields);
            for (int i = 0; i < nrFields; ++i) {
                SalesforceInputField field = new SalesforceInputField();
                field.readRep(rep, metaStore, idStep, i);
                this.inputFields[i] = field;
            }
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"SalesforceInputMeta.Exception.ErrorReadingRepository", (String[])new String[0]), (Throwable)e);
        }
    }

    @Override
    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId idTransformation, ObjectId idStep) throws KettleException {
        super.saveRep(rep, metaStore, idTransformation, idStep);
        try {
            rep.saveStepAttribute(idTransformation, idStep, "condition", this.getCondition());
            rep.saveStepAttribute(idTransformation, idStep, "query", this.getQuery());
            rep.saveStepAttribute(idTransformation, idStep, "specifyQuery", this.isSpecifyQuery());
            rep.saveStepAttribute(idTransformation, idStep, "include_targeturl", this.includeTargetURL());
            rep.saveStepAttribute(idTransformation, idStep, "targeturl_field", this.getTargetURLField());
            rep.saveStepAttribute(idTransformation, idStep, "include_module", this.includeModule());
            rep.saveStepAttribute(idTransformation, idStep, "module_field", this.getModuleField());
            rep.saveStepAttribute(idTransformation, idStep, "include_rownum", this.includeRowNumber());
            rep.saveStepAttribute(idTransformation, idStep, "include_deletion_date", this.includeDeletionDate());
            rep.saveStepAttribute(idTransformation, idStep, "include_sql", this.includeSQL());
            rep.saveStepAttribute(idTransformation, idStep, "sql_field", this.getSQLField());
            rep.saveStepAttribute(idTransformation, idStep, "include_Timestamp", this.includeTimestamp());
            rep.saveStepAttribute(idTransformation, idStep, "timestamp_field", this.getTimestampField());
            rep.saveStepAttribute(idTransformation, idStep, "rownum_field", this.getRowNumberField());
            rep.saveStepAttribute(idTransformation, idStep, "deletion_date_field", this.getDeletionDateField());
            rep.saveStepAttribute(idTransformation, idStep, "limit", this.getRowLimit());
            rep.saveStepAttribute(idTransformation, idStep, "read_from", this.getReadFrom());
            rep.saveStepAttribute(idTransformation, idStep, "read_to", this.getReadTo());
            rep.saveStepAttribute(idTransformation, idStep, "records_filter", SalesforceConnectionUtils.getRecordsFilterCode(this.getRecordsFilter()));
            rep.saveStepAttribute(idTransformation, idStep, "queryAll", this.isQueryAll());
            for (int i = 0; i < this.inputFields.length; ++i) {
                SalesforceInputField field = this.inputFields[i];
                field.saveRep(rep, metaStore, idTransformation, idStep, i);
            }
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"SalesforceInputMeta.Exception.ErrorSavingToRepository", (String[])new String[]{"" + idStep}), (Throwable)e);
        }
    }

    @Override
    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info, VariableSpace space, Repository repository, IMetaStore metaStore) {
        super.check(remarks, transMeta, stepMeta, prev, input, output, info, space, repository, metaStore);
        CheckResult cr = input != null && input.length > 0 ? new CheckResult(4, BaseMessages.getString(PKG, (String)"SalesforceInputMeta.CheckResult.NoInputExpected", (String[])new String[0]), (CheckResultSourceInterface)stepMeta) : new CheckResult(1, BaseMessages.getString(PKG, (String)"SalesforceInputMeta.CheckResult.NoInput", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
        remarks.add((CheckResultInterface)cr);
        cr = this.getInputFields().length == 0 ? new CheckResult(4, BaseMessages.getString(PKG, (String)"SalesforceInputMeta.CheckResult.NoFields", (String[])new String[0]), (CheckResultSourceInterface)stepMeta) : new CheckResult(1, BaseMessages.getString(PKG, (String)"SalesforceInputMeta.CheckResult.FieldsOk", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
        remarks.add((CheckResultInterface)cr);
        if (this.includeTargetURL() && Utils.isEmpty((CharSequence)this.getTargetURLField())) {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"SalesforceInputMeta.CheckResult.NoTargetURLField", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
        if (this.includeSQL() && Utils.isEmpty((CharSequence)this.getSQLField())) {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"SalesforceInputMeta.CheckResult.NoSQLField", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
        if (this.includeModule() && Utils.isEmpty((CharSequence)this.moduleField)) {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"SalesforceInputMeta.CheckResult.NoModuleField", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
        if (this.includeTimestamp() && Utils.isEmpty((CharSequence)this.getTimestampField())) {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"SalesforceInputMeta.CheckResult.NoTimestampField", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
        if (this.includeRowNumber() && Utils.isEmpty((CharSequence)this.getRowNumberField())) {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"SalesforceInputMeta.CheckResult.NoRowNumberField", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
        if (this.includeDeletionDate() && Utils.isEmpty((CharSequence)this.getDeletionDateField())) {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"SalesforceInputMeta.CheckResult.NoDeletionDateField", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
    }

    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta transMeta, Trans trans) {
        return new SalesforceInput(stepMeta, stepDataInterface, cnr, transMeta, trans);
    }

    public StepDataInterface getStepData() {
        return new SalesforceInputData();
    }
}

