/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.spark.converter;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.Result;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POLimit;
import org.apache.pig.backend.hadoop.executionengine.spark.FlatMapFunctionAdapter;
import org.apache.pig.backend.hadoop.executionengine.spark.SparkShims;
import org.apache.pig.backend.hadoop.executionengine.spark.SparkUtil;
import org.apache.pig.backend.hadoop.executionengine.spark.converter.OutputConsumerIterator;
import org.apache.pig.backend.hadoop.executionengine.spark.converter.RDDConverter;
import org.apache.pig.data.Tuple;
import org.apache.spark.rdd.RDD;

public class LimitConverter
implements RDDConverter<Tuple, Tuple, POLimit> {
    @Override
    public RDD<Tuple> convert(List<RDD<Tuple>> predecessors, POLimit poLimit) throws IOException {
        SparkUtil.assertPredecessorSize(predecessors, poLimit, 1);
        RDD<Tuple> rdd = predecessors.get(0);
        LimitFunction limitFunction = new LimitFunction(poLimit);
        RDD<Tuple> rdd2 = SparkShims.getInstance().coalesce(rdd, 1, false);
        return rdd2.toJavaRDD().mapPartitions(SparkShims.getInstance().flatMapFunction(limitFunction), false).rdd();
    }

    private static class LimitFunction
    implements FlatMapFunctionAdapter<Iterator<Tuple>, Tuple> {
        private final POLimit poLimit;

        public LimitFunction(POLimit poLimit) {
            this.poLimit = poLimit;
        }

        @Override
        public Iterator<Tuple> call(Iterator<Tuple> tuples) {
            return new OutputConsumerIterator(tuples){

                @Override
                protected void attach(Tuple tuple) {
                    poLimit.setInputs(null);
                    poLimit.attachInput(tuple);
                }

                @Override
                protected Result getNextResult() throws ExecException {
                    return poLimit.getNextTuple();
                }

                @Override
                protected void endOfInput() {
                }
            };
        }
    }
}

