/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.tez.plan.optimizer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.PhysicalOperator;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PhysicalPlan;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POSplit;
import org.apache.pig.backend.hadoop.executionengine.tez.plan.TezEdgeDescriptor;
import org.apache.pig.backend.hadoop.executionengine.tez.plan.TezOpPlanVisitor;
import org.apache.pig.backend.hadoop.executionengine.tez.plan.TezOperPlan;
import org.apache.pig.backend.hadoop.executionengine.tez.plan.TezOperator;
import org.apache.pig.backend.hadoop.executionengine.tez.plan.operator.POValueOutputTez;
import org.apache.pig.backend.hadoop.executionengine.tez.plan.optimizer.UnionOptimizer;
import org.apache.pig.backend.hadoop.executionengine.tez.util.TezCompilerUtil;
import org.apache.pig.impl.plan.OperatorKey;
import org.apache.pig.impl.plan.PlanException;
import org.apache.pig.impl.plan.PlanWalker;
import org.apache.pig.impl.plan.ReverseDependencyOrderWalker;
import org.apache.pig.impl.plan.VisitorException;

public class MultiQueryOptimizerTez
extends TezOpPlanVisitor {
    private boolean unionOptimizerOn;
    private List<String> unionSupportedStoreFuncs;
    private List<String> unionUnsupportedStoreFuncs;

    public MultiQueryOptimizerTez(TezOperPlan plan, boolean unionOptimizerOn, List<String> unionSupportedStoreFuncs, List<String> unionUnsupportedStoreFuncs) {
        super(plan, (PlanWalker<TezOperator, TezOperPlan>)new ReverseDependencyOrderWalker<TezOperator, TezOperPlan>(plan));
        this.unionOptimizerOn = unionOptimizerOn;
        this.unionSupportedStoreFuncs = unionSupportedStoreFuncs;
        this.unionUnsupportedStoreFuncs = unionUnsupportedStoreFuncs;
    }

    private void addAllPredecessors(TezOperator tezOp, List<TezOperator> predsList) {
        if (((TezOperPlan)this.getPlan()).getPredecessors(tezOp) != null) {
            for (TezOperator pred : ((TezOperPlan)this.getPlan()).getPredecessors(tezOp)) {
                predsList.add(pred);
                this.addAllPredecessors(pred, predsList);
            }
        }
    }

    @Override
    public void visitTezOp(TezOperator tezOp) throws VisitorException {
        try {
            if (!tezOp.isSplitter()) {
                return;
            }
            ArrayList<TezOperator> splittees = new ArrayList<TezOperator>();
            HashSet mergedNonPackageInputSuccessors = new HashSet();
            HashMap<TezOperator, HashSet<OperatorKey>> tentativeMergeUnionMembers = new HashMap<TezOperator, HashSet<OperatorKey>>();
            List<TezOperator> successors = ((TezOperPlan)this.getPlan()).getSuccessors(tezOp);
            HashSet<OperatorKey> splitterAndSuccessorKeys = new HashSet<OperatorKey>();
            splitterAndSuccessorKeys.add(tezOp.getOperatorKey());
            for (TezOperator tezOperator : successors) {
                splitterAndSuccessorKeys.add(tezOperator.getOperatorKey());
            }
            for (TezOperator tezOperator : successors) {
                ArrayList<TezOperator> arrayList = new ArrayList<TezOperator>(((TezOperPlan)this.getPlan()).getPredecessors(tezOperator));
                arrayList.remove(tezOp);
                if (!arrayList.isEmpty()) {
                    for (TezOperator tezOperator2 : ((TezOperPlan)this.getPlan()).getPredecessors(tezOperator)) {
                        if (tezOperator2 == tezOp) continue;
                        arrayList.add(tezOperator2);
                        this.addAllPredecessors(tezOperator2, arrayList);
                    }
                    ArrayList<TezOperator> toMergeSuccPredecessors = new ArrayList<TezOperator>(successors);
                    toMergeSuccPredecessors.remove(tezOperator);
                    for (TezOperator splittee : splittees) {
                        for (TezOperator spliteePred : ((TezOperPlan)this.getPlan()).getPredecessors(splittee)) {
                            if (spliteePred == tezOp) continue;
                            toMergeSuccPredecessors.add(spliteePred);
                            this.addAllPredecessors(spliteePred, toMergeSuccPredecessors);
                        }
                    }
                    if (arrayList.removeAll(toMergeSuccPredecessors)) continue;
                }
                if (tezOperator.getSampleOperator() != null && tezOp.getSampleOperator() != null && !tezOperator.getSampleOperator().equals(tezOp.getSampleOperator())) continue;
                HashSet<TezOperator> mergedSuccessors = new HashSet<TezOperator>();
                HashSet<TezOperator> hashSet = new HashSet<TezOperator>();
                HashSet<TezOperator> toMergeSuccessors = new HashSet<TezOperator>();
                HashSet<TezOperator> nonPackageInputSuccessors = new HashSet<TezOperator>();
                boolean canMerge = true;
                HashSet<TezOperator> successorUnsupportedStoreUnions = new HashSet<TezOperator>();
                mergedSuccessors.addAll(successors);
                for (TezOperator tezOperator3 : splittees) {
                    if (((TezOperPlan)this.getPlan()).getSuccessors(tezOperator3) == null) continue;
                    mergedSuccessors.addAll(((TezOperPlan)this.getPlan()).getSuccessors(tezOperator3));
                }
                if (((TezOperPlan)this.getPlan()).getSuccessors(tezOperator) != null) {
                    nonPackageInputSuccessors.clear();
                    toMergeSuccessors.clear();
                    for (TezOperator tezOperator4 : ((TezOperPlan)this.getPlan()).getSuccessors(tezOperator)) {
                        if (tezOperator4.isUnion()) {
                            List<TezOperator> unionSuccessors;
                            if (!this.unionOptimizerOn || !UnionOptimizer.isOptimizable(tezOperator4)) {
                                hashSet.add(tezOperator4);
                                continue;
                            }
                            if (this.unionOptimizerOn && !UnionOptimizer.isOptimizableStoreFunc(tezOperator4, this.unionSupportedStoreFuncs, this.unionUnsupportedStoreFuncs)) {
                                HashSet<OperatorKey> unionMembers = new HashSet<OperatorKey>(tezOperator4.getUnionMembers());
                                unionMembers.removeAll(splitterAndSuccessorKeys);
                                if (unionMembers.isEmpty()) {
                                    successorUnsupportedStoreUnions.add(tezOperator4);
                                } else {
                                    hashSet.add(tezOperator4);
                                    continue;
                                }
                            }
                            if (TezCompilerUtil.isNonPackageInput(tezOperator.getOperatorKey().toString(), tezOperator4)) {
                                canMerge = canMerge ? nonPackageInputSuccessors.add(tezOperator4) : false;
                            } else {
                                toMergeSuccessors.add(tezOperator4);
                            }
                            if ((unionSuccessors = ((TezOperPlan)this.getPlan()).getSuccessors(tezOperator4)) == null) continue;
                            for (TezOperator unionSuccessor : unionSuccessors) {
                                if (TezCompilerUtil.isNonPackageInput(tezOperator4.getOperatorKey().toString(), unionSuccessor)) {
                                    canMerge = canMerge ? nonPackageInputSuccessors.add(unionSuccessor) : false;
                                    continue;
                                }
                                toMergeSuccessors.add(unionSuccessor);
                            }
                            continue;
                        }
                        if (TezCompilerUtil.isNonPackageInput(tezOperator.getOperatorKey().toString(), tezOperator4)) {
                            canMerge = canMerge ? nonPackageInputSuccessors.add(tezOperator4) : false;
                            continue;
                        }
                        toMergeSuccessors.add(tezOperator4);
                    }
                }
                if (!canMerge || (!nonPackageInputSuccessors.isEmpty() || !mergedNonPackageInputSuccessors.isEmpty()) && (nonPackageInputSuccessors.removeAll(mergedSuccessors) || toMergeSuccessors.removeAll(mergedNonPackageInputSuccessors) || toMergeSuccessors.removeAll(nonPackageInputSuccessors))) continue;
                mergedSuccessors.retainAll(hashSet);
                if (!mergedSuccessors.isEmpty()) continue;
                mergedNonPackageInputSuccessors.addAll(nonPackageInputSuccessors);
                if (successorUnsupportedStoreUnions.isEmpty()) {
                    splittees.add(tezOperator);
                    continue;
                }
                for (TezOperator tezOperator5 : successorUnsupportedStoreUnions) {
                    HashSet<OperatorKey> tentativeSuccessors = (HashSet<OperatorKey>)tentativeMergeUnionMembers.get(tezOperator5);
                    if (tentativeSuccessors == null) {
                        tentativeSuccessors = new HashSet<OperatorKey>();
                        tentativeMergeUnionMembers.put(tezOperator5, tentativeSuccessors);
                    }
                    tentativeSuccessors.add(tezOperator.getOperatorKey());
                }
            }
            HashSet spliteesToRemove = new HashSet();
            for (Map.Entry entry : tentativeMergeUnionMembers.entrySet()) {
                HashSet<OperatorKey> unionMembers = new HashSet<OperatorKey>(((TezOperator)entry.getKey()).getUnionMembers());
                if (((Set)entry.getValue()).containsAll(unionMembers)) {
                    for (OperatorKey key : (Set)entry.getValue()) {
                        TezOperator splittee = (TezOperator)((TezOperPlan)this.getPlan()).getOperator(key);
                        if (splittees.contains(splittee)) continue;
                        splittees.add(splittee);
                    }
                    continue;
                }
                for (OperatorKey key : (Set)entry.getValue()) {
                    spliteesToRemove.add(((TezOperPlan)this.getPlan()).getOperator(key));
                }
            }
            for (TezOperator tezOperator : spliteesToRemove) {
                splittees.remove(tezOperator);
            }
            if (splittees.size() == 0) {
                return;
            }
            if (splittees.size() == 1 && successors.size() == 1) {
                PhysicalOperator physicalOperator = (PhysicalOperator)tezOp.plan.getLeaves().get(0);
                PhysicalOperator physicalOperator2 = tezOp.plan.getPredecessors(physicalOperator).get(0);
                TezOperator singleSplitee = (TezOperator)splittees.get(0);
                PhysicalOperator physicalOperator3 = (PhysicalOperator)singleSplitee.plan.getRoots().get(0);
                PhysicalOperator secondNodeSucc = singleSplitee.plan.getSuccessors(physicalOperator3).get(0);
                tezOp.plan.remove(physicalOperator);
                singleSplitee.plan.remove(physicalOperator3);
                tezOp.plan.merge(singleSplitee.plan);
                tezOp.plan.connect(physicalOperator2, secondNodeSucc);
                this.addSubPlanPropertiesToParent(tezOp, singleSplitee);
                this.removeSplittee((TezOperPlan)this.getPlan(), tezOp, singleSplitee);
            } else {
                POValueOutputTez pOValueOutputTez = (POValueOutputTez)tezOp.plan.getLeaves().get(0);
                POSplit pOSplit = new POSplit(OperatorKey.genOpKey(pOValueOutputTez.getOperatorKey().getScope()));
                pOSplit.copyAliasFrom(pOValueOutputTez);
                for (TezOperator tezOperator : splittees) {
                    PhysicalOperator spliteeRoot = (PhysicalOperator)tezOperator.plan.getRoots().get(0);
                    tezOperator.plan.remove(spliteeRoot);
                    pOSplit.addPlan(tezOperator.plan);
                    this.addSubPlanPropertiesToParent(tezOp, tezOperator);
                    this.removeSplittee((TezOperPlan)this.getPlan(), tezOp, tezOperator);
                    pOValueOutputTez.removeOutputKey(tezOperator.getOperatorKey().toString());
                }
                if (pOValueOutputTez.getTezOutputs().length > 0) {
                    PhysicalPlan phyPlan = new PhysicalPlan();
                    phyPlan.addAsLeaf(pOValueOutputTez);
                    pOSplit.addPlan(phyPlan);
                }
                PhysicalOperator pred = tezOp.plan.getPredecessors(pOValueOutputTez).get(0);
                tezOp.plan.disconnect(pred, pOValueOutputTez);
                tezOp.plan.remove(pOValueOutputTez);
                tezOp.plan.add(pOSplit);
                tezOp.plan.connect(pred, pOSplit);
            }
        }
        catch (PlanException e) {
            throw new VisitorException(e);
        }
    }

    private void removeSplittee(TezOperPlan plan, TezOperator splitter, TezOperator splittee) throws PlanException, VisitorException {
        plan.disconnect(splitter, splittee);
        String spliteeKey = splittee.getOperatorKey().toString();
        String splitterKey = splitter.getOperatorKey().toString();
        if (plan.getPredecessors(splittee) != null) {
            for (TezOperator pred : new ArrayList<TezOperator>(plan.getPredecessors(splittee))) {
                TezEdgeDescriptor edge = pred.outEdges.remove(splittee.getOperatorKey());
                if (edge == null) {
                    throw new VisitorException("Edge description is empty");
                }
                plan.disconnect(pred, splittee);
                TezCompilerUtil.connectTezOpToNewSuccesor(plan, pred, splitter, edge, spliteeKey);
            }
        }
        if (plan.getSuccessors(splittee) != null) {
            ArrayList<TezOperator> succs = new ArrayList<TezOperator>(plan.getSuccessors(splittee));
            List<TezOperator> splitterSuccs = plan.getSuccessors(splitter);
            for (TezOperator succTezOperator : succs) {
                TezEdgeDescriptor edge = succTezOperator.inEdges.get(splittee.getOperatorKey());
                splitter.outEdges.remove(splittee.getOperatorKey());
                succTezOperator.inEdges.remove(splittee.getOperatorKey());
                plan.disconnect(splittee, succTezOperator);
                if (splitterSuccs == null || !splitterSuccs.contains(succTezOperator)) {
                    TezCompilerUtil.connectTezOpToNewPredecessor(plan, succTezOperator, splitter, edge, null);
                }
                TezCompilerUtil.replaceInput(succTezOperator, spliteeKey, splitterKey);
                if (!succTezOperator.isUnion()) continue;
                int index = succTezOperator.getUnionMembers().indexOf(splittee.getOperatorKey());
                while (index > -1) {
                    succTezOperator.getUnionMembers().set(index, splitter.getOperatorKey());
                    index = succTezOperator.getUnionMembers().indexOf(splittee.getOperatorKey());
                }
            }
        }
        plan.remove(splittee);
    }

    private void addSubPlanPropertiesToParent(TezOperator parentOper, TezOperator subPlanOper) {
        if (subPlanOper.getCrossKeys() != null) {
            for (String string : subPlanOper.getCrossKeys()) {
                parentOper.addCrossKey(string);
            }
        }
        parentOper.copyFeatures(subPlanOper, null);
        if (subPlanOper.getSampleOperator() != null) {
            parentOper.setSampleOperator(subPlanOper.getSampleOperator());
        }
        if (subPlanOper.getRequestedParallelism() > parentOper.getRequestedParallelism()) {
            parentOper.setRequestedParallelism(subPlanOper.getRequestedParallelism());
        }
        subPlanOper.setRequestedParallelismByReference(parentOper);
        parentOper.UDFs.addAll(subPlanOper.UDFs);
        parentOper.scalars.addAll(subPlanOper.scalars);
        if (subPlanOper.outEdges != null) {
            for (Map.Entry entry : subPlanOper.outEdges.entrySet()) {
                parentOper.outEdges.put((OperatorKey)entry.getKey(), (TezEdgeDescriptor)entry.getValue());
            }
        }
    }
}

