/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.hive;

import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.minlog.Log;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.io.sarg.PredicateLeaf;
import org.apache.hadoop.hive.ql.io.sarg.SearchArgument;
import org.apache.hadoop.hive.ql.udf.generic.Collector;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.AbstractSerDe;
import org.apache.hadoop.hive.serde2.io.DateWritable;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.shims.HadoopShims;
import org.apache.hadoop.hive.shims.HadoopShimsSecure;
import org.apache.hadoop.hive.shims.ShimLoader;
import org.apache.orc.OrcFile;
import org.joda.time.DateTime;

public class HiveShims {
    public static String normalizeOrcVersionName(String version) {
        return OrcFile.Version.byName((String)version).getName();
    }

    public static void addLessThanOpToBuilder(SearchArgument.Builder builder, String columnName, PredicateLeaf.Type columnType, Object value) {
        builder.lessThan(columnName, columnType, value);
    }

    public static void addLessThanEqualsOpToBuilder(SearchArgument.Builder builder, String columnName, PredicateLeaf.Type columnType, Object value) {
        builder.lessThanEquals(columnName, columnType, value);
    }

    public static void addEqualsOpToBuilder(SearchArgument.Builder builder, String columnName, PredicateLeaf.Type columnType, Object value) {
        builder.equals(columnName, columnType, value);
    }

    public static void addBetweenOpToBuilder(SearchArgument.Builder builder, String columnName, PredicateLeaf.Type columnType, Object low, Object high) {
        builder.between(columnName, columnType, low, high);
    }

    public static void addIsNullOpToBuilder(SearchArgument.Builder builder, String columnName, PredicateLeaf.Type columnType) {
        builder.isNull(columnName, columnType);
    }

    public static Class[] getOrcDependentClasses(Class hadoopVersionShimsClass) {
        return new Class[]{org.apache.hadoop.hive.ql.io.orc.OrcFile.class, HiveConf.class, AbstractSerDe.class, HadoopShims.class, HadoopShimsSecure.class, DateWritable.class, hadoopVersionShimsClass, Input.class, OrcFile.class, Log.class};
    }

    public static Class[] getHiveUDFDependentClasses(Class hadoopVersionShimsClass) {
        return new Class[]{GenericUDF.class, PrimitiveObjectInspector.class, HiveConf.class, Serializer.class, ShimLoader.class, hadoopVersionShimsClass, HadoopShimsSecure.class, Collector.class, HiveDecimalWritable.class};
    }

    public static Object getSearchArgObjValue(Object value) {
        if (value instanceof Integer) {
            return new Long(((Integer)value).intValue());
        }
        if (value instanceof Float) {
            return new Double(((Float)value).floatValue());
        }
        if (value instanceof BigInteger) {
            return new HiveDecimalWritable(HiveDecimal.create((BigInteger)((BigInteger)value)));
        }
        if (value instanceof BigDecimal) {
            return new HiveDecimalWritable(HiveDecimal.create((BigDecimal)((BigDecimal)value)));
        }
        if (value instanceof DateTime) {
            return new Date(((DateTime)value).getMillis());
        }
        return value;
    }
}

