/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.tools.pigstats.spark;

import com.google.common.collect.Maps;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.pig.tools.pigstats.PigStats;
import org.apache.pig.tools.pigstats.spark.SparkJobStats;
import org.apache.spark.executor.ShuffleReadMetrics;
import org.apache.spark.executor.ShuffleWriteMetrics;
import org.apache.spark.executor.TaskMetrics;

public class Spark2JobStats
extends SparkJobStats {
    public Spark2JobStats(int jobId, PigStats.JobGraph plan, Configuration conf) {
        super(jobId, plan, conf);
    }

    public Spark2JobStats(String jobId, PigStats.JobGraph plan, Configuration conf) {
        super(jobId, plan, conf);
    }

    @Override
    protected Map<String, Long> combineTaskMetrics(Map<String, List<TaskMetrics>> jobMetric) {
        LinkedHashMap results = Maps.newLinkedHashMap();
        long executorDeserializeTime = 0L;
        long executorRunTime = 0L;
        long resultSize = 0L;
        long jvmGCTime = 0L;
        long resultSerializationTime = 0L;
        long memoryBytesSpilled = 0L;
        long diskBytesSpilled = 0L;
        long bytesRead = 0L;
        long bytesWritten = 0L;
        long remoteBlocksFetched = 0L;
        long localBlocksFetched = 0L;
        long fetchWaitTime = 0L;
        long remoteBytesRead = 0L;
        long shuffleBytesWritten = 0L;
        long shuffleWriteTime = 0L;
        for (List<TaskMetrics> stageMetric : jobMetric.values()) {
            if (stageMetric == null) continue;
            for (TaskMetrics taskMetrics : stageMetric) {
                if (taskMetrics == null) continue;
                executorDeserializeTime += taskMetrics.executorDeserializeTime();
                executorRunTime += taskMetrics.executorRunTime();
                resultSize += taskMetrics.resultSize();
                jvmGCTime += taskMetrics.jvmGCTime();
                resultSerializationTime += taskMetrics.resultSerializationTime();
                memoryBytesSpilled += taskMetrics.memoryBytesSpilled();
                diskBytesSpilled += taskMetrics.diskBytesSpilled();
                bytesRead += taskMetrics.inputMetrics().bytesRead();
                bytesWritten += taskMetrics.outputMetrics().bytesWritten();
                ShuffleReadMetrics shuffleReadMetricsOption = taskMetrics.shuffleReadMetrics();
                remoteBlocksFetched += shuffleReadMetricsOption.remoteBlocksFetched();
                localBlocksFetched += shuffleReadMetricsOption.localBlocksFetched();
                fetchWaitTime += shuffleReadMetricsOption.fetchWaitTime();
                remoteBytesRead += shuffleReadMetricsOption.remoteBytesRead();
                ShuffleWriteMetrics shuffleWriteMetricsOption = taskMetrics.shuffleWriteMetrics();
                shuffleBytesWritten += shuffleWriteMetricsOption.shuffleBytesWritten();
                shuffleWriteTime += shuffleWriteMetricsOption.shuffleWriteTime();
            }
        }
        results.put("ExcutorDeserializeTime", executorDeserializeTime);
        results.put("ExecutorRunTime", executorRunTime);
        results.put("ResultSize", resultSize);
        results.put("JvmGCTime", jvmGCTime);
        results.put("ResultSerializationTime", resultSerializationTime);
        results.put("MemoryBytesSpilled", memoryBytesSpilled);
        results.put("DiskBytesSpilled", diskBytesSpilled);
        results.put("BytesRead", bytesRead);
        this.hdfsBytesRead = bytesRead;
        this.counters.incrCounter(FS_COUNTER_GROUP, "HDFS_BYTES_READ", this.hdfsBytesRead);
        results.put("BytesWritten", bytesWritten);
        this.hdfsBytesWritten = bytesWritten;
        this.counters.incrCounter(FS_COUNTER_GROUP, "HDFS_BYTES_WRITTEN", this.hdfsBytesWritten);
        results.put("RemoteBlocksFetched", remoteBlocksFetched);
        results.put("LocalBlocksFetched", localBlocksFetched);
        results.put("TotalBlocksFetched", localBlocksFetched + remoteBlocksFetched);
        results.put("FetchWaitTime", fetchWaitTime);
        results.put("RemoteBytesRead", remoteBytesRead);
        results.put("ShuffleBytesWritten", shuffleBytesWritten);
        results.put("ShuffleWriteTime", shuffleWriteTime);
        return results;
    }
}

