/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.hadoop.shim.common.format.avro;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.nio.ByteBuffer;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import org.apache.avro.Conversions;
import org.apache.avro.LogicalType;
import org.apache.avro.LogicalTypes;
import org.apache.avro.Schema;
import org.apache.avro.file.DataFileWriter;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecord;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.exception.KettleValueException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaBase;
import org.pentaho.hadoop.shim.api.format.AvroSpec;
import org.pentaho.hadoop.shim.api.format.IAvroOutputField;
import org.pentaho.hadoop.shim.api.format.IPentahoOutputFormat;

public class PentahoAvroRecordWriter
implements IPentahoOutputFormat.IPentahoRecordWriter {
    private final DataFileWriter<GenericRecord> nativeAvroRecordWriter;
    private final Schema schema;
    private final List<? extends IAvroOutputField> outputFields;

    public PentahoAvroRecordWriter(DataFileWriter<GenericRecord> recordWriter, Schema schema, List<? extends IAvroOutputField> outputFields) {
        this.nativeAvroRecordWriter = recordWriter;
        this.schema = schema;
        this.outputFields = outputFields;
    }

    public void write(RowMetaAndData row) {
        try {
            this.nativeAvroRecordWriter.append((Object)this.createAvroRecord(row));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public GenericRecord createAvroRecord(RowMetaAndData row) {
        RowMetaInterface rmi = row.getRowMeta();
        GenericData.Record outputRecord = new GenericData.Record(this.schema);
        try {
            for (IAvroOutputField iAvroOutputField : this.outputFields) {
                if (iAvroOutputField == null) continue;
                AvroSpec.DataType avroType = iAvroOutputField.getAvroType();
                int fieldMetaIndex = rmi.indexOfValue(iAvroOutputField.getPentahoFieldName());
                ValueMetaInterface vmi = rmi.getValueMeta(fieldMetaIndex);
                String avroFieldName = iAvroOutputField.getFormatFieldName();
                String pentahoFieldName = iAvroOutputField.getPentahoFieldName();
                String defaultValue = null;
                if (!iAvroOutputField.getAllowNull()) {
                    defaultValue = iAvroOutputField.getDefaultValue();
                }
                switch (avroType) {
                    case BOOLEAN: {
                        Boolean booleanValue = null;
                        booleanValue = row.isEmptyValue(pentahoFieldName) ? (defaultValue != null && defaultValue.length() > 0 ? Boolean.valueOf(Boolean.parseBoolean(defaultValue)) : null) : Boolean.valueOf(row.getBoolean(fieldMetaIndex, false));
                        outputRecord.put(avroFieldName, (Object)booleanValue);
                        break;
                    }
                    case DATE: {
                        Date defaultDate = null;
                        if (defaultValue != null && defaultValue.length() > 0) {
                            String conversionMask = vmi.getConversionMask() == null ? ValueMetaBase.DEFAULT_DATE_PARSE_MASK : vmi.getConversionMask();
                            SimpleDateFormat dateFormat = new SimpleDateFormat(conversionMask);
                            try {
                                defaultDate = dateFormat.parse(defaultValue);
                            }
                            catch (ParseException parseException) {
                                // empty catch block
                            }
                        }
                        Integer dateInDays = null;
                        Date dateFromRow = row.getDate(fieldMetaIndex, defaultDate);
                        if (dateFromRow != null) {
                            ValueMetaInterface valueMeta = row.getValueMeta(fieldMetaIndex);
                            TimeZone timeZone = valueMeta.getDateFormatTimeZone();
                            if (timeZone == null) {
                                timeZone = TimeZone.getDefault();
                            }
                            LocalDate localDate = dateFromRow.toInstant().atZone(timeZone.toZoneId()).toLocalDate();
                            dateInDays = Math.toIntExact(ChronoUnit.DAYS.between(LocalDate.ofEpochDay(0L), localDate));
                        }
                        outputRecord.put(avroFieldName, dateInDays);
                        break;
                    }
                    case FLOAT: {
                        Float floatValue = null;
                        floatValue = row.isEmptyValue(pentahoFieldName) ? (defaultValue != null && defaultValue.length() > 0 ? Float.valueOf(Float.parseFloat(defaultValue)) : null) : Float.valueOf((float)row.getNumber(fieldMetaIndex, 0.0));
                        if (floatValue != null) {
                            floatValue = Float.valueOf(this.applyScale(floatValue.floatValue(), iAvroOutputField));
                        }
                        outputRecord.put(avroFieldName, (Object)floatValue);
                        break;
                    }
                    case DOUBLE: {
                        Double doubleValue = null;
                        doubleValue = row.isEmptyValue(pentahoFieldName) ? (defaultValue != null && defaultValue.length() > 0 ? Double.valueOf(Double.parseDouble(defaultValue)) : null) : Double.valueOf(row.getNumber(fieldMetaIndex, 0.0));
                        if (doubleValue != null) {
                            doubleValue = this.applyScale(doubleValue, iAvroOutputField);
                        }
                        outputRecord.put(avroFieldName, (Object)doubleValue);
                        break;
                    }
                    case LONG: {
                        Long longValue = null;
                        longValue = row.isEmptyValue(pentahoFieldName) ? (defaultValue != null && defaultValue.length() > 0 ? Long.valueOf(Long.parseLong(defaultValue)) : null) : Long.valueOf(row.getInteger(fieldMetaIndex, 0L));
                        outputRecord.put(avroFieldName, (Object)longValue);
                        break;
                    }
                    case DECIMAL: {
                        Conversions.DecimalConversion converter = new Conversions.DecimalConversion();
                        if (defaultValue != null && defaultValue.length() > 0) {
                            BigDecimal defaultBigDecimal = new BigDecimal(iAvroOutputField.getDefaultValue());
                            BigDecimal bigDecimal = row.getBigNumber(fieldMetaIndex, defaultBigDecimal);
                            LogicalTypes.Decimal decimalType = LogicalTypes.decimal((int)bigDecimal.precision(), (int)bigDecimal.scale());
                            ByteBuffer byteBuffer = converter.toBytes(bigDecimal, this.schema, (LogicalType)decimalType);
                            outputRecord.put(avroFieldName, (Object)byteBuffer);
                            break;
                        }
                        BigDecimal bigDecimal = row.getBigNumber(fieldMetaIndex, null);
                        if (bigDecimal != null) {
                            bigDecimal = bigDecimal.round(new MathContext(iAvroOutputField.getPrecision(), RoundingMode.HALF_UP)).setScale(iAvroOutputField.getScale(), RoundingMode.HALF_UP);
                            LogicalTypes.Decimal decimalType = LogicalTypes.decimal((int)bigDecimal.precision(), (int)bigDecimal.scale());
                            ByteBuffer byteBuffer = converter.toBytes(bigDecimal, this.schema, (LogicalType)decimalType);
                            outputRecord.put(avroFieldName, (Object)byteBuffer);
                            break;
                        }
                        outputRecord.put(avroFieldName, null);
                        break;
                    }
                    case INTEGER: {
                        Long tmpLong = null;
                        tmpLong = row.isEmptyValue(pentahoFieldName) ? (defaultValue != null && defaultValue.length() > 0 ? Long.valueOf(Long.parseLong(defaultValue)) : null) : Long.valueOf(row.getInteger(fieldMetaIndex, 0L));
                        outputRecord.put(avroFieldName, (Object)(tmpLong != null ? new Integer(tmpLong.intValue()) : null));
                        break;
                    }
                    case STRING: {
                        if (defaultValue != null) {
                            outputRecord.put(avroFieldName, (Object)row.getString(fieldMetaIndex, String.valueOf(defaultValue)));
                            break;
                        }
                        outputRecord.put(avroFieldName, (Object)row.getString(fieldMetaIndex, null));
                        break;
                    }
                    case BYTES: {
                        if (defaultValue != null) {
                            outputRecord.put(avroFieldName, (Object)ByteBuffer.wrap(row.getBinary(fieldMetaIndex, vmi.getBinary((Object)defaultValue.getBytes()))));
                            break;
                        }
                        byte[] bytes = row.getBinary(fieldMetaIndex, null);
                        outputRecord.put(avroFieldName, (Object)(bytes != null ? ByteBuffer.wrap(bytes) : null));
                        break;
                    }
                    case TIMESTAMP_MILLIS: {
                        Date timeStamp;
                        Date defaultTimeStamp = null;
                        if (defaultValue != null && defaultValue.length() > 0) {
                            String conversionMask = vmi.getConversionMask() == null ? ValueMetaBase.DEFAULT_TIMESTAMP_PARSE_MASK : vmi.getConversionMask();
                            SimpleDateFormat dateFormat = new SimpleDateFormat(conversionMask);
                            try {
                                defaultTimeStamp = dateFormat.parse(defaultValue);
                            }
                            catch (ParseException pe) {
                                defaultTimeStamp = null;
                            }
                        }
                        outputRecord.put(avroFieldName, (timeStamp = row.getDate(fieldMetaIndex, defaultTimeStamp)) != null ? Long.valueOf(timeStamp.getTime()) : null);
                    }
                }
            }
        }
        catch (ArithmeticException e) {
            throw new IllegalArgumentException("The date has too much day from epoch day!", e);
        }
        catch (KettleValueException e) {
            throw new IllegalArgumentException("some exception while writing avro", e);
        }
        return outputRecord;
    }

    private double applyScale(double number, IAvroOutputField outputField) {
        if (outputField.getScale() > 0) {
            BigDecimal bd = new BigDecimal(number);
            bd = bd.setScale(outputField.getScale(), 4);
            number = bd.doubleValue();
        }
        return number;
    }

    private float applyScale(float number, IAvroOutputField outputField) {
        if (outputField.getScale() > 0) {
            BigDecimal bd = new BigDecimal(number);
            bd = bd.setScale(outputField.getScale(), 4);
            number = bd.floatValue();
        }
        return number;
    }

    public void close() throws IOException {
        this.nativeAvroRecordWriter.close();
    }
}

